; DrafTools   [Version 1.00] 9/25/93       
;
; ***************************************
; ****  Author:  Owen Wengerd        ****
; ****                               ****
; ****  Manu-Soft Computer Services  ****
; ****  P.O. Box 84                  ****
; ****  Fredericksburg, OH  44627    ****
; ****  (216) 695-5903               ****
; ****  Compu-Serve ID:  71324,3252  ****
; ***************************************


(defun C:RE-ORDER (/ 


;*** Local Variables ***

  attrib_list 
  cnt 
  dcl_id 
  dlg_retcode 
  errflag 
  last_focus 
  oldvar 
  olderr
  reorder_list 
  restore
  ss_attrib
  ss_reorder 
  t1 
  t2 


; *** Local Functions ***

  errexit
  re-orderx
  add_attrib
  check_edattrib
  clear_err
  dismiss_dialog
  dlg_act
  err
  fpath
  get_default_ip
  get_help
  is_visible
  no_select
  parse_ss
  update_attrib_list
  update_reorder_list
  )


; *******************  Function Definitions  ******************

(defun errexit (s)
  (princ "\nError:  ")
  (princ s)
  (restore)
)

(defun re-orderx ()
  (setvar "SORTENTS" (nth 1 oldvar))
  (setvar "REGENMODE" (nth 2 oldvar))
  (setvar "EXPERT" (nth 3 oldvar))
  (if (/= 1 (setq t1 (logand 3 (nth 4 oldvar))))
    (progn
      (command "_UNDO")
      (if (/= 0 (logand 3 (getvar "UNDOCTL"))) (command "_C"))
      (command (if (= 0 t1) "_N" "_O"))
    )
  )
  (setvar "CMDECHO" (car oldvar))
  (setq *error* olderr)
  (princ)
)

(defun dlg_act (key why value / t1 t2 t3 cnt)
  (cond
    ( (and errflag (/= errflag key)) 
    )
    ( (= key "get")   
      (if
        (add_attrib (ssget "X" '((0 . "ATTDEF"))))
        (update_attrib_list nil)
      )
    )
    ( (= key "selection")
      (setq ss_attrib value)
      (update_attrib_list T)
    )
    ( (= key "new_order")
      (setq ss_reorder value)
      (update_reorder_list T)
    )
    ( (= key "all")  
      (setq t1  ""
            cnt (length attrib_list)
      )
      (setq ss_attrib
        (repeat cnt 
          (setq cnt (1- cnt))
          (setq t1 (strcat t1 " " (itoa cnt)))
        )
      )
      (update_attrib_list nil)
    )
    ( (= key "none")
      (setq ss_attrib "")
      (update_attrib_list nil)
    )
    ( (= key "ro_all")  
      (setq t1  ""
            cnt (length reorder_list)
      )
      (setq ss_reorder
        (repeat cnt 
          (setq cnt (1- cnt))
          (setq t1 (strcat t1 " " (itoa cnt)))
        )
      )
      (update_reorder_list nil)
    )
    ( (= key "ro_none")
      (setq ss_reorder "")
      (update_reorder_list nil)
    )
    ( (= key "erase")
      (if 
        (and (setq t2 (new_dialog "ERASE" dcl_id)) (= 1 (start_dialog)))
        (done_dialog 5)
        (if (not t2) 
          (alert "Child Dialog Box 'ERASE' Cannot Initialize")
        )
      )
    )
    ( (= key "add")
      (setq t2 (length reorder_list))
      (foreach ent 
        (setq t1 (parse_ss ss_attrib))
        (if (not (member (setq cnt (nth ent attrib_list)) reorder_list))
          (setq reorder_list 
            (append reorder_list (list cnt))
          )
        )
      )
      (setq attrib_list (remove_list attrib_list t1))
      (setq ss_attrib "")
      (update_attrib_list nil)
      (if (< t2 (setq cnt (length reorder_list)))
        (progn
          (setq t1  "")
          (setq ss_reorder
            (repeat (- cnt t2) 
              (setq cnt (1- cnt))
              (setq t1 (strcat t1 " " (itoa cnt)))
            )
          )
          (update_reorder_list nil)
        )
      )
      (mode_tile "new_order" 2)
    )
    ( (= key "insert")
      (setq 
        t3   
           (if reorder_list
             (member 
               (setq t1 (nth (atoi ss_reorder) reorder_list)) 
               reorder_list
             )
           )
        reorder_list (reverse (cdr (member t1 (reverse reorder_list))))
        t2 (length reorder_list)
      )
      (foreach ent 
        (setq t1 (parse_ss ss_attrib))
        (if 
          (and
            (not (member (setq cnt (nth ent attrib_list)) reorder_list))
            (not (member cnt t3))
          )
          (setq reorder_list 
            (append reorder_list (list cnt))
          )
        )
      )
      (setq attrib_list (remove_list attrib_list t1))
      (setq ss_attrib "")
      (update_attrib_list nil)
      (setq cnt (length reorder_list)
            reorder_list (append reorder_list t3)
      )
      (if (< t2 cnt)
        (progn
          (setq t1  "")
          (setq ss_reorder
            (repeat (- cnt t2) 
              (setq cnt (1- cnt))
              (setq t1 (strcat t1 " " (itoa cnt)))
            )
          )
          (update_reorder_list nil)
        )
      )
      (mode_tile "new_order" 2)
    )
    ( (= key "remove")
      (setq t2 (length attrib_list))
      (foreach ent 
        (setq t1 (parse_ss ss_reorder))
        (if (not (member (setq cnt (nth ent reorder_list)) attrib_list))
          (setq attrib_list 
            (append attrib_list (list cnt))
          )
        )
      )
      (setq reorder_list (remove_list reorder_list t1))
      (setq ss_reorder "")
      (update_reorder_list nil)
      (if (< t2 (setq cnt (length attrib_list)))
        (progn
          (setq t1  "")
          (setq ss_attrib
            (repeat (- cnt t2)
              (setq cnt (1- cnt))
              (setq t1 (strcat t1 " " (itoa cnt)))
            )
          )
          (update_attrib_list nil)
        )
      )
      (mode_tile "selection" 2)
    )
    ( (= key "reverse")
      (if (no_select ss_attrib)
        (progn
          (setq t2 ""
                t1 (length attrib_list)
          )
          (foreach cnt (parse_ss ss_attrib)
            (setq t2 (strcat t2 " " (itoa (- t1 cnt 1))))
          )
          (setq ss_attrib t2)
        )
      )
      (setq attrib_list (reverse attrib_list))
      (update_attrib_list nil)
    )
    ( (= key "clear")
      (setq attrib_list (remove_list attrib_list (parse_ss ss_attrib)))
      (setq ss_attrib "")
      (update_attrib_list nil)
      (mode_tile "selection" 2)
    )
  )
  (if errflag (mode_tile errflag 2) (setq last_focus key))
)

(defun clear_err ()
  (set_tile "error" "")
  (setq errflag nil)
)

(defun err (msg key)
  (set_tile "error" msg)
  (setq errflag key)
)     

(defun is_visible (pt)
  (if
    (and
      pt
      (listp pt)
      (<= 
        (abs (- (car (getvar "VIEWCTR")) (car pt))) 
        (* (getvar "VIEWSIZE") (apply '/ (getvar "SCREENSIZE")) 0.5)
      )
      (<=
        (abs (- (cadr (getvar "VIEWCTR")) (cadr pt)))
        (/ (getvar "VIEWSIZE") 2)
      )
    )
    pt
  )
)

(defun get_default_ip (ent / pt)
  (if
    (or
      (and ent (setq pt (cdr (assoc '10 (entget ent)))))
      (setq pt (is_visible '(0 0 0)))
      (setq pt (is_visible (getvar "LASTPOINT")))
    )
    pt
    (getvar "VIEWCTR")
  )
)

(defun no_select (ss)
  (and ss (/= ss "") (not (wcmatch ss " ")))
)

(defun check_edattrib (retcode / t1)
  (if 
    (or 
      (= 'LIST (type edattrib)) 
      (and 
        (setq t1 (fpath "EDATTRIB.LSP")) 
        (load t1) 
        (= 'LIST (type edattrib))
      )
    )
    (done_dialog retcode)
    (alert
      (if t1 
        "Function 'EDATTRIB' is not defined\n     in file 'EDATTRIB.LSP'"
        "Cannot find file 'EDATTRIB.LSP' in\n       current search path"
      )
    )
  )
)

(defun parse_ss (ss / ret)
  (if (no_select ss)
    (progn
      (while (/= ss "")    
        (setq ret (cons (atoi ss) ret))
        (while (and (/= ss "") (= " " (substr ss 1 1)))
          (setq ss (substr ss 2))
        )
        (while (and (/= ss "") (/= " " (substr ss 1 1)))
          (setq ss (substr ss 2))
        )
      )
      (reverse ret)
    )
  )
)

(defun remove_list (lst xentlist / t1)
  (foreach ent
    xentlist
    (setq lst (subst nil (nth ent lst) lst))
  )
  (foreach ent lst (if ent (setq t1 (append t1 (list ent)))))
  t1
)

(defun fpath (filename / path)
  (if 
    (and
      *DT_PATH 
      (setq path
        (findfile 
          (strcat 
            *DT_PATH 
            (if (= "\\" (substr *DT_PATH (strlen *DT_PATH) 1)) "" "\\") 
            filename
          )
        )
      )
    )
    path
    (findfile filename)
  )
)

(defun add_attrib (set / t1 cnt len)
  (setq len (length attrib_list))
  (if set
    (progn  
      (setq cnt (1- (sslength set)))
      (while (>= cnt 0)
        (if (not (assoc (setq t1 (ssname set cnt)) attrib_list))
          (setq attrib_list 
            (append attrib_list 
              (list 
                (cons
                  t1 
                  (cdr (assoc '2 (entget t1)))
                )
              )
            )
          )
        )
        (setq cnt (1- cnt))
      )
      (setq t1  ""
            cnt (length attrib_list)
      )
      (setq ss_attrib
        (repeat (- cnt len)
          (setq cnt (1- cnt))
          (setq t1 (strcat t1 " " (itoa cnt)))
        )
      )
    )
  )
  (/= len (length attrib_list))
)

(defun update_attrib_list (only_selection / t1)
  (if attrib_list
    (progn
      (if (not only_selection)
        (progn
          (start_list "selection")
          (foreach t1 attrib_list (add_list (cdr t1)))
          (end_list)
        )
      )
      (if (no_select ss_attrib)
        (progn
          (set_tile "selection" ss_attrib)
          (setq ss_attrib (get_tile "selection"))
          (set_tile "sslength" 
            (itoa (setq t1 (length (parse_ss ss_attrib))))
          )
          (mode_tile "edit" (if (= 1 t1) 0 1))
          (foreach t1 
            '("erase" "insert" "add" "clear")
            (mode_tile t1 0)
          )
        )
        (progn
          (set_tile "selection" "")
          (set_tile "sslength" "None")
          (foreach t1 
            '("edit" "erase" "insert" "add" "clear")
            (mode_tile t1 1)
          )
        )
      )
      (foreach t1 '("all" "none" "reverse") (mode_tile t1 0))
    )
    (progn
      (start_list "selection")
      (end_list)
      (foreach t1 
        '("edit" "erase" "insert" "add" "all" "none" "reverse" "clear")
        (mode_tile t1 1)
      )
      (set_tile "sslength" "None")
    )
  )
)

(defun update_reorder_list (only_selection / t1)
  (if reorder_list
    (progn
      (if (not only_selection)
        (progn
          (start_list "new_order")
          (foreach t1 reorder_list (add_list (cdr t1)))
          (end_list)
        )
      )
      (if (no_select ss_reorder)
        (progn
          (set_tile "new_order" ss_reorder)
          (setq ss_reorder (get_tile "new_order"))
          (set_tile "ro_length" 
            (itoa (length (parse_ss ss_reorder)))
          )
          (mode_tile "remove" 0)
        )
        (progn
          (set_tile "ro_length" "None")
          (set_tile "new_order" "")
          (mode_tile "remove" 1)
        )
      )
      (foreach t1 
        '("ro_all" "ro_none" "re-order" "new_order")
        (mode_tile t1 0)
      )
    )
    (progn
      (start_list "new_order")
      (end_list)
      (foreach t1 
        '("ro_all" "ro_none" "re-order" "new_order" "remove")
        (mode_tile t1 1)
      )
      (set_tile "ro_length" "None")
    )
  )
)

(defun get_help (/ help_path)
  (if (setq help_path (fpath "RE-ORDER.HLP"))
    (acad_helpdlg help_path "")
    (alert "Cannot locate help file 'RE-ORDER.HLP'!")
  )
  (mode_tile (if errflag errflag last_focus) 2)
)

(defun dismiss_dialog (retcode)
  (if errflag
    (mode_tile errflag 2)  
    (done_dialog retcode)
  )
)


; ********************************************************
; ********************  MAIN PROGRAM  ********************
; ********************************************************

  (setq T (not nil))
  (if 
    (setq dcl_id (if (setq t1 (fpath "RE-ORDER.DCL")) (load_dialog t1)))
    (progn
      (setq oldvar
        (list
          (getvar "CMDECHO")
          (getvar "SORTENTS")
          (getvar "REGENMODE")
          (getvar "EXPERT")
          (getvar "UNDOCTL")
        )
      )
      (setq olderr  *error*
            restore re-orderx
            *error* errexit
      )
      (setvar "CMDECHO" 0)
      (setvar "REGENMODE" 1)
      (setvar "EXPERT" 0)
      (if (/= 1 (setq t1 (logand 3 (getvar "UNDOCTL"))))
        (progn
          (command "_UNDO") 
          (if (/= 0 t1) (command "_C")) 
          (command "_A")
        )
      )
      (setvar "SORTENTS" (logior 1 (getvar "SORTENTS")))
      (terpri)
      (setq dlg_retcode   6
            last_focus    "selection"
      )
      (while (and (> dlg_retcode 1) (new_dialog "RE_ORDER" dcl_id))
        (update_attrib_list nil)
        (update_reorder_list nil)
        (if (not (ssget "X" '((0 . "ATTDEF"))))
          (progn
            (mode_tile "select" 1)
            (mode_tile "get" 1)
          )
        )
        (action_tile "help" "(get_help)")
        (action_tile "select" "(dismiss_dialog 2)")
        (action_tile "accept" "(done_dialog 1)")
        (action_tile "cancel" "(done_dialog 0)")
        (action_tile "edit" "(check_edattrib 4)")
        (action_tile "new" "(check_edattrib 3)")
        (foreach t1
          '("get"          "selection"    "all"          "none"         
            "insert"       "remove"       "add"          "new_order"    
            "ro_all"       "ro_none"      "erase"        "reverse"
            "clear"
          )
          (action_tile t1 "(dlg_act $key $reason $value)")
        )
        (if last_focus (mode_tile last_focus 2))
        (setq dlg_retcode (start_dialog))
        (cond
          ( (= 0 dlg_retcode))
          (
            (= 2 dlg_retcode)
            (add_attrib (ssget '((0 . "ATTDEF"))))
            (princ "\nReturning to Dialog Box\n \n ")
            (setq last_focus "select")
          )
          (
            (= 3 dlg_retcode)
            (command 
              cancel
              cancel
              "_ATTDEF"
              ""
              "???"
              ""
              ""
              (get_default_ip nil)
              ""
              ""
            )
            (if (= 1 (edattrib (entlast)))
              (setq attrib_list 
                (append attrib_list 
                  (list (cons (entlast) (cdr (assoc '2 (entget (entlast))))))
                )
              )
              (command "_U")
            )
            (princ "\nReturning to Dialog Box\n \n ")
          )
          (
            (= 4 dlg_retcode)
            (edattrib (setq t1 (car (nth (atoi ss_attrib) attrib_list))))
            (setq attrib_list
              (subst 
                (cons t1 (cdr (assoc '2 (entget t1)))) 
                (assoc t1 attrib_list) 
                attrib_list
              )
            )
            (princ "\nReturning to Dialog Box\n \n ")
          )
          (
            (= 5 dlg_retcode)
            (setq t2 (ssadd))
            (foreach ent 
              (setq t1 (parse_ss ss_attrib))
              (ssadd (car (nth ent attrib_list)) t2)
            )
            (command "_ERASE" t2 "")
            (setq attrib_list (remove_list attrib_list t1))
            (setq ss_attrib "")
          )
          (T 
            (if reorder_list
              (progn
                (command "_BLOCK" 
                          "TEMP" 
                )
                (if (tblsearch "BLOCK" "TEMP") (command "_Y"))
                (command '(0 0)) 
                (foreach t1 reorder_list (command (car t1))) 
                (command "" "_INSERT" "*TEMP" '(0 0) 1 0)
              )
            )
          )
        )
      )
      (unload_dialog dcl_id)
      (restore)
    )
    (alert 
      (strcat 
        "Dialog Box Definition File 'EDATTRIB.DCL' not Found"
        "\n                Cannot Continue!"
      )
    )
  )
)
