/*This program features a function which retrieves a dword from any specified
location in extended memory.  The function illustrates inline protected-mode
assembly.  TASM is used for assembly rather than the internal assembler
because TASM can handle 32-bit instructions.  Since this program addresses
extended memory which has not been allocated, it may fail with a page fault
if page protection is being enforced.*/

#pragma inline                       /*Invoke TASM*/
#include <stdio.h>
#include <xlibb.h>

long far getextmem(long address);

int goterr = 0;                      /*Error flag*/

void main(void)
{
  long l, xaddress;

  l = INITXLIB();                    /*Initialize XLIB*/
  if(l != 0)                         /*See if an error occurred*/
  {
    printf("Library initialization error:  %lX\n",l);
    return;
  }

  xaddress = 0x100000;               /*Read the first dword in 2ond meg*/
  l = getextmem(xaddress);
  if(goterr != 0)                    /*See if an error occurred*/
  {
    printf("Inline mode-switch error:  %lX\n",l);
    return;
  }
  printf("[%lX] = %lX\n",xaddress,l);
}

long far getextmem(long address)
{
  asm{
    .386                            /*Enable 32-bit assembly*/
    mov       eax,address
    call      far ptr INLINEPM      /*Switch to 16-bit protected mode*/
    jc        error                 /*Error code returned in ax*/
    mov       ds,es:FLATDSEL        /*Switch to flat data model*/
    push      dword ptr [eax]       /*Read the requested address*/
    pop       ax                    /*Return result in dx:ax*/
    pop       dx
    call      dword ptr es:INLINERMPTR  /*Switch to real-mode by calling*/
    jmp       done                      /*far pointer in XLIB.  A direct*/
                                        /*far call would load CS with an*/
                                        /*invalid value*/
  }
error:
  asm{
    xor       dx,dx                 /*Return error code in dx:ax*/
    inc       goterr
    .286                            /*Restore 16-bit assembly*/
  }
done:
}
