-- lines.e
-- show how many lines and characters there are in a file or bunch of files
-- usage: lines.bat files...
-- example: lines *.e

constant SCREEN = 1
constant TRUE = 1

function scan(integer fileNum) 
-- count lines, non-blank lines, characters
    object line
    integer lines, nb_lines, chars

    lines = 0
    nb_lines = 0
    chars = 0
    while TRUE do
	line = gets(fileNum)
	if atom(line) then
	    return {nb_lines, lines, chars} -- end of file
	else
	    lines = lines + 1
	    chars = chars + length(line) + 1 -- add 1 to match dir cmd
	    if find(TRUE, line != ' ' and line != '\t' and line != '\n') then
		nb_lines = nb_lines + 1
	    end if
	end if
    end while
end function

include getnames.e

procedure lines()
-- process all files 
    integer fileNum
    sequence count, total_count
    sequence file_names

    -- gather file names
    file_names = get_names()
    if length(file_names) = 0 then
	return
    end if
    -- process all files    
    total_count = {0, 0, 0}
    puts(SCREEN, "non-blank-lines   lines   chars\n")
    for i = 1 to length(file_names) do
        fileNum = open(file_names[i], "r")   
        if fileNum = -1 then
            printf(SCREEN, "cannot open %s\n", {file_names[i]})
        else
	    count = scan(fileNum)
	    total_count = total_count + count
	    printf(SCREEN, "       %8d%8d%8d %s\n", count & {file_names[i]})
	    close(fileNum)
        end if
    end for
    printf(SCREEN, "       %8d%8d%8d total\n", total_count)
end procedure

lines()

