/* ============================================================= */
/*  Rob Hamerling's MAXIMUS DOWNload file SORT and list utility. */
/*  -> DOWNFNT.C                                                 */
/*  -> Block font definitions and generation routine.            */
/* ============================================================= */

#define INCL_BASE
#define INCL_NOPMAPI
#include <os2.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "downsort.h"

struct _b8_patt {                       /* 8 column font */
        unsigned int c0:3, c1:3, c2:3, c3:3, c4:3, c5:3, c6:3, c7:3; };
struct _b8x5 {                          /* all fonts defined as 8x5 */
         char           c;              /* the character */
         unsigned char  k;              /* number of active columns */
         struct _b8_patt p[5];          /* 8 column x 5 lines pattern */
           };

static struct _b8x5 f1[] = {            /* simple 5x3 font */
    {'A',6, 1,2,2,2,1,0,0,0, 3,1,1,1,3,0,0,0, 3,0,0,0,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'B',6, 3,2,2,2,1,0,0,0, 3,2,2,2,1,0,0,0, 3,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'C',6, 1,2,2,2,1,0,0,0, 3,0,0,0,0,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'D',6, 3,2,2,2,1,0,0,0, 3,0,0,0,3,0,0,0, 3,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'E',6, 3,2,2,2,2,0,0,0, 3,2,2,0,0,0,0,0, 3,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'F',6, 3,2,2,2,2,0,0,0, 3,1,1,0,0,0,0,0, 3,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'G',6, 1,2,2,2,1,0,0,0, 3,0,0,1,1,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'H',6, 3,0,0,0,3,0,0,0, 3,1,1,1,3,0,0,0, 3,0,0,0,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'I',4, 2,3,2,0,0,0,0,0, 0,3,0,0,0,0,0,0, 1,3,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'J',6, 0,2,2,2,3,0,0,0, 0,0,0,0,3,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'K',6, 3,0,0,1,2,0,0,0, 3,2,2,1,0,0,0,0, 3,0,0,0,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'L',6, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'M',6, 3,1,0,1,3,0,0,0, 3,2,3,2,3,0,0,0, 3,0,0,0,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'N',6, 3,1,0,0,3,0,0,0, 3,2,3,1,3,0,0,0, 3,0,0,2,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'O',6, 1,2,2,2,1,0,0,0, 3,0,0,0,3,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'P',6, 3,2,2,2,1,0,0,0, 3,1,1,1,2,0,0,0, 3,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'Q',6, 1,2,2,2,1,0,0,0, 3,0,1,0,3,0,0,0, 2,1,1,2,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'R',6, 3,2,2,2,1,0,0,0, 3,1,1,1,2,0,0,0, 3,0,2,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'S',6, 1,2,2,2,2,0,0,0, 0,2,2,2,1,0,0,0, 1,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'T',6, 2,2,3,2,2,0,0,0, 0,0,3,0,0,0,0,0, 0,0,3,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'U',6, 3,0,0,0,3,0,0,0, 3,0,0,0,3,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'V',6, 3,0,0,0,3,0,0,0, 3,1,0,1,3,0,0,0, 0,2,3,2,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'W',6, 3,0,0,0,3,0,0,0, 3,0,1,0,3,0,0,0, 2,3,2,3,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'X',6, 2,1,0,1,2,0,0,0, 0,0,3,0,0,0,0,0, 1,2,0,2,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'Y',6, 3,0,0,0,3,0,0,0, 2,3,1,3,2,0,0,0, 0,0,3,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'Z',6, 2,2,2,2,3,0,0,0, 0,1,2,2,0,0,0,0, 3,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'0',6, 1,2,2,3,1,0,0,0, 3,0,3,0,3,0,0,0, 2,3,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'1',4, 1,3,0,0,0,0,0,0, 0,3,0,0,0,0,0,0, 1,3,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'2',6, 1,2,2,2,1,0,0,0, 0,1,1,1,2,0,0,0, 3,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'3',6, 1,2,2,2,1,0,0,0, 0,0,2,2,1,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'4',6, 0,0,1,2,3,0,0,0, 1,2,0,0,3,0,0,0, 2,2,2,2,3,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'5',6, 3,2,2,2,2,0,0,0, 2,2,2,2,1,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'6',6, 1,2,2,2,0,0,0,0, 3,2,2,2,1,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'7',6, 2,2,2,2,3,0,0,0, 0,0,1,2,0,0,0,0, 0,3,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'8',6, 1,2,2,2,1,0,0,0, 1,2,2,2,1,0,0,0, 2,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'9',6, 1,2,2,2,1,0,0,0, 2,1,1,1,3,0,0,0, 0,1,1,1,2,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'_',6, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 1,1,1,1,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'*',6, 1,0,1,0,1,0,0,0, 1,3,2,3,1,0,0,0, 1,2,3,2,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'-',4, 0,0,0,0,0,0,0,0, 1,1,1,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'|',2, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'.',2, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'(',4, 0,1,2,0,0,0,0,0, 3,0,0,0,0,0,0,0, 0,2,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {')',4, 2,1,0,0,0,0,0,0, 0,0,3,0,0,0,0,0, 1,2,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'[',4, 3,2,2,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,1,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {']',4, 2,2,3,0,0,0,0,0, 0,0,3,0,0,0,0,0, 1,1,3,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'/',6, 0,0,0,0,1,0,0,0, 0,0,1,2,0,0,0,0, 1,2,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
   {'\\',6, 1,0,0,0,0,0,0,0, 0,2,1,0,0,0,0,0, 0,0,0,2,1,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'`',3, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'~',6, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {' ',4, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
        };

  static struct _b8x5 f2[] = {          /* 7x5 pseudo stencil            */
    {'A',8, 0,3,3,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,6,3,3,3,3,0,
            3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0},
    {'B',8, 3,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,6,3,3,3,0,0,
            3,3,0,0,0,3,3,0, 3,3,6,3,3,3,0,0},
    {'C',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,0,0,0,
            3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'D',8, 3,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0,
            3,3,0,0,0,3,3,0, 3,3,6,3,3,3,0,0},
    {'E',8, 3,3,6,3,3,3,3,0, 3,3,0,0,0,0,0,0, 3,3,6,3,3,0,0,0,
            3,3,0,0,0,0,0,0, 3,3,6,3,3,3,3,0},
    {'F',8, 3,3,6,3,3,3,3,0, 3,3,0,0,0,0,0,0, 3,3,6,3,3,0,0,0,
            3,3,0,0,0,0,0,0, 3,3,0,0,0,0,0,0},
    {'G',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,0,0,0,
            3,3,0,0,2,3,3,0, 3,3,6,3,3,3,0,0},
    {'H',8, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0, 3,3,6,3,3,3,3,0,
            3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0},
    {'I',6, 3,6,3,3,3,0,0,0, 0,6,3,3,0,0,0,0, 0,6,3,3,0,0,0,0,
            0,6,3,3,0,0,0,0, 3,6,3,3,3,0,0,0},
    {'J',8, 0,0,0,0,0,3,3,0, 0,0,0,0,0,3,3,0, 0,0,0,0,0,3,3,0,
            3,6,0,0,0,3,3,0, 0,6,3,3,3,3,2,0},
    {'K',8, 3,3,0,0,0,3,3,0, 3,3,0,3,3,0,0,0, 3,3,6,3,0,0,0,0,
            3,3,0,3,3,0,0,0, 3,3,0,0,0,3,3,0},
    {'L',8, 3,3,0,0,0,0,0,0, 3,3,0,0,0,0,0,0, 3,3,0,0,0,0,0,0,
            3,3,0,0,0,0,0,0, 3,3,6,3,3,3,3,0},
    {'M',8, 3,3,6,3,3,3,3,0, 3,3,0,3,0,3,3,0, 3,3,0,3,0,3,3,0,
            3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0},
    {'N',7, 3,3,6,3,3,3,0,0, 3,3,0,0,3,3,0,0, 3,3,0,0,3,3,0,0,
            3,3,0,0,3,3,0,0, 3,3,0,0,3,3,0,0},
    {'O',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0,
            3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'P',8, 3,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,6,3,3,3,0,0,
            3,3,0,0,0,0,0,0, 3,3,0,0,0,0,0,0},
    {'Q',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0,
            3,3,0,0,3,3,0,0, 0,3,6,3,3,0,3,0},
    {'R',8, 3,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 3,3,6,3,3,3,0,0,
            3,3,0,3,0,0,0,0, 3,3,0,0,3,3,0,0},
    {'S',8, 3,3,6,3,3,3,3,0, 3,3,0,0,0,0,0,0, 3,3,6,3,3,3,3,0,
            0,0,0,0,0,3,3,0, 3,3,6,3,3,3,3,0},
    {'T',8, 3,3,6,3,3,3,3,0, 0,0,6,3,3,0,0,0, 0,0,6,3,3,0,0,0,
            0,0,6,3,3,0,0,0, 0,0,6,3,3,0,0,0},
    {'U',8, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0,
            3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'V',8, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0,
            0,3,6,0,3,3,0,0, 0,0,6,3,3,0,0,0},
    {'W',8, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0, 3,3,0,3,0,3,3,0,
            3,3,0,3,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'X',8, 3,3,0,0,0,3,3,0, 0,3,6,0,3,3,0,0, 0,0,6,3,3,0,0,0,
            0,3,6,0,3,3,0,0, 3,3,0,0,0,3,3,0},
    {'Y',8, 3,3,0,0,0,3,3,0, 3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0,
            0,0,0,3,3,0,0,0, 0,0,0,3,3,0,0,0},
    {'Z',8, 3,6,3,3,3,3,3,0, 0,0,0,0,3,3,0,0, 0,0,0,3,3,0,0,0,
            0,0,3,3,0,0,0,0, 3,6,3,3,3,3,3,0},
    {'0',8, 0,6,3,3,3,3,0,0, 3,6,0,0,0,3,3,0, 3,6,0,3,0,3,3,0,
            3,6,0,0,0,3,3,0, 0,6,3,3,3,3,0,0},
    {'1',5, 3,3,3,0,0,0,0,0, 0,3,3,0,0,0,0,0, 0,3,3,0,0,0,0,0,
            0,3,3,0,0,0,0,0, 3,3,3,3,0,0,0,0},
    {'2',8, 3,3,6,3,3,3,0,0, 0,0,0,0,3,3,3,0, 3,3,6,3,3,3,0,0,
            3,3,0,0,0,0,0,0, 3,3,6,3,3,3,3,0},
    {'3',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 0,0,0,0,3,3,0,0,
            3,3,6,0,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'4',8, 3,3,0,0,3,3,0,0, 3,3,0,0,3,3,0,0, 3,3,6,3,3,3,3,0,
            0,0,0,0,3,3,0,0, 0,0,0,0,3,3,0,0},
    {'5',8, 3,3,6,3,3,3,3,0, 3,3,0,0,0,0,0,0, 3,3,6,3,3,3,0,0,
            0,0,0,0,0,3,3,0, 3,3,6,3,3,3,0,0},
    {'6',8, 0,6,3,3,3,3,0,0, 3,6,0,0,0,0,0,0, 3,6,3,3,3,3,0,0,
            3,6,0,0,0,3,3,0, 0,6,3,3,3,3,0,0},
    {'7',8, 3,6,3,3,3,3,0,0, 0,0,0,0,0,3,3,0, 0,0,0,3,3,0,0,0,
            0,0,3,3,0,0,0,0, 0,0,3,3,0,0,0,0},
    {'8',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0,
            3,3,0,0,0,3,3,0, 0,3,6,3,3,3,0,0},
    {'9',8, 0,3,6,3,3,3,0,0, 3,3,0,0,0,3,3,0, 0,3,6,3,3,3,3,0,
            0,0,0,0,0,3,3,0, 0,3,6,3,3,3,3,0},
    {'_',7, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 3,6,3,3,3,3,0,0},
    {'*',8, 0,3,0,6,0,3,0,0, 0,0,3,6,3,0,0,0, 3,3,3,0,3,3,3,0,
            0,0,3,6,3,0,0,0, 0,3,0,6,0,3,0,0},
    {'-',5, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 3,6,3,3,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'|',3, 3,6,0,0,0,0,0,0, 3,6,0,0,0,0,0,0, 3,6,0,0,0,0,0,0,
            3,6,0,0,0,0,0,0, 3,6,0,0,0,0,0,0},
    {'.',3, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 3,6,0,0,0,0,0,0},
    {'(',5, 0,0,6,3,0,0,0,0, 0,3,6,0,0,0,0,0, 3,3,0,0,0,0,0,0,
            0,3,6,0,0,0,0,0, 0,0,6,3,0,0,0,0},
    {')',5, 3,5,0,0,0,0,0,0, 0,5,3,0,0,0,0,0, 0,0,3,3,0,0,0,0,
            0,5,3,0,0,0,0,0, 3,5,0,0,0,0,0,0},
    {'[',4, 3,6,3,0,0,0,0,0, 3,6,0,0,0,0,0,0, 3,6,0,0,0,0,0,0,
            3,6,0,0,0,0,0,0, 3,6,3,0,0,0,0,0},
    {']',4, 3,5,3,0,0,0,0,0, 0,5,3,0,0,0,0,0, 0,5,3,0,0,0,0,0,
            0,5,3,0,0,0,0,0, 3,5,3,0,0,0,0,0},
    {'/',7, 0,0,0,0,3,3,0,0, 0,0,0,3,3,0,0,0, 0,0,6,3,0,0,0,0,
            0,3,6,0,0,0,0,0, 3,3,0,0,0,0,0,0},
   {'\\',7, 3,3,0,0,0,0,0,0, 0,3,6,0,0,0,0,0, 0,0,6,3,0,0,0,0,
            0,0,0,3,3,0,0,0, 0,0,0,0,3,3,0,0},
    {'`',4, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'~',8, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {' ',6, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
     };

  static struct _b8x5 f3[] = {          /* 7x4 robo-computer font        */
    {'A',8, 0,3,2,2,2,3,0,0, 1,3,1,1,1,3,1,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'B',8, 3,2,2,2,2,3,0,0, 3,1,1,1,1,1,3,0, 3,3,0,0,0,0,3,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'C',8, 3,2,2,2,2,2,3,0, 3,1,0,0,0,0,0,0, 3,3,0,0,0,0,0,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'D',8, 3,2,2,2,2,2,3,0, 3,1,0,0,0,0,3,0, 3,3,0,0,0,0,3,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'E',8, 3,2,2,2,2,2,2,0, 3,1,1,1,1,1,1,0, 3,3,0,0,0,0,0,0,
            3,3,1,1,1,1,1,0, 0,0,0,0,0,0,0,0},
    {'F',8, 3,2,2,2,2,2,2,0, 3,1,1,1,1,1,1,0, 3,3,0,0,0,0,0,0,
            3,3,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'G',8, 3,2,2,2,2,2,3,0, 3,1,0,0,1,1,1,0, 3,3,0,0,0,0,3,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'H',8, 3,0,0,0,0,0,3,0, 3,1,1,1,1,1,3,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'I',5, 0,3,0,0,0,0,0,0, 0,3,1,0,0,0,0,0, 0,3,3,0,0,0,0,0,
            0,3,3,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'J',8, 0,0,0,0,0,3,0,0, 0,0,0,0,0,3,1,0, 0,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'K',8, 3,0,0,0,3,0,0,0, 3,1,1,3,1,1,1,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'L',8, 3,0,0,0,0,0,0,0, 3,1,0,0,0,0,0,0, 3,3,0,0,0,0,0,0,
            3,3,1,1,1,1,1,0, 0,0,0,0,0,0,0,0},
    {'M',8, 3,2,2,3,2,2,3,0, 3,1,0,3,0,0,3,0, 3,3,0,3,0,0,3,0,
            3,3,0,3,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'N',8, 3,2,2,2,2,2,3,0, 3,1,0,0,0,0,3,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'O',8, 3,2,2,2,3,3,3,0, 3,0,0,0,0,2,3,0, 3,0,0,0,0,0,3,0,
            3,1,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'P',8, 3,2,2,2,2,2,3,0, 3,1,1,1,1,1,3,0, 3,3,0,0,0,0,0,0,
            3,3,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'Q',8, 3,2,2,2,2,2,3,0, 3,0,0,0,0,0,3,0, 3,0,0,0,0,0,3,0,
            3,1,1,3,3,3,3,0, 0,0,0,0,0,0,0,0},
    {'R',8, 3,2,2,2,2,3,0,0, 3,1,1,1,1,3,1,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'S',8, 3,2,2,2,2,2,3,0, 3,1,1,1,1,1,1,0, 0,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'T',8, 2,2,2,3,2,2,2,0, 0,0,0,3,1,0,0,0, 0,0,0,3,3,0,0,0,
            0,0,0,3,3,0,0,0, 0,0,0,0,0,0,0,0},
    {'U',8, 3,0,0,0,0,0,3,0, 3,1,0,0,0,0,3,0, 3,3,0,0,0,0,3,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'V',8, 3,3,0,0,0,0,3,0, 3,3,0,0,0,1,3,0, 0,3,0,0,0,3,0,0,
            0,3,1,1,1,3,0,0, 0,0,0,0,0,0,0,0},
    {'W',8, 3,0,0,3,0,0,3,0, 3,1,0,3,0,0,3,0, 3,3,0,3,0,0,3,0,
            3,3,1,3,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'X',8, 3,0,0,0,0,0,3,0, 2,1,1,1,1,1,2,0, 3,3,0,0,0,0,3,0,
            3,3,0,0,0,0,3,0, 0,0,0,0,0,0,0,0},
    {'Y',8, 3,0,0,0,0,0,3,0, 3,1,1,1,1,1,3,0, 0,0,0,3,3,0,0,0,
            0,0,0,3,3,0,0,0, 0,0,0,0,0,0,0,0},
    {'Z',8, 2,2,2,2,2,2,3,0, 1,1,1,1,1,1,3,0, 3,3,0,0,0,0,0,0,
            3,3,1,1,1,1,1,0, 0,0,0,0,0,0,0,0},
    {'0',8, 3,2,2,2,2,2,3,0, 3,0,0,0,0,1,3,0, 3,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'1',5, 0,0,3,0,0,0,0,0, 0,1,3,0,0,0,0,0, 0,3,3,0,0,0,0,0,
            0,3,3,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'2',8, 3,2,2,2,2,2,3,0, 0,0,0,0,0,0,3,0, 3,3,2,2,2,2,2,0,
            3,3,1,1,1,1,3,0, 0,0,0,0,0,0,0,0},
    {'3',8, 3,2,2,2,2,3,0,0, 0,1,1,1,1,3,1,0, 0,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'4',8, 3,0,0,0,0,3,0,0, 3,0,0,0,0,3,0,0, 3,1,1,1,1,3,1,0,
            0,0,0,0,3,3,0,0, 0,0,0,0,0,0,0,0},
    {'5',8, 3,2,2,2,2,2,2,0, 3,1,1,1,1,1,1,0, 0,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'6',8, 3,2,2,2,2,2,3,0, 3,1,1,1,1,1,1,0, 3,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'7',8, 2,2,2,2,2,2,3,0, 0,0,0,0,0,1,3,0, 0,0,0,0,0,3,3,0,
            0,0,0,0,0,3,3,0, 0,0,0,0,0,0,0,0},
    {'8',8, 0,3,2,2,2,3,0,0, 1,3,1,1,1,3,1,0, 3,0,0,0,0,3,3,0,
            3,1,1,1,1,3,3,0, 0,0,0,0,0,0,0,0},
    {'9',8, 3,2,2,2,2,2,3,0, 3,0,0,0,0,0,3,0, 2,2,2,2,2,3,3,0,
            0,0,0,0,0,3,3,0, 0,0,0,0,0,0,0,0},
    {'_',8, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            1,1,1,1,1,1,1,0, 0,0,0,0,0,0,0,0},
    {'*',8, 2,1,0,3,0,1,2,0, 1,1,3,2,3,1,1,0, 0,1,2,3,2,1,0,0,
            2,0,0,2,0,0,2,0, 0,0,0,0,0,0,0,0},
    {'-',5, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 3,3,3,3,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'|',2, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0,
            3,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'.',3, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            3,3,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'(',4, 0,1,2,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0,
            0,2,1,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {')',4, 2,1,0,0,0,0,0,0, 0,0,3,0,0,0,0,0, 0,0,3,0,0,0,0,0,
            1,2,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'[',4, 3,2,2,0,0,0,0,0, 3,0,0,0,0,0,0,0, 3,0,0,0,0,0,0,0,
            3,1,1,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {']',4, 2,2,3,0,0,0,0,0, 0,0,3,0,0,0,0,0, 0,0,3,0,0,0,0,0,
            1,1,3,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'/',5, 0,0,0,3,0,0,0,0, 0,0,3,0,0,0,0,0, 0,3,0,0,0,0,0,0,
            3,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
   {'\\',5, 3,0,0,0,0,0,0,0, 0,3,0,0,0,0,0,0, 0,0,3,0,0,0,0,0,
            0,0,0,3,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'`',4, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {'~',8, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
    {' ',6, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0},
      };

  static struct _b8x5 f4[] = {          /* 7x4 reversed video FONT3      */
    {'A',8, 3,2,2,2,2,2,3,3, 3,0,3,3,3,0,3,3, 0,0,1,1,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'B',8, 2,2,2,2,2,2,3,3, 0,3,3,3,3,1,2,3, 0,0,1,1,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'C',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,1,3, 0,0,3,3,3,3,3,3,
            0,0,3,3,3,3,2,3, 1,1,1,1,1,1,1,3},
    {'D',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,0,3,3,3,3,0,3,
            0,0,3,3,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'E',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,3,3, 0,0,1,1,1,1,1,3,
            0,0,3,3,3,3,3,3, 1,1,1,1,1,1,1,3},
    {'F',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,3,3, 0,0,1,1,1,1,1,3,
            0,0,3,3,3,3,3,3, 1,1,3,3,3,3,3,3},
    {'G',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,1,3, 0,0,3,3,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'H',8, 2,3,3,3,3,3,2,3, 0,3,3,3,3,3,0,3, 0,0,1,1,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'I',5, 3,2,3,3,3,3,3,3, 3,0,3,3,3,3,3,3, 3,0,0,3,3,3,3,3,
            3,0,0,3,3,3,3,3, 3,1,1,3,3,3,3,3},
    {'J',8, 3,3,3,3,3,2,3,3, 3,3,3,3,3,0,3,3, 3,3,3,3,3,0,0,3,
            2,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'K',8, 2,3,3,3,2,3,3,3, 0,3,3,2,1,3,3,3, 0,0,1,1,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'L',8, 2,3,3,3,3,3,3,3, 0,3,3,3,3,3,3,3, 0,0,3,3,3,3,3,3,
            0,0,3,3,3,3,3,3, 1,1,1,1,1,1,1,3},
    {'M',8, 2,2,2,2,2,2,2,3, 0,3,3,0,3,3,0,3, 0,0,3,0,3,3,0,3,
            0,0,3,0,3,3,0,3, 1,1,3,1,3,3,1,3},
    {'N',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,0,3,3,3,3,0,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'O',8, 2,2,2,2,2,2,2,3, 0,3,3,3,1,0,0,3, 0,3,3,3,3,3,0,3,
            0,3,3,3,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'P',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,0,1,1,1,1,1,3,
            0,0,3,3,3,3,3,3, 1,1,3,3,3,3,3,3},
    {'Q',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,3,3,3,3,3,0,3,
            0,3,3,3,2,2,0,3, 1,1,1,1,1,1,1,3},
    {'R',8, 2,2,2,2,2,2,3,3, 0,3,3,3,3,0,3,3, 0,0,1,1,1,1,0,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'S',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,1,3, 1,1,1,1,1,0,0,3,
            2,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'T',8, 2,2,2,2,2,2,2,3, 3,3,3,0,3,3,3,3, 3,3,3,0,0,3,3,3,
            3,3,3,0,0,3,3,3, 3,3,3,1,1,3,3,3},
    {'U',8, 2,3,3,3,3,3,2,3, 0,3,3,3,3,3,0,3, 0,0,3,3,3,3,0,3,
            0,0,3,3,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'V',8, 2,2,3,3,3,3,2,3, 0,0,3,3,3,3,0,3, 1,0,3,3,3,0,1,3,
            3,0,3,3,3,0,3,3, 3,1,1,1,1,1,3,3},
    {'W',8, 2,3,3,2,3,3,2,3, 0,3,3,0,3,3,0,3, 0,0,3,0,3,3,0,3,
            0,0,3,0,3,3,0,3, 1,1,1,1,1,1,1,3},
    {'X',8, 2,3,3,3,3,3,2,3, 0,3,3,3,3,3,0,3, 2,0,1,1,1,1,2,3,
            0,0,3,3,3,3,0,3, 1,1,3,3,3,3,1,3},
    {'Y',8, 2,3,3,3,3,3,2,3, 0,3,3,3,3,3,0,3, 1,1,1,0,0,1,1,3,
            3,3,3,0,0,3,3,3, 3,3,3,1,1,3,3,3},
    {'Z',8, 2,2,2,2,2,2,2,3, 3,3,3,3,3,3,0,3, 0,0,1,1,1,1,1,3,
            0,0,3,3,3,3,3,3, 1,1,1,1,1,1,1,3},
    {'0',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,3,3,3,3,0,0,3,
            0,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'1',5, 3,3,2,3,3,3,3,3, 3,3,0,3,3,3,3,3, 3,0,0,3,3,3,3,3,
            3,0,0,3,3,3,3,3, 3,1,1,3,3,3,3,3},
    {'2',8, 2,2,2,2,2,2,2,3, 1,3,3,3,3,3,0,3, 2,2,2,2,2,2,0,3,
            0,0,3,3,3,3,2,3, 1,1,1,1,1,1,1,3},
    {'3',8, 2,2,2,2,2,2,3,3, 1,3,3,3,3,0,3,3, 3,1,1,1,1,0,0,3,
            2,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'4',8, 2,3,3,3,3,2,3,3, 0,3,3,3,3,0,3,3, 0,3,3,3,3,0,3,3,
            1,1,1,1,0,0,1,3, 3,3,3,3,1,1,3,3},
    {'5',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,3,3, 1,1,1,1,1,0,0,3,
            2,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'6',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,1,3, 0,1,1,1,1,0,0,3,
            0,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'7',8, 2,2,2,2,2,2,2,3, 3,3,3,3,3,3,0,3, 3,3,3,3,3,0,0,3,
            3,3,3,3,3,0,0,3, 3,3,3,3,3,1,1,3},
    {'8',8, 3,2,2,2,2,2,3,3, 3,0,3,3,3,0,3,3, 0,1,1,1,1,0,0,3,
            0,3,3,3,3,0,0,3, 1,1,1,1,1,1,1,3},
    {'9',8, 2,2,2,2,2,2,2,3, 0,3,3,3,3,3,0,3, 0,2,2,2,2,2,0,3,
            3,3,3,3,3,0,0,3, 3,3,3,3,3,1,1,3},
    {'_',8, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3, 1,1,1,1,1,1,1,3},
    {'*',8, 2,3,3,2,3,3,2,3, 3,1,2,0,2,1,3,3, 1,1,0,2,0,1,1,3,
            2,1,3,0,3,1,2,3, 3,3,3,3,3,3,3,3},
    {'-',5, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 0,0,0,0,3,3,3,3,
            3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3},
    {'|',2, 2,3,3,3,3,3,3,3, 0,3,3,3,3,3,3,3, 0,3,3,3,3,3,3,3,
            0,3,3,3,3,3,3,3, 1,3,3,3,3,3,3,3},
    {'.',3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
            2,2,3,3,3,3,3,3, 1,1,3,3,3,3,3,3},
    {'(',4, 3,3,2,3,3,3,3,3, 2,1,3,3,3,3,3,3, 0,3,3,3,3,3,3,3,
            1,2,3,3,3,3,3,3, 3,3,1,3,3,3,3,3},
    {')',4, 2,3,3,3,3,3,3,3, 3,1,2,3,3,3,3,3, 3,3,0,3,3,3,3,3,
            3,2,1,3,3,3,3,3, 1,3,3,3,3,3,3,3},
    {'[',4, 2,2,2,3,3,3,3,3, 0,3,3,3,3,3,3,3, 0,3,3,3,3,3,3,3,
            0,3,3,3,3,3,3,3, 1,1,1,3,3,3,3,3},
    {']',4, 2,2,2,3,3,3,3,3, 3,3,0,3,3,3,3,3, 3,3,0,3,3,3,3,3,
            3,3,0,3,3,3,3,3, 1,1,1,3,3,3,3,3},
    {'/',5, 3,3,3,2,3,3,3,3, 3,3,2,1,3,3,3,3, 3,2,1,3,3,3,3,3,
            2,1,3,3,3,3,3,3, 1,3,3,3,3,3,3,3},
   {'\\',5, 2,3,3,3,3,3,3,3, 1,2,3,3,3,3,3,3, 3,1,2,3,3,3,3,3,
            3,3,1,2,3,3,3,3, 3,3,3,1,3,3,3,3},
    {'`',4, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3},
    {'~',8, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3},
    {' ',6, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3},
      };


  /* NOTE: the font-table automatically adjusts to the variable number   */
  /*       of elements in the font definition array's!                   */

static struct _font_tab {               /* font table structure          */
       short int  k;                    /* (max) number of columns       */
       short int  r;                    /* number of rows (lines)        */
       short int  n;                    /* number of pattern entries     */
       struct _b8x5 *d;                 /* pointer to font definition    */
           } ft[] = {                   /* FONT table                    */
         {0, 0, 0, NULL},               /* FONT0 dummy: suppress title   */
         {6, 3, sizeof(f1)/sizeof(struct _b8x5), f1}, /* FONT1 */
         {8, 5, sizeof(f2)/sizeof(struct _b8x5), f2}, /* FONT2 */
         {8, 4, sizeof(f3)/sizeof(struct _b8x5), f3}, /* FONT3 */
         {8, 5, sizeof(f4)/sizeof(struct _b8x5), f4}, /* FONT4 */
           };

/* ===================================================== */
/* Generate string of block-characters (1 part per call) */
/* ===================================================== */
char *strnblk(char  *b,
              short int n,
              short int f,
              short int k)
{
  int  i, j, x ,w;                      /* counters                      */
  static char a[80];                    /* returned line buffer          */
  static char b_array[]  = " ۰ޱ"; /* block character elements      */
                                        /* codepage 437, 860, 863, 865   */
  static char pg_multi[] = " ۰"; /* Code Page 850: Multilingual   */

  if (c_info.codepage==850)             /* codepage 850                  */
    strcpy(b_array,pg_multi);           /* suitable blockchars           */

  if (f<FONT1 || f>FONT4)               /* check range of selected font  */
    f = FONT2;                          /* reset to default if out of rng*/

  if (k<LINE1 || k>ft[f].k-1)           /* check range of LINE           */
    k = LINE1;                          /* prevent addressing violations */

  i = 0;                                /* zero count                    */
  w = 1;                                /* width 1: leading char         */
  while (i<n && b[i]!='\0' && w<=sizeof(a)) {   /* limit width of output */
    for (j=0; j<ft[f].n &&
              ft[f].d[j].c!=(char)toupper(b[i]); j++);   /* search char  */
    if (j < ft[f].n) {                  /* found                         */
      if (w + ft[f].d[j].k < sizeof(a)) {    /* would it fit?            */
        w += ft[f].d[j].k;              /* add active columns + 1 blank  */
        ++i;                            /* accept character              */
        }                               /* endif                         */
      else
        n = i;                          /* indicate 'full'               */
      }                                 /* endif                         */
    else {                              /* not found                     */
      if (w + ft[f].k < sizeof(a)) {    /* would dummy fit?              */
        w += ft[f].k;                   /* add max columns + 1 blank     */
        ++i;                            /* accept character              */
        }                               /* endif                         */
      else
        n = i;                          /* indicate 'full'               */
      }                                 /* endif                         */
    }                                   /* endif                         */
  n = i;                                /* maximum # title characters    */

  a[0] = b_array[(f==FONT4) ? 3 : 0];   /* leading character             */
  for (i=0,w=1; i<n; ++i) {             /* process string up till n      */
    for (j=0; j<ft[f].n &&
              ft[f].d[j].c!=(char)toupper(b[i]); j++);  /* search        */
    if (j < ft[f].n) {                  /* char found                    */
      a[w++] = b_array[ft[f].d[j].p[k].c0];
      if (ft[f].d[j].k > 1)
        a[w++] = b_array[ft[f].d[j].p[k].c1];
      if (ft[f].d[j].k > 2)
        a[w++] = b_array[ft[f].d[j].p[k].c2];
      if (ft[f].d[j].k > 3)
        a[w++] = b_array[ft[f].d[j].p[k].c3];
      if (ft[f].d[j].k > 4)
        a[w++] = b_array[ft[f].d[j].p[k].c4];
      if (ft[f].d[j].k > 5)
        a[w++] = b_array[ft[f].d[j].p[k].c5];
      if (ft[f].d[j].k > 6)
        a[w++] = b_array[ft[f].d[j].p[k].c6];
      if (ft[f].d[j].k > 7)
        a[w++] = b_array[ft[f].d[j].p[k].c7];
      }
    else {                              /* char not found                */
      --j;                              /* take last character in table  */
      for (x=0; x<ft[f].k; x++)         /* max columns                   */
        a[w++] = b_array[ft[f].d[j].p[0].c0];    /* filler block         */
      }                                 /* endfor                        */
    }                                   /* endfor                        */
  a[(f==FONT4) ? w : w-1] = '\0';       /* end of string                 */
  return(a);                            /* return ptr to outputstring    */
  }


/* ======================================== */
/* function to insert BLOCK title in report */
/* ======================================== */
void block_title(FILE *pf,              /* output FILE pointer */
               short int n,             /* max length of title string */
               char *prefx,             /* title prefix */
               char *title,             /* title string */
               LISTPARM *ls)            /* pointer to list specs */
{
  unsigned short int i;

  for (i=0; i<ft[ls->tfont].r; ++i)     /* all rows */
    fprintf(pf, "%s%s\n", prefx, strnblk(title, n, ls->tfont, i));
  }

