/*
 * this file should contain all of the text screen related files
 * for DVPEG
 */


#include "extern.h"		/* external declerations for viewer plus IJG includes */

#include "dv-ver.h"			/* version number of dvpeg */
#include "jversion.h"		/* IJG version number */

#include <string.h>
#include <dos.h>
#include <conio.h>
#include <alloc.h>
#include <time.h>*/



/*
 * prepare for an exit.
 *  ie restore screen, cursor, ending message
 * free up an memory used in the viewer interface
 */

void prep_for_exit(void)
{
farfree(line_buffer_ptr);		/* free up line buffer storage */

if ((defaults & no_text) == 0){
	setup_text_screen();

	_setcursortype(_NORMALCURSOR);

	rtn_video();		/* return the original video text mode */

	if ((defaults & no_file_list) == 0){
#ifdef small_viewer
		printf("Reduced DVPEG Ver. %4s, %s\nCopyright (C) Eric Praetzel\n", dvpeg_version, dvpeg_date);
#else
		printf("Dvpeg version %4s, %s\nCopyright (C) Eric Praetzel\n", dvpeg_version, dvpeg_date);
#endif
		printf("JPEG code version: ");
		printf("%s\r\n%s\r\n",JVERSION, JCOPYRIGHT);
		}
	}

if (file_info_head != NULL)
	farfree(file_info_head);
}




/*
 * clear + reset the window title on the text screen
 */

int init_screen()		/* paint simple stuff if text screen is redrawn */
{
window(1, 1, text_width, text_height);

_setcursortype(_NOCURSOR);

set_screen_info();	/* calc file list parameters for the current text screen */

clrscr();
gotoxy(1,1);
textcolor(WHITE);
cprintf("Select a file                      (F1 = help)                     DVPEG %4s", dvpeg_version);
return 1;
}




/*
 * setup the text screen, reset the window to the whole screen
 * set text mode to the indicated on in the file
 * now trust that we have the resolution that was set
 */

void setup_text_screen(void)
{
extern unsigned char _video;
unsigned char lines, *ptr;

/* now setup the text display parameters */

current_graphics_mode = -1;		/* reset since we are exiting the graphics mode */

_AH = 0;
_AL = text_mode_number;
geninterrupt(0x10);

/* does the user want to force 50 lines ? */
if (view_defaults & fifty_line_text){
	_AX = 0x1112;		/* into 10h fuction number to set 8 * 8 char set*/
	_BL = 0x0;
	geninterrupt(0x10);
	}

lines = peekb(0x40, 0x84);
ptr = &_video;
*(ptr+3) = lines;
*(ptr+7) = lines + 1;

text_height = lines;

/* setup basic info about text screen data */
/* the number of files per column on text screen  - 3 rows deducted at top, bottom */

per_column = text_height - 3;
cols_per_page = text_width - 2;
if (defaults & long_file_format){
	max_col_width = 26;
	min_col_width = 13 + 7;		/* min for file name.extension + space + size(ie '[232k]') + space */
	}
else{
	max_col_width = 26;
	min_col_width = 13;		/* min for file name.extension + space */
	}
files_per_page = (cols_per_page / min_col_width) * per_column;
}



/*
 * setup the information about the screen to aid the text writing routines
 *
 * do all of this to find out how many columns to put on a page and their width
 *  we don't want a bunch of tight columns all on the left of the screen so ...
 */

void set_screen_info()
{
num_cols = files_per_page / per_column;		/* calc the number of dense columns required - ie overestimate */
if (files_per_page % per_column > 0) num_cols++;
if (num_cols == 0) num_cols = 1;

column_width = cols_per_page / num_cols;		/* too small since num_cols is an inflated guess */
if (column_width > max_col_width) column_width = max_col_width;		/* hard limit it to a real world value */

/* now given the real column size recalculate just what fits on a page */

num_cols = cols_per_page / column_width;
per_page = num_cols * per_column;		/* find the real # per page */
number_pages = number_files / files_per_page;			/* max number of dense 6 col pages */
if (number_files % files_per_page > 0) number_pages++;
if (number_pages == 0) number_pages = 1;

}



/* put a window up in the center of the screen
	- ask about panning, video mode ....
	- don't worry what is under it because the image will be drawn
 */

void open_window(int width, int height)
{
char char_is;
struct text_info ti;
int i;

window(12, 4, 12 + width, 4 + height);
clrscr();

gettextinfo(&ti);				 /*  border */

textcolor(WHITE);
char_is = 219;			/* solid block */

for (i=1; i <= (ti.winright-ti.winleft); i++){		/* should go 1 count more */
	gotoxy(i, 1);
	putch(char_is);
	gotoxy(i, ti.winbottom - ti.wintop + 1);
	putch(char_is);
	}
for (i=2; i <= (ti.winbottom-ti.wintop); i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(ti.winright - ti.winleft, i);		/* had to sub +1 */
	putch(char_is);
	}
window(14, 6, 10 + width, 2 + height);
}
