/*
 * file containing the view file handling routines
 */


#include "viewdef.h"			/* definations for the viewer */
#include "extern.h"		/* external declerations for viewer plus IJG includes */
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>
#include <alloc.h>


#ifndef small_viewer

/*
 * save the picture context info (contrast, tints, zoom ....)
 * - just appends to the end of the file - duplicate entries are possibe and probable
 */

void save_viewing_info()
{
char pic_file_path[file_name_len];
FILE * file_in;

strcpy(view_setup_info.file_name, file_being_viewed);
view_setup_info.red_tint = red_tint;
view_setup_info.green_tint = green_tint;
view_setup_info.blue_tint = blue_tint;
view_setup_info.bright = color_scale;
view_setup_info.contrast = contrast_scale;
view_setup_info.offset_x = picture_x_offset;
view_setup_info.offset_y = picture_y_offset;
view_setup_info.shrink = shrink;
view_setup_info.resolution = video_resolution;
view_setup_info.video_size_x = x_max;
view_setup_info.video_size_y = y_max;

strcpy(pic_file_path, file_path);
strcat(pic_file_path, viewing_defaults_file);

if ( (file_in = fopen(pic_file_path, "ab")) != NULL)
	fwrite(&view_setup_info, sizeof(view_setup_info), 1, file_in);
fclose(file_in);
}




/*
 * scan thru the given file to check for default viewing info (if names match)
 * the last instance will be the correct one
 */
int find_picture_setup(FILE * file_in)
{
int find_it;
struct view_info default_info;

find_it = 0;

while (!feof(file_in)){
	fread(&view_setup_info, sizeof(struct view_info), 1, file_in);
	if (stricmp(view_setup_info.file_name, file_being_viewed) == 0){
		memcpy(&default_info, &view_setup_info, sizeof(view_setup_info));
		find_it = 1;
		}
	}

if (find_it){	/* if we found it copy the stats to the global vars */
	memcpy(&view_setup_info, &default_info, sizeof(view_setup_info));
	red_tint = view_setup_info.red_tint;
	green_tint = view_setup_info.green_tint;
	blue_tint = view_setup_info.blue_tint;
	color_scale = view_setup_info.bright;
	contrast_scale = view_setup_info.contrast;
	picture_x_offset = view_setup_info.offset_x;
	picture_y_offset = view_setup_info.offset_y;
/*
	view_setup_info.shrink;
	view_setup_info.resolution;
	view_setup_info.video_size_x;
	view_setup_info.video_size_y;
*/
	}

return find_it;
}




/*
 * delete a selected file from the default picture info
 * - del all instances that match the name
 * - since there may not be much memory do this by copying to a second file
 *   and swap file names
 */

void delete_from_setup_file(char * picture_name)
{
char pic_file_path[file_name_len],
		path_out[file_name_len],
		temp_str[file_name_len * 2];
struct view_info default_info;
FILE * file_in, * file_out;

strcpy(pic_file_path, file_path);
strcat(pic_file_path, viewing_defaults_file);

strcpy(path_out, file_path);
strcat(path_out, viewing_defaults_temp_file);

file_in = fopen(pic_file_path, "rb");
file_out = fopen(path_out, "wb");

if ( file_in != NULL && file_out != NULL)
	do{
		fread(&default_info, sizeof(view_setup_info), 1, file_in);
		if (strcmpi(default_info.file_name, picture_name) != 0 && (!feof(file_in)))
			fwrite(&default_info, sizeof(view_setup_info), 1, file_out);
		} while (!feof(file_in));
fclose(file_in);
fclose(file_out);

/* now delete the old and rename the new file */
strcpy(temp_str, "del ");
strcat(temp_str, file_path);
strcat(temp_str, viewing_defaults_file);
system(temp_str);

strcpy(temp_str, "rename ");
strcat(temp_str, file_path);
strcat(temp_str, viewing_defaults_temp_file);
strcat(temp_str, " ");
strcat(temp_str, viewing_defaults_file);
system(temp_str);
}

#else
void save_viewing_info(){}
int find_picture_setup(FILE * file_in){}
void delete_from_setup_file(char * picture_name){}
#endif



/*
 * Get the list of files matching the file spec and sort into the name array
 * of structs pointing to arrays of info  (whew)
 *
 *   Return the number of files read in.
 */

void get_files(void)
{
int done,
	index,
	error_exit;		/* for an exit if run out of memory */
struct ffblk ffblk;
char search_path[80];


init_file_struct();

if (file_info_head == NULL) error_exit = 1;		/* force exit if no memory for data records */
else error_exit = 0;

/* now put the directory tree at the top of the list
 * since the list is empty, and these are not sorted its easy
 */

number_files = 0;

if (error_exit != 1){
	strcpy(search_path, "[A]");		/* setup format for directory as printed */
	if (defaults & show_drives)		/* now copy over good drives */
		for (index = 0; index <= drive_list_length; index++)
			if (drive_list[index] > 0){		/* we found a good one ?? */
				search_path[1] = drive_list[index];
				number_files += insert_in_place(search_path, 0, 0, NONE, 0, 0);
				}

index = number_files;	/* keep the head of the list */

	strcpy(search_path, file_path);
	strcat(search_path, "*.*");
	if (defaults & show_tree){
		done = findfirst(search_path, &ffblk, FA_DIREC);
		while (!done){
			if (ffblk.ff_attrib & FA_DIREC)
				if (strlen(ffblk.ff_name) != 1 || ffblk.ff_name[0] != '.'){
					number_files += insert_in_place(ffblk.ff_name, 0, 0, FF_NAME, index, 0);
					}
			done = findnext(&ffblk);
			}
		}
	}

index = number_files;

index = 0;		/* repeat for all file masks */
do{
	strcpy(search_path, file_path);
	strcat(search_path, file_masks[index]);

	done = findfirst(search_path, &ffblk, FA_SYSTEM);
	while (!done && !error_exit){
		if (ffblk.ff_fsize == 0) ffblk.ff_fsize = 1;		/* default to some minimum value */
		number_files += insert_in_place(ffblk.ff_name, ffblk.ff_fsize, ffblk.ff_fdate, sort_mode, index, 0);
		done = findnext(&ffblk);
		}
	index++;
	} while (file_masks[index][0] != 0 && index < max_file_masks);


if (first_file > number_files) first_file = 0;		/* setup current file pointer */
}



/* change the assigned drive
 * set the path to the current for that drive
 * pass in the letter of the drive wanted
 */

void change_drive(char drive)
{
int i;

if (drive - 'A' < max_drives){
	strcpy(file_path, "C:\\");
	file_path[0] = drive;
	getcurdir(drive - 'A' + 1, file_path + 3);
	if (strlen(file_path) > 3)   /* watch out for root because its X:/ already */
	strcat(file_path, "\\");

	get_files();
	}
}



/*
 * check to see if the 4DOS file (hidden) DESCRIPT.ION exists and
 *	if so see if we can find the picture description
 *
 * picture_description is the string to return the info in (max file_name_len bytes)
 */

void try_4_DOS(char * picture_description)
{
int find_it, i;
FILE * file_in;
char temp_str[file_name_len];
char * name_str;

strcpy(temp_str, file_path);
strcat(temp_str, "DESCRIPT.ION");

strcpy(picture_description, "");

if( (file_in = fopen(temp_str, "r")) == NULL) return;

find_it = 0;

while (!feof(file_in) && find_it == 0){
	fgets(temp_str, file_name_len, file_in);
	i = 0;
	while(temp_str[i] != ' ' && temp_str[i] != 0 && i < file_name_len) i++;
	if (i < strlen(temp_str)){
		temp_str[strlen(temp_str) - 1] = 0;
		name_str = &temp_str[i + 1];	/* mark start of comment */
		temp_str[i] = 0;					/* mark end of file name */
		if (stricmp(temp_str, file_being_viewed) == 0)
			find_it = 1;
		}
	}

if (find_it) strcpy(picture_description, name_str);

fclose(file_in);
}