/*
 * this is all global variables used by the viewer
 */

#include "viewdef.h"		/* include all of the size definations */
#include "jinclude.h"
#include <time.h>

/*unsigned int JPEG_BUF_SIZE;		/* taken from a #define in the JPEG code to allow for a larger buffer */

/* amount of memory free after decoding a picture after all memory is alloced ... */
unsigned long
near_memory_view, far_memory_view;

char picture_description[file_name_len];		/* description of picture - read from a 4DOS file DESCRIPT.ION - perhaps add into my info later on */

char picture_text[file_name_len];			/* file-name to be put on the screen before and optionally after drawing picture  ie file name or a defined string */
char picture_text_arguement[file_name_len];			/* title passed in as an arguement, either len 0 or the string */

char picture_title[file_name_len];			/* title to be put on the screen before and optionally after drawing picture  ie file name or a defined string */
char picture_title_arguement[file_name_len];			/* title passed in as an arguement, either len 0 or the string - usually the 4DOS description */

int tint_loaded;					/* flag to indicate if tinting adjustments are loaded for a picture */

char file_masks[max_file_masks][13];		/* array of file masks (14 char each ie 8.3 format + null), 0 if not used, string otherwise */

struct dir_info{			/* struct for file names, size ... */
	char name[13];
	char slide_num;				/* number (viewing order) for slide show ie 0=not used; 1 = first, 2 = 2nd ... */
	unsigned  date;
	long size;
	} far * file_info_head;		/* pointer to start of whole struct */

time_t time_at_start;		/* slideshow delay timer */


/* buffer pointer for panning if needed/possible */
big_sarray_ptr raw_pic_ptr;		/* pointer to virt. pic. for panning, 3 used for hi_color mode; 1 otherwise */

int video_display_resolution;		/* used by dithering routines to calc. the error due to the 5, 6, 8 bit video display */
											/* normal values are 1111,1000; 1111,1100; 1111,1111 */
JSAMPARRAY remap;				/* colormap array for remaping 256 color GIF -> 16 grayscale for 16 color modes */
JSAMPARRAY tint_table;		/* table to speed up tinting of 15/16/24 bit modes using look-up */

int current_graphics_mode,			/* set to the current graphics mode or -1 to save resetting the graphics screen all the time ie locked video mode */
	mode_lock;							/* either -1 or the video Y resolution that the user want to be locked into */

int config_found = 0;				/* set to 1 if configuration file is found/loaded, 0 otherwise */

int type_of_picture;	/* enum holding type of picture ie GIF, PBM, TGA ...*/
int jpeg_type;			/* type of jpeg ie h2v2, h1v2, .... right now this is 1 for h2v2, 0 otherwise */
int row_ordering;		/* enum holding format of picture ie INTERLACED, NORMAL, UPSIDE_DOWN */
unsigned char far * line_buffer_ptr;		/* pointer to a buffer for 1 drawn line -> maximum 640 * 3 = 1920 bytes (currently) */

/*
 * definations common to vidsetup and dvpeg
 *
 */

/* these are for the graphics interface */

	int twiddle_factor = 5;			/* the amount of "play" in pic size before the image shrinks or pans (X or Y axis)
												ie if the pick is < 640 + twiddle it will not use panning or shirk on a 640 wide screen ... */
	unsigned char palbuf[256][3];
	int svga;
	int video_mode_used;    /* mode number index (into the video_cards array of data) for the viewing mode */
	int card_used;          /* the current selected mode for viewing */
	int card_id;            /* card id # - as found by autodetection (valid if svga = 1) */
	int enable_pan;         /* enough memory for panning && needed?? */
	int shrink;             /* 1 = normal, 2 = 1/2, 3 = 1/3 ... */
	int zoom_inc;				/* zoom increment, if shrink = 1; zoom_inc, size = {3, 2:1; 2, 3:1; 1, 4:1; 0, 5:1}
									/* for shrink > 1, zoom_inc must = 4 */
	int any_hi_color;			/* flag to indicate presence of hi_color modes - only used by viewer */
	int text_mode_number;	/* int 10 number for setting the video mode */
	int text_height;			/* height of the custom text mode */
	int slideshow_pause;		/* pause after a pic during slide show */

   int number_pallet_colors;		/* number of colors in the pallet used, usually 16 or 256 */
	int x_max;				/* physical pixel size of the screen */
	int y_max;
/* maxx is the width of 1 line in video memory in bytes */

int
	image_x_dim,	/* the actual image width in pixels */
	image_y_dim,

/* these are the offsets of the image into the viewing window (if image < screen size)
 *  - the only case not handled is having the image larger than the screen
 */
	image_x_offset,
	image_y_offset,

/* now the maximum pixel values for the lower right corner of the image */
	image_x_max,
	image_y_max,

	bytes_per_pixel;			/* the number of bytes per pixel on the screen */

/* now do the image specific info
 * ie what row do we start showing the image at?  picture_y_offset, picture_x_offset
 * what is the maximum row?  the size ?	picture_max_y, picture_max_x, picture_x_dim, picture_y_dim
 */
int
	picture_x_offset,
	picture_y_offset,

	picture_x_center,		/* center of the picture, as displayed on the screen */
	picture_y_center,

	picture_x_dim,
	picture_y_dim,

	picture_x_max,
	picture_y_max,

	picture_x_size,
	picture_y_size,	/* picture size in picture elements */

	bytes_per_line,				/* the actual number of bytes storage for each video line */
	visable_bytes_per_line;		/* the number of bytes for each visable line - ie for memory copying */

int
	first_file,
	number_files,
	number_pages,
	per_page,
	num_cols,
	column_width,
	selected_file;

/* now some stuff for the configuration file */

char config_name[file_name_len]; 		   /* path to configuration file -> assuem its in the same dir as vidsetup.exe */
char default_path[file_name_len] = "";	/* default path to pictures */

int
	view_defaults,		/* defaults from lsb up: grey_scale, dithering, smoothing, quantize, panning*/
	more_defaults,		/* more defaults from the viewer */
	defaults;				/* more viewing defaults in a bit pattern */

int	text_width,			/* text screen width - currently 80 char */
		text_mode,			/* mode for the text screen */
		sort_mode,			/* method to sort file list by */
		buffer_ok,			/* setvbuf return flag, 0 indicates buffer was allocated */
		buffer_size;		/* size of the viewing buffer, 8k default, 32k max  ie to speed up viewing */

/* These static variables are needed by the error routines. */
/*static jmp_buf setjmp_buffer;	/* for return to caller */
int exit_draw;			/* flag to indicate exiting the showing of a picture */


/* stuff for file selection */
char file_path[file_name_len];	/* current path to files to be viewed */
char original_path[file_name_len];	/* the original or boot path - used to check for config file, default file .... */
char code_path[file_name_len];		/* path to the executable code - used to search for config file as a last resort */
char file_being_viewed[20];	/* current file being viewed */
int  show_next_file;		/* flag to jump to next file in the list without menu stuff */
int drive_list[drive_list_length];		/* list of good drives - floppy & hard */
unsigned int
	max_drives;			/* the maximum number of drives available */

int	sort_mode,		/* sort type for file names */
	per_column,			/* the number of files per column on text screen */
	files_per_page,	/* nominal # files per page ie 22 * 6 wide */
	cols_per_page,		/* nominal # columns ie 2 blanks at sides */
	min_col_width,		/* minimum column width currently 13 char (includes spaces) */
	max_col_width,		/* maximum column width - currently 26 */
	do_slide_show,		/* slide show flag to other modules */
	video_resolution,	/* flag for type of video mode being used ie VGA,SVGA,SVGA_15_bit, ... */
	lock_shrink_value,	/* value that the shrink is locked to */
	text_drawing_for,		/* color to draw the text in the 256 color modes */
	text_drawing_bk,		/* background ie color under the text drawn */
	key_hit;				/* flag that a non ESC key was hit during decompression */


/* globle tint, contrast, bright controls used in drawing routines
 * these can be set from a user data base of personal preferces
 */
/* variables which should be initialized externally before any drawing */
int red_tint, green_tint, blue_tint,	/* red, green, blue tint controls */
	color_scale,		/* factor to scale pallete up or down  0 -> 32 */
	contrast_scale,	/* factor to scale contrast up or down  0 -> +/-32 */
	tint_factor_1,    /* intermediate variables for tint calculations ie it speeds up the calculations greatly */
	tint_lookup,		/* lookup table version of tint_factor_1 for 15/16/24 bit tinting */
	tint_factor_red,
	tint_factor_blue,
	tint_factor_green,

	allow_video_exit;		/* if set you can exit from panning/tint routines - if 0 then the whole screen must be repainted */

/* from put_pixel_rows - taken out so I can re-init them for 2nd, 3rn ... calls for pictures */
int gr_row = 0,  		/* gr_row,col for pixel plotting*/
	gr_col,
	col_cntr = 1,		/* column and row counters for shrinking */
	row_cntr = 1,
	read_row = 0;		/* row for indexing into big buffer for reading ie panning */


/*
 * this structure contains the info as stored in the dvpeg.vu file
 * it has all the info necessary to setup the screen as the user left it
 * complete with tint, zoom, ... info
 */

struct view_info {
	char file_name[13];		/* name in the 8.3 format with a terminating char */
	char resolution;			/* resolution (ie SVGA, 15 bit, 24 bit ) */
	char shrink;				/* shrink factor ie 1, 2, 3, 4 */
	char red_tint;
	char green_tint;
	char blue_tint;
	char contrast;
	char bright;
	int offset_x;		/* offset of the image - ie upper right corner to be viewed */
	int offset_y;
	int video_size_x;	/* size of the video screen in pixels */
	int video_size_y;
	} view_setup_info;

/*
 * this is used by the viewer only
 * vidsetup has the struct declared and define in modes.h
 *
 * This fully specs each video mode.
 * There are two lists that point to it from dvpeg.  One is ok_mode which is
 *   a list of modes that are "ok" for the current picture.  The other list
 *   is called all_modes[].
 */

#ifdef dvpeg_viewer

struct video_card {
	int card_number;		/* same index as video_card_names and list in .asm video routines; a -1 indicates an unused struct slot */
	int x_size;
	int y_size;
	int resolution;	/* check enum:  0 = 256, 1 = 15 bit, 2 = 24 bit */
	int set_ax;		/* value to force AX, BX */
	int set_bx;
	int x_width;		/* x_width for odd sizes ie 15, 24 bit its the number of bytes per vertical row */
	} video_cards[number_modes_in_list];
#endif