
	include model.h

;
;	VGAKIT Version 4.1
;
;	Copyright 1988,89,90,91 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	SVGAMODE.ASM
;
;
.data
	extrn	cirrus:byte,everex:byte,paradise:byte,tseng:byte,trident:byte
	extrn	t8900:byte,ativga:byte,aheada:byte,aheadb:byte
	extrn	oaktech:byte,video7:byte,chipstech:byte,tseng4:byte,genoa:byte
	extrn	ncr:byte,compaq:byte,vesa:byte
	extrn	vga512:byte,vga1024:byte

	extrn	curbk:word
	extrn vesashift:byte

	public	maxx,maxy,xwidth

maxx	dw	?		;xwidth of screen in pixels
maxy	dw	?		;height of screen in pixels
xwidth		dw	?		;actual xwidth of screen in bytes
BIOSmode		db 0	; the BIOS text mode # that was being used when the program was started
fifty_lines dw 0	; flag to indicate if 50 line mode was originally used

.code

	public	svgamode
	public	txtmode
	public	setmany
	public	get_video
	public	rtn_video

svgamode proc vid_mode:word, bx_reg:word, max_x:word, vid_card:word		;Set SVGA mode
	push	di
	push	es
	mov ax, [vid_mode]
	and ax, 0fff0h		; strip off last nibble (has info needed )
	cmp ax, 0fff0h		;the Tseng card has to be called in two steps ie set mode then set 15 bit DAC
	jz  right_one
	mov ax, [vid_mode]
	jmp no_patch
;	cmp ax, 10f0h
;	jnz no_patch
right_one:
	mov bx, [vid_mode]
	and bx, 0007h
	mov ax, 10f2h
	int 10h
	mov ax, 10f0h
no_patch:
	mov bx, [bx_reg]

	int	10h

	mov	[curbk],-1
	mov	ax, [max_x]
	mov	[maxx],ax		;default xwidth to whatever for now
	mov	[xwidth],ax

; If it was VESA then find the granularity and other info
;
	mov	ax, [vid_card]
	cmp   ax, 15
	jnz	all_done

	sub	sp, 260		; space to get VESA info + 4 byte buffer (needed)
	push	ss
	pop	es		; setup ES:DI with pointer to the 256 byte space
	mov	di, sp
	mov	cx, [bx_reg]
	mov	ax, 4f01h		; get VESA info
	int	10h
	mov	cx, es:[di+4]	; the WinGranularity info

	mov		al,1
	cmp		cx,0				; Some BIOS'S fuck this up!
	je		@@NoDivide
	mov		ax,64
	div		cl
@@NoDivide:
	mov     [vesashift],al		; Save the granularity scale factor

	mov     cx, es:[di+10h]     ; VESA bytes per line
	mov ax, [max_x]
	shr ax,1					; set ax = 1/2 expected line width in bytes
	cmp     cx,ax		; if the returned width is > this then it may be right so use it
	jae     no_modify
	jmp skip_modify
no_modify:
	mov	[maxx],cx
	mov	[xwidth],cx
skip_modify:

; *****************************************
;mov al, 0
; *****************************************

;	mov	[vesashift], al


	add	sp, 260			; clear the temp space on the stack

all_done:
;	mov	ax,40h
;	mov	es,ax
;	mov	al,es:[84h]		;get height of screen
;	inc	al
;	mul	byte ptr es:[85h]
;	mov	[maxy],ax

	pop	es
	pop	di
	ret
svgamode endp



;
; return to the textmode
;

txtmode	proc
	mov	ax,3
	int	10h
	ret
txtmode	endp



setmany proc	palbuf:ptr byte,begcol:word,numcol:word
if @Datasize
	les	dx,[palbuf]
else
	mov	ax,ds
	mov	es,ax
	mov	dx,[palbuf]
endif
	mov	bx,[begcol]
	mov	cx,[numcol]
	mov	ax,1012h
	int	10h
	ret
setmany endp


;
;  Return the video mode to that which was in use when the program was first run
;
; this is from svgakit version 3.2
;
;

rtn_video proc
	push	bp					; INT 10h kills bp sometimes
	push	si					; Save regs
	push	di

	mov		ah,0				; Set video mode service
	mov		al,[BIOSmode]	; Get old BIOS mode number
	int		10h					; Set the video mode

	cmp		[fifty_lines],0		; Was 50 line mode set?
	je		@@Exit				; No, don't set it up

; Load video BIOS 8x8 characters into alphanumeric character generator

	mov		ax,1112h			; AH := INT 10h function number
									; AL := 8x8 character set load
	mov		bl,0				; BL := block to load
	int		10h					; load 8x8 characters into RAM

@@Exit:
	pop		di					; Restore regs
	pop		si
	pop		bp					; Restore bp
	ret
rtn_video endp


;
;  store the video mode to that which was in use when the program was first run
;
; returns: 1 if 50 line mode was achieved by 8 * 8 character set; 0 otherwise
;
; this is from svgakit version 3.2
;
;

get_video proc
	push	bp
	push	si
	push	di
	mov		ah,0Fh				; Get current video mode service
	int		10h
	and     al,7Fh
	mov     [BIOSmode],al    ; Save old video mode
	mov		[fifty_lines],0		; Default to non-50 line mode

	mov		ax,1130h			; AH := INT 10h function number
									; AL := Get character gen information
	mov		bh,00				; Get contents of INT 1Fh
	xor		dl,dl				; Clear dl
	int		10h					; Determine number of lines (in dl)
	cmp		dl,49				; 50 line mode?
	jne		@@SetMode			; No, must have been 25 lines
	mov		[fifty_lines],1		; Yes, 50 line mode was on
@@SetMode:
	pop	di
	pop	si
	pop	bp

	mov	ax, [fifty_lines]
	ret
get_video endp

	end

