;  modified quite a bit by Eric Praetzel
;
; memory tests removed because the code was big enough to cross a bank boundary
; hi_color flag is not being set yet by tseng or ATI

	include  model.h

;
;  VGAKIT Version 4.1
;
;  Copyright 1988,89,90,91 John Bridges
;  Free for use in commercial, shareware or freeware applications
;
;  BANKS.ASM
;
;CRTC			EQU	3D4h		; Port of CRTC registers
;VGABufferSeg	EQU	0A000h		; Segment of VGA display memory

.data

OSEG  equ   DS:      ;segment override for variable access

bankadr  dw ?
if @Codesize
bankseg  dw ?
endif

	public   curbk

curbk dw ?

	public   vga512,vga1024

vga512   dw ?
vga1024  dw ?

	public   cirrus,everex,paradise,tseng,trident,t8900
	public   ativga,aheada,aheadb,oaktech,video7, realtek
	public   chipstech,tseng4,genoa,ncr,compaq,vesa,speedstar
	public vesashift,  ati_extended          ;ati extended reg. location

cirrus   dw ?
everex   dw ?
paradise dw ?
tseng    dw ?
trident  dw ?
t8900    dw ?
ativga   dw ?
aheada   dw ?
aheadb   dw ?
oaktech  dw ?
video7   dw ?
chipstech dw   ?
tseng4   dw ?
genoa    dw ?
ncr      dw ?
compaq   dw ?
vesa     dw ?
speedstar dw ?
realtek	dw ?
XGA		dw ?
S3_card	dw ?

ati_extended dw ?  ;ati extended reg. location

vesashift db 0     ; number of bits to shift bank number left

;
;
;

	extrn gr_col:word
	extrn gr_row:word
	extrn color_out:word
;	extrn	curbk:word
	extrn	maxx:word,maxy:word,xwidth:word
;
;
;


.code

	public   newbank
	public   forcevga

;
;
;
;	extrn	newbank:proc

	public	point
	public	point_wide	; write a word to video memory
	public	point_24		; 24 bit routine using the generic bank-switch drivers
	public	put16Pixel	; 4 bit (16 color) graphics drawing routine

;
;
;


newbank proc        ;bank number is in AX
	cli
	mov   OSEG[curbk],ax
if @Codesize
	jmp   dword ptr OSEG[bankadr]
else
	jmp   word ptr OSEG[bankadr]
endif


;
; The video card bank switching routines
;

_S3_card:			; S3 based video cards
; bank number is in al
	push ax
	push dx

	mov	ah, al	; save bank #

	mov	al, 38h	; set index
	mov	dx, 3d4h
	out	dx, al

	mov	al, 48h	; put data
	mov	dx, 3d5h
	out	dx, al

	mov	al, 39h	; set index
	mov	dx, 3d4h
	out	dx, al

	mov	al, 0A0h	; put data
	mov	dx, 3d5h
	out	dx, al


	mov	al, 035h	; set index
	mov	dx, 3d4h
	out	dx, al

	mov	al, ah	; put data
	mov	dx, 3d5h
	out	dx, al

	sti
	pop	dx
	pop	ax
	ret


_speedstar:			; Diamond Speedstar 24X
; al holds the bank # (64k banks)
	push	ax
	push	dx
	mov	ah, al

	mov	dx, 3c4h		; this sets up single 64k bank addressing --> yech
	mov	al, 11h
	out	dx, al

	in		al, dx
	and	al, 7fh
	out	dx, al

	mov	dx, 3ceh
	mov	al, 0bh
	out	dx, al

	in		al, dx
	and	al, 0f7h
	out	dx, al


;	and	ax, ff00h	; clear trash in lower byte
	sal	ax, 4		; ie done 8 bits of shifting already
	and	ax, 0f000h
	or		ax, 09h
	mov	dx, 3ceh
	out	dx, ax
	sti
	pop	dx
	pop	ax
	ret

_realtek:	; setup
	push	dx
	push	ax
	mov	ax, 0fh
	mov	dx, 3ceh
	out	dx, ax
	mov	ax, 04
	out	dx, ax
	out	dx, ax

	pop	ax
	mov	dx,3D6h
	out	dx,al				; Set write bank register
	inc	dx
	out	dx,al				; Set read bank
	pop	dx
	sti
	ret


_XGA:					; XGA microchannel

	ret


_tseng:           ;Tseng
	push  ax
	push  dx
	and   al,7
	mov   ah,al
	shl   al,1
	shl   al,1
	shl   al,1
	or al,ah
	or al,01000000b
	mov   dx,3cdh
	out   dx,al
	sti
	pop   dx
	pop   ax
	ret



_tseng4:          ;Tseng 4000 series
	push  ax
	push  dx
   mov   ah,al
	mov   dx,3bfh        ;Enable access to extended registers
   mov   al,3
	out   dx,al
	mov   dl,0d8h
	mov   al,0a0h
   out   dx,al

	and   ah,15
	mov   al,ah
	shl   al,4
	or al,ah
	mov   dl,0cdh
	out   dx,al

	sti
   pop   dx
	pop   ax
   ret


_trident:         ;Trident
	push  ax
   push  dx
   mov   dx,3ceh     ;set pagesize to 64k
	mov   al,6
	out   dx,al
   inc   dl
	in al,dx
   dec   dl
   or al,4
	mov   ah,al
   mov   al,6
	out   dx,ax

	mov   dl,0c4h     ;switch to BPS mode
	mov   al,0bh
   out   dx,al
   inc   dl
	in al,dx
	dec   dl

   mov   ah,byte ptr OSEG[curbk]
	xor   ah,2
   mov   dx,3c4h
	mov   al,0eh
   out   dx,ax
	sti
	pop   dx
	pop   ax
	ret


_video7:       ;Video 7
   push  ax
	push  dx
   push  cx
	and   ax,15
   mov   ch,al
	mov   dx,3c4h
   mov   ax,0ea06h
	out   dx,ax
   mov   ah,ch
   and   ah,1
	mov   al,0f9h
	out   dx,ax
   mov   al,ch
   and   al,1100b
	mov   ah,al
	shr   ah,1
   shr   ah,1
	or ah,al
	mov   al,0f6h
	out   dx,al
   inc   dx
	in al,dx
   dec   dx
	and   al,not 1111b
   or ah,al
   mov   al,0f6h
   out   dx,ax
   mov   ah,ch
	mov   cl,4
	shl   ah,cl
	and   ah,100000b
   mov   dl,0cch
	in al,dx
	mov   dl,0c2h
   and   al,not 100000b
   or al,ah
	out   dx,al
	sti
	pop   cx
	pop   dx
   pop   ax
	ret


_paradise:        ;Paradise
	push  ax
	push  dx
	mov   dx,3ceh
   mov   ax,50fh     ;turn off write protect on VGA registers
   out   dx,ax
   mov   ah,byte ptr OSEG[curbk]
   shl   ah,1     ;change 64k bank number into 4k bank number
   shl   ah,1
   shl   ah,1
	shl   ah,1
	mov   al,9
	out   dx,ax
   sti
	pop   dx
   pop   ax
   ret


_chipstech:       ;Chips & Tech
	push  ax
	push  dx
	mov   dx,46e8h ;place chip in setup mode
	mov   ax,1eh
   out   dx,ax
   mov   dx,103h     ;enable extended registers
   mov   ax,0080h
	out   dx,ax
	mov   dx,46e8h ;bring chip out of setup mode
	mov   ax,0eh
   out   dx,ax
   mov   ah,byte ptr OSEG[curbk]
   shl   ah,1     ;change 64k bank number into 16k bank number
   shl   ah,1
   mov   al,10h
	mov   dx,3d6h
   out   dx,ax
	sti
   pop   dx
	pop   ax
	ret


_ativga:       ;ATI VGA Wonder
   push  ax
	push  dx
;  mov   dx,1ceh      this line hardcoded a changed value (Eric)
	mov   dx, [ati_extended]
   mov   ah,al
   mov   al,0b2h
   out   dx,al
	inc   dl
   in al,dx
	shl   ah,1
	and   al,0e1h
   or ah,al
	mov   al,0b2h
	dec   dl
	out   dx,ax
   sti
   pop   dx
	pop   ax
   ret


_everex:       ;Everex
   push  ax
	push  dx
   push  cx
   mov   cl,al
	mov   dx,3c4h
	mov   al,8
   out   dx,al
	inc   dl
   in al,dx
   dec   dl
   shl   al,1
	shr   cl,1
   rcr   al,1
   mov   ah,al
   mov   al,8
   out   dx,ax
	mov   dl,0cch
	in al,dx
	mov   dl,0c2h
	and   al,0dfh
   shr   cl,1
	jc nob2
   or al,20h
nob2: out   dx,al
   sti
   pop   cx
	pop   dx
   pop   ax
	ret


_aheada:       ;Ahead Systems Ver A
   push  ax
   push  dx
	push  cx
	mov   ch,al
   mov   dx,3ceh     ;Enable extended registers
	mov   ax,200fh
   out   dx,ax
	mov   dl,0cch     ;bit 0
   in al,dx
   mov   dl,0c2h
   and   al,11011111b
	shr   ch,1
	jnc   skpa
	or al,00100000b
skpa: out   dx,al
	mov   dl,0cfh     ;bits 1,2,3
	mov   al,0
   out   dx,al
   inc   dx
	in al,dx
	dec   dx
	and   al,11111000b
	or al,ch
   mov   ah,al
   mov   al,0
	out   dx,ax
   sti
   pop   cx
	pop   dx
	pop   ax
   ret


_aheadb:       ;Ahead Systems Ver A
   push  ax
   push  dx
   push  cx
   mov   ch,al
   mov   dx,3ceh     ;Enable extended registers
	mov   ax,200fh
	out   dx,ax
	mov   ah,ch
   mov   cl,4
	shl   ah,cl
   or ah,ch
	mov   al,0dh
   out   dx,ax
	sti
	pop   cx
	pop   dx
   pop   ax
	ret


_oaktech:         ;Oak Technology Inc OTI-067
	push  ax
	push  dx
	and   al,15
	mov   ah,al
	shl   al,1
   shl   al,1
   shl   al,1
   shl   al,1
	or ah,al
   mov   al,11h
	mov   dx,3deh
   out   dx,ax
	sti
	pop   dx
   pop   ax
   ret

_genoa:        ;GENOA GVGA
   push  ax
	push  dx
   mov   ah,al
	shl   al,1
   shl   al,1
   shl   al,1
   or ah,al
   mov   al,6
   or ah,40h
	mov   dx,3c4h
   out   dx,ax
	sti
	pop   dx
   pop   ax
	ret

_ncr:          ;NCR 77C22E
   push  ax
	push  dx
	shl   al,1     ;change 64k bank number into 16k bank number
	shl   al,1
   mov   ah,al
   mov   al,18h
	mov   dx,3c4h
   out   dx,ax
   mov   ax,19h
	out   dx,ax
   sti
	pop   dx
	pop   ax
   ret

_compaq:       ;Compaq
	push  ax
   push  dx
   mov   dx,3ceh
   mov   ax,50fh     ;unlock extended registers
   out   dx,ax
   mov   ah,byte ptr OSEG[curbk]
	shl   ah,1     ;change 64k bank number into 4k bank number
	shl   ah,1
	shl   ah,1
	shl   ah,1
	mov   al,45h
	out   dx,ax
	sti
	pop   dx
	pop   ax
	ret

_vesa:            ;Vesa SVGA interface
	push  ax
	push  bx
	push  cx
	push  dx
	mul		[vesashift]			; Adjust with granularity factor
; these were the old lines
;	mov   cl,[vesashift]
;	shl   ax,cl
	mov   dx,ax
push dx
	xor   bx,bx		; clear bx (ie set to window A)
	mov   ax,4f05h
	int   10h
pop	dx
mov	bx, 1
mov	ax, 4f05h
int	10h
	pop   dx
	pop   cx
	pop   bx
	pop   ax
	ret


_cirrus:
	push	ax
	push	dx

; this enabling has been moved to the install routine - is it needed ?????
;	mov	dx, 3c4h		; enable extended regs
;	mov	ax, 6
;	out	dx, ax
;	mov	ax, 12h
;	out	dx, ax

	mov	dx, 3ceh
	shl	al, 4			; convert to 4k bank number
	mov	ah, al
	mov 	al, 9
	out	dx, ax

;	mov	dx, 3c4h		; disable extended regs
;	mov	ax, 6
;	out	dx, ax
;	mov	ax, 0
;	out	dx, ax

	sti
	pop	dx
	pop	ax
	ret

_nobank:
	sti
	ret

newbank  endp


;
;
;
bkadr macro func
	mov   [func],1
	mov   [bankadr],offset _&func
if @Codesize
	mov   [bankseg],seg _&func
endif
	endm



;
; force the video card bank switching
;

forcevga proc vid_card:word

	mov   [bankadr],offset _nobank   ; default for Cirrus???
if @Codesize
	mov   [bankseg],seg _nobank
endif

	mov ax, [vid_card]
	cmp   ax, 15
	jnz   no_vesa		; VESA ?
	bkadr vesa
	mov   [vga512],1
	mov   [vga1024],1
	jmp   finish

no_vesa:
	cmp	ax, 16		; S3 chips ???  like VESA???
	jnz	try_speed
	bkadr S3_card
	jmp	finish

try_speed:
	cmp	ax, 17		; Speedstar 24X
	jnz	try_realtek
	bkadr speedstar
	jmp	finish

try_realtek:
	cmp	ax, 18		; RealTek
	jnz	try_XGA
	bkadr realtek
	jmp finish

try_XGA:
	cmp	ax, 18		; XGA
	jnz	try_ati
	bkadr	XGA
	jmp	finish

try_ati:
	cmp   ax, 2         ; ati
	jnz   no_ati

;	mov   [vga1024],1		; hi_color has 1 meg
	bkadr ativga
;	mov   [vga512],1     ; forcing 512k - may not exist???

	mov   ax, 0c000h     ; find the location of the ATI extended reg
	mov   es, ax
	mov   bx, 10h
	mov   dx, es:[bx] ; fetch the extended reg value
	mov   [ati_extended], dx

	jmp   finish

no_ati:     ;Test for Everex
	cmp   ax, 4
	jnz   no_ev
	bkadr everex
;	mov   [vga512],1
	jmp   finish

no_ev:         ;Test for Compaq
	cmp   ax, 14
	jnz   no_cp
	bkadr compaq
;	mov   [vga512],1
	jmp   finish

no_cp:            ;Test for NCR 77C22E
	cmp   ax, 7
	jnz   non_cr
	bkadr ncr
;	mov   [vga512],1
	jmp   finish

non_cr:        ;Test for Trident 8800 or 8900
	cmp   ax, 9
	jnz   no_tri
	bkadr trident
;	mov [vga512], 1		/* trident 8800 */
;  mov [vga1024], 1		/* trident 8900 */
	jmp   finish

no_tri:     ;Test for Video 7
	cmp   ax, 12
	jnz   nov_7
	bkadr video7
;	mov   [vga1024],1
	jmp   finish

nov_7:         ;Test for GENOA GVGA
	cmp   ax, 6
	jnz   no_ci
	bkadr genoa
;	mov   [vga512],1
	jmp   finish

no_ci:         ;Test for Paradise
	cmp   ax, 8
	jnz   no_pd
	bkadr paradise
;	mov   [vga512],1
	jmp   finish

no_pd:      ;Test for Chips & Tech
	cmp   ax, 3
	jnz   no_ct
	bkadr chipstech
;	mov   [vga512],1
	jmp   finish

no_ct:
	cmp   ax, 10		; check tseng
	jnz    not_tseng

	bkadr tseng
;	mov   [vga512],1
	jmp   finish

not_tseng:
	cmp   ax, 11
	jnz   no_ts
;	mov   [vga1024],1    ;full meg with eight 256kx4 RAMs
	bkadr tseng4
	jmp   finish

no_ts:
	cmp   ax, 0		; ahead a?
	jnz   verb
	bkadr aheada
;	mov   [vga512],1
	jmp   finish

verb:            ; ahead b?
  cmp   ax, 1
  jnz		no_ab
  bkadr aheadb
;  mov   [vga512],1
  jmp   short finish

no_ab:         ;Test for Oak Technology
	cmp   ax, 5
	jnz   no_gn
	bkadr oaktech
;	mov   [vga512],1
	jmp   finish

no_gn:         ;Test for Cirrus
	cmp	ax, 13
	jnz	no_luck
	bkadr cirrus

	mov	dx, 3c4h		; enable extended regs
	mov	ax, 6
	out	dx, ax
	mov	ax, 12h
	out	dx, ax
	jmp finish

no_luck:
	ret		; who knows whats there so just return

finish:
	mov	ax, 1		; always return 1 in retval ie card svga = 1
;	mov   [retval],ax
	ret
forcevga endp

;
;
;


; print a word wide point into video memory
; assume that we are filling from low to high
; -- if a 3 byte write is going to cross a page boundary then don't do it
point_24	proc	xpos:word,ypos:word,color:dword
	mov	ax, [xpos]
	mov	bx, ax
	shl	ax, 1				; mult by 3 because of int width not byte
	add	bx, ax
	mov	ax,[ypos]
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
; test bx - if we are going to write on a word boundary then exit
	cmp	bx, 0fffdh
	jnc	problem_exit
	mov	ax,dx
	cmp	ax,[curbk]
	jz	nonewo
	call	newbank			;switch banks if a new bank entered
nonewo:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	cx, word ptr [color + 0]	;get color of pixel to plot - low int
	mov	es:[bx],cx
	add	bx, 2
	mov	cx, word ptr [color + 2]			; hi byte
	mov	byte ptr es:[bx], cl
problem_exit:
	ret
point_24	endp


point	proc	xpos:word, ypos:word, color:word

	mov	bx,[xpos]
	mov	ax,[ypos]
;	mov	dx,[maxx]
;	cmp	bx,0			; range checking not necessary since it will
;	jl	nope2				;  always be within one 64k bank
;	cmp	bx,dx
;	jge	nope2
;	cmp	ax,0
;	jl	nope2
;	cmp	ax,[maxy]
;	jge	nope2
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
	mov	ax,dx
	cmp	ax,[curbk]
	jz	nonew
	call	newbank			;switch banks if a new bank entered
nonew:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	cl,byte ptr [color]	;get color of pixel to plot
	mov	es:[bx],cl
nope2:	ret
point	endp



;
; print a word wide point into video memory
;  ASSUME:
;	- color word is in "color"
;	- X is in "xpos"
;	- Y is in "ypos"
;
point_wide	proc	xpos:word,ypos:word,color:word

	mov	bx,[xpos]
	shl	bx, 1				; mult by 2 because of int width not byte
	mov	ax,[ypos]
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
	cmp	dx,[curbk]
	jz		no_new_bank
	mov	ax, dx			; move bank number to ax
	call	newbank			;switch banks if a new bank entered
no_new_bank:
	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	cx, [color]	;get color of pixel to plot
	mov	es:[bx],cx
	ret
point_wide	endp



;	end



;----------------------------------------------------------------------------
; void put16Pixel(int x,int y,int color)
;----------------------------------------------------------------------------
; Routine sets the value of a pixel in native VGA graphics modes.
;
; Entry:		x		-	X coordinate of pixel to draw
;				y		-	Y coordinate of pixel to draw
;				color	-	Color of pixel to draw
;
;----------------------------------------------------------------------------

put16Pixel proc x:word, y:word, color:word

; this is done automagically by the decleration "proc"
;		push	bp					; Set up stack frame
;		mov		bp,sp

; Compute the pixel's address in video buffer
		mov		ax,[y]
		mov		bx,[x]
		mul		[xwidth]		; DX:AX := y * BytesPerLine

		mov		cl,bl				; CL := low-order byte of x

		shr		bx,3				; BX := x/8
		add		bx,ax
		adc		dx,0				; DX:BX := y*BytesPerLine + x/8

; we are only using page #0 so this is not needed
;		add		bx,[OriginOffset]	; DX:BX := byte offset in video buffer
;		adc		dx,[BankOffset]

		cmp		dx,[curbk]
		je		@@NoChange
		mov		ax,dx
		call	newbank

@@NoChange:
		mov		ax, 0A000h		;VGABufferSeg
		mov		es,ax				; ES:BX := byte address of pixel

		mov		ah,1				; AH := unshifted bit mask
		and		cl,7				; CL := x & 7
		xor		cl,7				; CL := # bits to shift left

; set Graphics Controller Bit Mask register
		shl		ah,cl				; AH := bit mask in proper postion
		mov		dx,3CEh				; GC address register port
		mov		al,8				; AL := Bit Mask Register number
		out		dx,ax

; set Graphics Controller Mode register
		mov		ax,0205h			; AL := Mode register number
									; AH := Write mode 2 (bits 0,1)
									;	Read mode 0 (bit 3)
		out		dx,ax

; set data rotate/Function Select register
		mov		ax,3				; AL := Data Rotate/Func select reg #
		out		dx,ax

; set the pixel value
		mov		al,[es:bx]			; latch one byte from each bit plane
		mov		ax,[color]			; AL := pixel value
		mov		[es:bx],al			; update all bit planes

; restore default Graphics Controller registers
		mov		ax,0FF08h			; default bit mask
		out		dx,ax

		mov		ax,0005				; default mode register
		out		dx,ax

		mov		ax,0003				; default function select
		out		dx,ax

;		pop		bp
		ret

put16Pixel endp


end

