//
// Project: Toolbars under IBM User Interface Class Libraries
// File:    Toolbar.hpp
// Author:  Stewart Hyde
// Created: Nov   29, 1993
// Updated: Nov   30, 1993
//
// Description:
//

#ifndef _IFRAME_HPP_
#include <iframe.hpp>                   //IFrameWindow Class
#endif

#ifndef _ICMDHDR_HPP_
#include <icmdhdr.hpp>                  //ICommandHandler & ICommandEvent
#endif

#ifndef _ISTATTXT_HPP_
#include <istattxt.hpp>                 //IStaticText Class
#endif

#ifndef _ISTRING_HPP_
#include <istring.hpp>                  //IString Class
#endif

#ifndef _IBMPCTL_HPP_
#include <ibmpctl.hpp>                  //IBitmapControl Class
#endif

#ifndef _IMENUBAR_HPP_
#include <imenubar.hpp>                 //IMenuBar Class                      
#endif


class ToolBar : public IFrameWindow,    //   Define ToolBar Class from
                public ICommandHandler  //   IFrameWindow & ICommandHandler
{
   public:
      ToolBar(unsigned long windowId);     
      Boolean command(ICommandEvent& cEvent);
};                                      // End of Toolbar class definition


class MainWin : public IFrameWindow,    //   Define MainWin Class from
                public ICommandHandler  //   IFrameWindow & ICommandHandler
{
public:
   MainWin(unsigned long windowId);     
   ~MainWin();
   Boolean command(ICommandEvent& cEvent);
protected:
   void createTopToolBar();
   void destroyTopToolBar();
   void createSideBar();
   void destroySideBar();
   void setupMenuBar(unsigned long windowId);     
private:
   IMenuBar                 *menuBar;
   Boolean                  fToolBarActive; 
   ToolBar                  *myToolBar; 
   Boolean                  fSideBarActive; 
   ToolBar                  *mySideBar; 
};                                      // End of MainWin class definition


