VERSION 2.00
Begin Form frmMain 
   Caption         =   "Scroll-1 Demo"
   Height          =   3180
   Icon            =   SCROLL-1.FRX:0000
   Left            =   1650
   LinkTopic       =   "Form1"
   ScaleHeight     =   185
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   249
   Top             =   1500
   Width           =   3855
   Begin PictureBox picCorner 
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   120
      ScaleHeight     =   225
      ScaleWidth      =   225
      TabIndex        =   3
      Top             =   120
      Width           =   255
   End
   Begin CommandButton cmdStart 
      Caption         =   "&Start"
      Height          =   375
      Left            =   2040
      TabIndex        =   0
      Top             =   120
      Width           =   1575
   End
   Begin VScrollBar vsb1 
      Height          =   1455
      LargeChange     =   50
      Left            =   120
      SmallChange     =   10
      TabIndex        =   2
      Top             =   480
      Width           =   255
   End
   Begin HScrollBar hsb1 
      Height          =   255
      LargeChange     =   50
      Left            =   480
      SmallChange     =   10
      TabIndex        =   1
      Top             =   120
      Width           =   1455
   End
   Begin PictureBox picBig 
      BackColor       =   &H00FFFF00&
      BorderStyle     =   0  'None
      Height          =   2055
      Left            =   480
      ScaleHeight     =   137
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   209
      TabIndex        =   4
      Top             =   600
      Width           =   3135
      Begin CommandButton cmdExit 
         Caption         =   "E&xit"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   9
         Top             =   1560
         Width           =   2895
      End
      Begin Label lblDownRight 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "to the four corners!"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   1200
         Width           =   2895
      End
      Begin Label lblDownLeft 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "and these labels will be moved"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   840
         Width           =   2895
      End
      Begin Label lblUpRight 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "the picture box will be enlarged,"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   480
         Width           =   2895
      End
      Begin Label lblUpLeft 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "When you click ""Start"","
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   120
         Width           =   2895
      End
   End
End

' SCROLL-1.FRM - Declarations.

    DefInt A-Z

' End Of Declarations.

Sub cmdExit_Click (Index As Integer)

' Completely self explanatory!

    End

End Sub

Sub cmdStart_Click ()

' Hide the Start button right away.

    cmdStart.Visible = False

' Move and enlarge the scrolling picture box.
'
' The "600, 400" can be changed to any reasonable size,
' up to a maximum of 16,383 by 16,383 pixels.
'
' If AutoRedraw=True then larger sizes use a _LOT_ more memory.

    picBig.Move 0, 0, 600, 400

' Move the four labels out to the corners of picBig. These are not critical,
' and they aren't necessary for scrolling the picBig box.

    lblUpLeft.Move 0, 0
    lblUpRight.Move (picBig.Width - lblUpRight.Width), 0
    lblDownLeft.Move 0, (picBig.Height - lblDownLeft.Height)

    temp1 = picBig.Width - lblUpRight.Width
    temp2 = picBig.Height - lblDownLeft.Height
    lblDownRight.Move temp1, temp2

' Now duplicate the "Exit" command button a few times, just to have some
' other sample controls on the form. These are not critical, and can be
' removed and replaced with any other kind of control.

    For temp = 1 To 7
	Load cmdExit(temp)
    Next temp

' Organize the little Exit buttons - just to have something else to scroll.
' The following code is NOT critical, and isn't necessary for scrolling the
' picBig box. You would normally put more MEANINGFUL controls onto the box,
' for example: Text boxes, command buttons, picture boxes, labels, option
' buttons, just about anything!

    For x = 0 To 7
	cmdExit(x).Move 75 + (x * 50), 50 + (x * 40), 100, 20
	cmdExit(x).Visible = True
    Next x

' Move the scroll bars to their correct locations.

    Call FixScrollBars

End Sub

Sub FixScrollBars ()

' Assume you won't need to display anything.

    vertFLAG = False
    horizFLAG = False
    cornerFLAG = False

' Figure out how much WIDTH of the picture box is hidden now,
' and if any width is hidden, you need a horizontal scroll bar.

    HiddenX = (picBig.Width) - (frmMain.ScaleWidth)
    If HiddenX > 0 Then horizFLAG = True

' Figure out how much HEIGHT of the picture box is hidden now,
' and if any height is hidden, you need a vertical scroll bar.

    HiddenY = (picBig.Height) - (frmMain.ScaleHeight)
    If HiddenY > 0 Then vertFLAG = True

' If horizontal scroll bar is ON, then slightly less height is available,
' so re-check the height.

    If horizFLAG = True Then
	HiddenY = (picBig.Height - 1) - (frmMain.ScaleHeight - hsb1.Height)
	If HiddenY > 0 Then vertFLAG = True
    End If

' If vertical scroll bar is ON, then slightly less width is available,
' so re-check the width.
    
    If vertFLAG = True Then
	HiddenX = (picBig.Width - 1) - (frmMain.ScaleWidth - vsb1.Width)
	If HiddenX > 0 Then horizFLAG = True
    End If

' If both scroll bars are ON, then turn on the corner box.

    If (horizFLAG = True) And (vertFLAG = True) Then cornerFLAG = True

' At this point, you know if hsb1/vsb1/picCorner will be ON or OFF,
' so if anything will be OFF, make it invisible now. This section doesn't
' make anything visible, because if something is invisible, it's better
' to leave it that way until AFTER it is moved.

    If horizFLAG = False Then hsb1.Visible = False
    If vertFLAG = False Then vsb1.Visible = False
    If cornerFLAG = False Then picCorner.Visible = False

' Move the vertical scroll bar over to the right side of the form,
' and make sure it's visible.

    If vertFLAG = True Then
	' Top is always 0.
	    vsb1.Top = 0
	' Find the new height - but watch out for negative numbers.
	    tempVH = frmMain.ScaleHeight - hsb1.Height + 2
	    If horizFLAG = False Then tempVH = frmMain.ScaleHeight + 1
	    If tempVH > 0 Then vsb1.Height = tempVH
	' Find the new left - but watch out for negative numbers.
	    tempVL = frmMain.ScaleWidth - vsb1.Width + 1
	    If tempVL > 0 Then vsb1.Left = tempVL
	' Show it.
	    vsb1.Visible = True
    End If

' Move the horizontal scroll bar down to the bottom of the form,
' and make sure it's visible.

    If horizFLAG = True Then
	' Left is always 0.
	    hsb1.Left = 0
	' Find the new width - but watch out for negative numbers.
	    tempHW = frmMain.ScaleWidth - vsb1.Width + 2
	    If vertFLAG = False Then tempHW = frmMain.ScaleWidth + 1
	    If tempHW > 0 Then hsb1.Width = tempHW
	' Find the new top - but watch out for negative numbers.
	    tempHT = frmMain.ScaleHeight - hsb1.Height + 1
	    If tempHT > 0 Then hsb1.Top = tempHT
	' Show it.
	    hsb1.Visible = True
    End If

' Move the little grey corner box to the lower right corner of the form.
' It's always the same width as vsb1, and the same height as hsb1,
' so even if those sizes are different, the corner will be perfect.

    If cornerFLAG = True Then
	picCorner.Move tempVL, tempHT, vsb1.Width, hsb1.Height
	picCorner.Visible = True
    End If

' Fix scroll bar values - so you can scroll to the hidden areas of picBig.
' These two lines are CRITICAL, and they're the key to the entire program.

    vsb1.Max = HiddenY
    hsb1.Max = HiddenX

End Sub

Sub Form_Resize ()

' Every time the form is resized, you need to move the scroll bars around.

    Call FixScrollBars

End Sub

Sub hsb1_Change ()

' Move the picture box to the left (into invisible negative numbers).
' Note the MINUS SIGN before "hsb1.value".

    picBig.Left = -hsb1.Value

End Sub

Sub vsb1_Change ()

' Move the picture box up (into invisible negative numbers).
' Note the MINUS SIGN before "vsb1.value".

    picBig.Top = -vsb1.Value

End Sub

