' ------------------------------------------------------------------------
' Visual Basic for MS-DOS Common Dialog Toolkit
'
' Copyright (C) 1982-1992 Microsoft Corporation
'
' You have a royalty-free right to use, modify, reproduce
' and distribute the sample applications and toolkits provided with
' Visual Basic for MS-DOS (and/or any modified version)
' in any way you find useful, provided that you agree that
' Microsoft has no warranty, obligations or liability for
' any of the sample applications or toolkits.
' ------------------------------------------------------------------------

' Include file containing declarations for called procedures.
'$INCLUDE: 'CMNDLG.BI'

' Common dialog form
'$FORM frmCmnDlg

CONST FALSE = 0
CONST TRUE = NOT FALSE

' CmnDlgClose common dialog support routine
'
' Unloads common dialog form (if you have preloaded it for
' better performance) so program will terminate,
' otherwise common dialog form will remain loaded but
' invisible.  This routine should be called if
' CmnDlgRegister was used to preload the form.  If
' CmnDlgRegister was not used, the form will be unloaded
' after each use.
'
SUB CmnDlgClose ()
    UNLOAD frmCmnDlg            ' Unload form.
END SUB

' CmnDlgRegister common dialog support routine
'
' Loads and registers common dialog form before using it
' to obtain better performance (loaded forms display faster
' than unloaded forms).  Form will remain loaded (but
' invisible) until this routine is called again to
' unload it.  Thus, all common dialog usage in your
' program will be faster (form is not loaded and unload
' each time a common dialog is invoked).  Keeping the
' form loaded requires more memory, however, than loading
' and unloading it each time a common dialog is used.
'
' Use of this routine is optional since the common dialog
' form does not need to be loaded before it is used (each
' common dialog routine will load the form is it is not
' loaded).
'
' Parameters:
'   Success - returns TRUE (-1) if the load or unload
'           attempt was successful, otherwise returns
'           FALSE (0).
'
SUB CmnDlgRegister (Success AS INTEGER)
    ' Set up error handling.
    ON LOCAL ERROR GOTO RegisterError

    LOAD frmCmnDlg              ' Load form.
    frmCmnDlg.Tag = "H"         ' Set flag for keeping form loaded after
                                ' each common dialog usage.

    Success = TRUE
    EXIT SUB

' Option error handling routine.
' Trap errors that occur when preloading dialog.
RegisterError:
    SELECT CASE ERR
    CASE 7:                                       ' Out of memory.
          MSGBOX "Out of memory.  Can't load Common Dialogs.", 0, "Common Dialog"
          Success = FALSE
          EXIT SUB
    CASE ELSE
          MSGBOX ERROR$ + ".  Can't load Common Dialogs.", 0, "Common Dialog"
          Success = FALSE
          EXIT SUB
    END SELECT
END SUB

' FileSave common dialog support routine
'
' Displays Save dialog which allows users to specify
' filename for subsequent file save operation.
' This procedure only provides the user interface and
' returns user input.  It does not actually carry out
' the corresponding action.
'
' Parameters:
'   FileName - returns the name (without path) of the
'           file for the save operation.  To supply
'           default filename in dialog, assign default
'           to FileName then pass it to this procedure.
'   PathName - returns the path (without filename) of
'           the file for the save operation.  To supply
'           default path in dialog, assign default to
'           PathName then pass it to this procedure.
'           Note, only pass a valid drive and path. Do
'           not include a filename or file pattern.
'   DefaultExt - sets the default search pattern for the
'           File Listbox.  Default pattern when DefaultExt
'           is null is "*.*".  To specify a different
'           search pattern (i.e. "*.BAS"), assign new
'           value to DefaultExt then pass it to this
'           procedure.
'   DialogTitle - sets the dialog title.  Default title
'           when DialogTitle is null is "Save As".  To
'           specify a different title (i.e. "Save My File"),
'           assign new value to DialogTitle then pass it to
'           this procedure.
'   ForeColor - sets the dialog foreground color.  Does not affect
'           SCREEN.ControlPanel color settings.
'   BackColor - sets the dialog background color.  Does not affect
'           SCREEN.ControlPanel color settings.
'   Flags - unused.  Use this to customize dialog action if needed.
'   Cancel - returns whether or not user pressed the dialog's Cancel
'           button.  True (-1) means the user cancelled the dialog.
'
SUB FileSave (FileName AS STRING, PathName AS STRING, DefaultExt AS STRING, DialogTitle AS STRING, ForeColor AS INTEGER, BackColor AS INTEGER, Flags AS INTEGER, Cancel AS INTEGER)
    ' Set up error handling for option validation.
    ON LOCAL ERROR GOTO FileSaveError

    ' Set form caption.
    IF DialogTitle = "" THEN
        frmCmnDlg.Caption = "Save As"
    ELSE
        frmCmnDlg.Caption = DialogTitle
    END IF
    frmCmnDlg.Tag = frmCmnDlg.Tag + "SAVE"              ' Set form tag for common unload procedure.

    ' Determine search pattern for file listbox.
    IF DefaultExt <> "" THEN
        frmCmnDlg.filOpenList.Pattern = DefaultExt
    ELSE
        frmCmnDlg.filOpenList.Pattern = "*.*"
    END IF

    ' Determine default path.
    IF PathName <> "" THEN
        ' If the path ends with a backslash, remove it.
        IF RIGHT$(PathName, 1) = "\" THEN
            PathName = LEFT$(PathName, LEN(PathName) - 1)
        END IF
        ' Set drive and path for file-system controls.

        ' Set File listbox path.  If PathName is different
        ' than current path, PathChange event will be triggered
        ' which updates Drive listbox drive and Directory listbox path.
        frmCmnDlg.filOpenList.Path = PathName
    END IF
    ' Display current path to the user.
    frmCmnDlg.lblOpenPath.Caption = frmCmnDlg.filOpenList.Path

    ' Determine default filename to display in edit field.
    IF FileName <> "" THEN
        frmCmnDlg.txtOpenFile.Text = UCASE$(FileName)
    ELSE
        frmCmnDlg.txtOpenFile.Text = frmCmnDlg.filOpenList.Pattern
    END IF

    ' Set default and cancel command buttons.
    frmCmnDlg.cmdOpenOK.Default = TRUE
    frmCmnDlg.cmdOpenCancel.Cancel = TRUE

    ' Size and position Open/Save container.
    frmCmnDlg.pctFileOpen.BorderStyle = 0
    frmCmnDlg.pctFileOpen.visible = TRUE

    ' Size and center dialog.
    frmCmnDlg.MOVE frmCmnDlg.Left, frmCmnDlg.Top, frmCmnDlg.pctFileOpen.Width + 2, frmCmnDlg.pctFileOpen.Height + 2
    frmCmnDlg.MOVE (SCREEN.Width - frmCmnDlg.Width) \ 2, ((SCREEN.Height - frmCmnDlg.Height) \ 2) - 2

    ' Set dialog colors.
    frmCmnDlg.ForeColor = ForeColor
    frmCmnDlg.BackColor = BackColor
    frmCmnDlg.pctFileOpen.ForeColor = ForeColor
    frmCmnDlg.pctFileOpen.BackColor = BackColor
    frmCmnDlg.lblOpenFile.ForeColor = ForeColor
    frmCmnDlg.lblOpenFile.BackColor = BackColor
    frmCmnDlg.txtOpenFile.ForeColor = ForeColor
    frmCmnDlg.txtOpenFile.BackColor = BackColor
    frmCmnDlg.lblOpenPath.ForeColor = ForeColor
    frmCmnDlg.lblOpenPath.BackColor = BackColor
    frmCmnDlg.filOpenList.ForeColor = ForeColor
    frmCmnDlg.filOpenList.BackColor = BackColor
    frmCmnDlg.drvOpenList.ForeColor = ForeColor
    frmCmnDlg.drvOpenList.BackColor = BackColor
    frmCmnDlg.dirOpenList.ForeColor = ForeColor
    frmCmnDlg.dirOpenList.BackColor = BackColor
    frmCmnDlg.cmdOpenOK.BackColor = BackColor
    frmCmnDlg.cmdOpenCancel.BackColor = BackColor

    ' Display dialog modally.
    frmCmnDlg.SHOW 1

    ' Determine if user canceled dialog.
    IF frmCmnDlg.cmdOpenCancel.Tag <> "FALSE" THEN
        Cancel = TRUE
    ' If not, return FileName and PathName.
    ELSE
        Cancel = FALSE
        FileName = frmCmnDlg.txtOpenFile.Text
        PathName = frmCmnDlg.filOpenList.Path
        frmCmnDlg.cmdOpenCancel.Tag = ""
    END IF

    ' Hide or unload dialog and return control to user's program.
    ' (Hide if user chose to preload form for performance.)
    IF LEFT$(frmCmnDlg.Tag, 1) = "H" THEN
        frmCmnDlg.pctFileOpen.visible = FALSE
        frmCmnDlg.HIDE
        frmCmnDlg.Tag = "H"              ' Reset tag.
    ELSE
        UNLOAD frmCmnDlg
    END IF

    EXIT SUB

' Option error handling routine.
' Ignore errors here and let dialog's controls
' handle the errors.
FileSaveError:
    SELECT CASE ERR
    CASE 7:                                       ' Out of memory.
          MSGBOX "Out of memory.  Can't load dialog.", 0, "FileSave"
          Cancel = TRUE
          EXIT SUB
    CASE ELSE
          RESUME NEXT
    END SELECT
END SUB

