%FALSE=0
%TRUE=NOT %FALSE
%DISABLE=0
%ENABLE = NOT %DISABLE

%IO.DIRECT = %ENABLE   'use direct access to video ram
%IO.ANSI   = %DISABLE  'use ANSI driver for keyboard/display (redirectable)
%IO.BIOS   = %DISABLE  'use BIOS for keyboard/display
%BI.DBASE  = %DISABLE  'incorporate dBASE commands
%BI.GRAPH  = %DISABLE  'incorporate graphics commands
%BI.MENUS  = %DISABLE  'incorporate text mode user interface commands


$ERROR ALL ON
$STACK 4096
$DIM ARRAY

$IF %IO.DIRECT
  $LIB LPT ON, GRAPH OFF, IPRINT ON, COM OFF
$ELSE
  $LIB LPT OFF, GRAPH OFF, IPRINT OFF, COM OFF
$ENDIF

OPTION BINARY BASE 1            ' dBASE routines require this
REDIM 	PROGRAM$(1000)  	' Array to store program source code
DIM 	VAR$	(256)   	' Array to store variable names
DIM 	VALUE$	(256)   	' Array to store variable contents
DIM 	ARG$	(16)    	' Buffer array for argument stack pushpop
DIM	GosubStack%(32)		' Stack to store return pointers
DIM     LITERAL$(16)            ' Storage of parameter names

SHARED Row%, Col%, Cur% 	' Store original cursor position and state
SHARED ProgLine%, Prog%         ' Current line number and running status
SHARED MaxLine%			' How many lines in the program
SHARED CrLf$                    ' Contains carriage return character
SHARED ARG$(), ArgPtr%          ' Argument stack for parsing statements
SHARED VAR$(), VALUE$()         ' Storage arrays for variables
SHARED Literal$(), NextVar%     ' Literal variable name and Next free var #
SHARED PROGRAM$(), ORG$         ' Source code array and saved screen image
SHARED Token$,TokenType,P,Arg$  ' Used by the CALC function.
SHARED GosubStack%(), GosubPtr% ' Used for GOSUB..RETURN
SHARED ExitFlag%                ' Used by IF and other logic commands
SHARED RepeatFlag%              ' Used by WHILE and UNTIL

$INCLUDE "DATATYPE.BAS"
$INCLUDE "ERRORMSG.BAS" ' Data statements with error messages
$INCLUDE "CALC.BAS"     ' arithmetic calculator routine (RCD)
$INCLUDE "PREP.BAS"     ' Interpreted code pre-processor subroutine
$INCLUDE "CUSTOM.BAS"   ' SUBs and FUNCTIONs for custom commands
$INCLUDE "BOZO_IO.BAS"  ' General input output procedures
$INCLUDE "VSET.BAS"     ' Routines to get, set and clear variables
$INCLUDE "DATABASE.BAS" ' dBASE interface
$INCLUDE "BTREE.BAS"    ' indexing

IF %IO.ANSI THEN CrLf$=CHR$(13,10) ELSE CrLf$=CHR$(13)

' Set a trap for CONTROL-C to break the program
KEY 15,chr$(4,46,&H70)
ON KEY(15) GOSUB BREAK
KEY(15) ON


' A simple way to call the interpreter. With PROGRAM$() empty and Prog%
' set to 0 it will start in command mode.  Put a program into the array
' and call PROGRUN with Prog% set to NOT 0 and ProgLine% set to 0 or 1
' and PROGRUN will start out by running the program instead.  Be sure to
' end your program with QUIT or END in order to exit the interpreter
' without going into command mode when the program ends.

'ON ERROR GOTO ErrorHandler
PROGRUN PROGRAM$()
END

' =========================================================================
SUB PROGRUN (RUNPROG$())
EXIT FAR AT ExitFar:
IF CrLf$="" THEN CrLf$=CHR$(13)  ' some output may want line feeds added

PROGINPUT: ' Here we create a string variable called PROG$.  this variable
           ' will either be the next line to execute in the program (prog%=1)
           ' or it will be entered at the keyboard (prog%=0).

IF Prog% THEN      'single-step parent program if currently running
 	stp:       'where we skip to if the line is blank

   	IF Progline% > UBOUND(RUNPROG$) THEN  '..... no more program to run!
        	Prog% = 0                     ' stop executing
                GOTO PROGINPUT                ' go back to command mode
        ELSE
   		IF RTRIM$(RUNPROG$(Progline%)) = "" THEN '.....blank line!
                	Progline% = Progline% + 1        ' skip it
                	GOTO stp                         ' and try the next
                END IF
   	Prog$ = RTRIM$(RUNPROG$(Progline%))              ' trim what we have
	END IF

ELSE  ' ...program is NOT running, get user input in command mode !!!!!!!!

	LOCATE ,,1 '......................turn on cursor
        BOZOPRINT CrLf$+"OK"+CrLf$ '......display a prompt
        Prog$=BOZOINPUT$ '................get user input

        ' From here you can enter a direct statement like QUIT or PRINT,
        ' but you can also write a program by entering a LINE NUMBER
        ' followed by a line of code.

        IF VAL(Prog$) THEN '.............................. has a line number!
	 	A% = VAL(Prog$): B% = INSTR(Prog$, " ") '..... get the line $
	        IF B% = 0 OR A% > UBOUND(RUNPROG$()) THEN '...... is it good?
         		PRINT "Illegal program line." + CHR$(7) '........NOT!
                 	GOTO PROGINPUT '....................Try again, Sucker
	 	END IF
         	LET RUNPROG$(A%)=MID$(Prog$, B% + 1) '......add line to array
	 	IF A%>MaxLine% THEN MaxLine%=A% '...........find highest line
		GOTO ProgInput '.............. don't execute it, just go back
	END IF
END IF

Bak$=Prog$

RepeatLabel:
RepeatFlag%=0 '................... set to true if statement is to be repeated
ExitFlag%=0 '............... set to true if statement is aborted by condition
PREP Prog$ '.......................... PREPROCESS THE STATEMENT !!!!!!!!!!!!!
EXEC Prog$ '.......................... EXECUTE THE PROGRAM LINE !!!!!!!!!!!!!
IF RepeatFlag% THEN Prog$=Bak$:GOTO RepeatLabel

DO:Dummy$=POPARG$:LOOP WHILE ArgPtr%>0 '..... remove any extraneous arguments

IF Prog% THEN INCR Progline% '.if the program is still running then increment
GOTO ProgInput '..............the line pointer and execute the next statement

' yeah, but what about changing the value of Progline% with GOTO and stuff?
' what about running a new program with LOAD or RUN commands?  That's all
' handled in the EXEC sub.

ExitFar:
END SUB

SUB EXEC (Prg$)

IF INSTR(Prg$,ANY " ,;") THEN
	RPrg$=MID$(Prg$, INSTR(Prg$,ANY " ,;")+1)
	Prg$=LEFT$(Prg$, INSTR(Prg$,ANY " ,;")-1)
	Rprg$=LTRIM$(RTRIM$(RPrg$))
	EXEC RPrg$
        IF ExitFlag% THEN EXIT SUB
END IF

SELECT CASE UCASE$(Prg$)

        $INCLUDE "LOADRUN.CMD"   ' Run, Load, Quit, List, etc.
        $INCLUDE "VIDEO_IO.CMD"  ' Print, Input, TAB, CR, etc.
        $INCLUDE "VARIABLE.CMD"  ' LET, SET, etc.
        $INCLUDE "FLOW.CMD"      ' GOTO, GOSUB, other flow control commands
        $INCLUDE "CALC.CMD"      ' CALC, arithmetic processing commands.
        $INCLUDE "LOGIC.CMD"     ' IF, WHILE, UNTIL, etc.
        $INCLUDE "FUNCTION.CMD"  ' functions (ucase, lcase, chr, etc)
        $INCLUDE "CUSTOM.CMD"    ' custom commands and functions
        $INCLUDE "DATABASE.CMD"

	CASE ELSE

                ' It's a variable.  Check to see if it has been defined.
                IF VAL(PRG$) THEN
                	PUSHARG PRG$
                ELSE
                	PUSHARG GETVAR$(PRG$)'.......... yes, push the value
                LITERAL$(ArgPtr%)=UCASE$(PRG$) '....... save the literal name

	        '.......We may need to remember the name of the var for later
                END IF
END SELECT
END SUB


SUB PUSHARG(X$)
	INCR ArgPtr%
	ARG$(ArgPtr%)=X$
END SUB

FUNCTION POPARG$
	IF ArgPtr%>0 THEN
	P$=ARG$(ArgPtr%)
	DECR ArgPtr%
Concate:
	IF ArgPtr%>0 AND ARG$(ArgPtr%)="&" THEN
        	DECR ArgPtr%
	        P$=P$+Arg$(ArgPtr%)
                IF ArgPtr%>0 THEN DECR ArgPtr%
        	GOTO Concate
        END IF
AndOr:
	IF ArgPtr%<0 AND ARG$(ArgPtr%)="&&" THEN
        	DECR ArgPtr%
                P$=STR$(ISTRUE(VAL(P$)) AND ISTRUE(VAL(Arg$(ArgPtr%))) )
		IF ArgPtr%>0 THEN DECR ArgPtr%
        	GOTO AndOr:
        END IF

	IF ArgPtr%<0 AND ARG$(ArgPtr%)="||" THEN
        	DECR ArgPtr%
                P$=STR$(ISTRUE(VAL(P$)) OR ISTRUE(VAL(Arg$(ArgPtr%))))
		IF ArgPtr%>0 THEN DECR ArgPtr%
                GOTO AndOr:
        END IF



	END IF
        POPARG$=P$
END FUNCTION





ErrorHandler:
RESTORE ErrorMessages
DO
	READ E, E$
	IF E=999 THEN EXIT DO
LOOP UNTIL E=ERR

BOZOPRINT CHR$(7) + CrLf$ + "ERROR:" + STR$(ERR) + "  " + E$ + CrLf$
BOZOPRINT "Continue? (y/n) --> "
DO
        A$=UCASE$(BOZOINPUT$)
	IF A$="N" THEN END
LOOP WHILE A$<>"Y"
RESUME NEXT


Break:
BOZOPRINT CHR$(7) + CrLf$ + "BREAK: Program interrupted by user" + CrLf$
BOZOPRINT "Resume? (y/n) --> "
DO
        A$=UCASE$(BOZOINPUT$)
	IF A$="N" THEN END
LOOP WHILE A$<>"Y"
RETURN



SUB CWAIT
DO UNTIL LEN(BOZOINKEY$):LOOP
END SUB

SUB BOZOL (X$)
	PREP X$
        EXEC X$
END SUB