'********************************PAWS2.BAS*******************************
'This program will run in the QuickBASIC environment and you can make
'stand-alone *.EXE files that permit you to use a mouse in a DOS program.
'When you start QuickBASIC, you MUST load the Quick Library QB.QLB
'so that you can CALL INTERRUPT.
'
'The command is:
'QB/L QB.QLB
'
'I have called this PAWS2.BAS (and the executable program PAWS2.COM)
'because it has two (2) PAUSE commands, keyboard and mouse.
'
'Please... please... no applause for the PAWS2 play on words as I
'am sure you know that a mouse has paws too (2?).
'
'This is a giant step forward, not for mankind, but for mouse users that
'want that mouse for QuickBASIC use.
'
'John De Palma on CompuServe 76076,571
'
'12/30/93
'
DEFINT A-Z
CONST False = 0
CONST True = NOT False

'interrupt call for both INTERRUPT and INTERRUPTX
TYPE RegType
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
     ds    AS INTEGER
     es    AS INTEGER
END TYPE

DECLARE SUB MouseFunction (m1%, m2%, m3%, m4%)
DECLARE SUB IsMouse (Yes%)
DECLARE SUB SetCursor (row%, col%)
DECLARE SUB ClearBuffer ()
DECLARE SUB ButtonStatus (m1%, m2%, m3%, m4%)
DECLARE SUB ShowCursor (Hide%)
DECLARE SUB HideCursor (Hide%)

'executable code below
COLOR 15, 1
CLS
DEF FnCenter (text$) = 41 - (LEN(text$) \ 2)
SCREEN 0
WIDTH 80

CALL IsMouse(Yes%)
   
    IF Yes% THEN
        PRINT "CLICK! or Press a key to Continue...";
        row = CSRLIN
        col = POS(0)
        CALL SetCursor(row, col)
        ClearBuffer
        DO
            CALL ButtonStatus(m1, m2, m3, m4)
        LOOP UNTIL LEN(INKEY$) OR m2 <> 0
        CALL HideCursor(Hide%)
    ELSE
        PRINT "Press a Key to Continue...";
        ClearBuffer
        WHILE INKEY$ = "": WEND
    END IF

SUB ButtonStatus (m1, m2, m3, m4)
    m1 = 3
    CALL MouseFunction(m1, m2, m3, m4)

END SUB

SUB ClearBuffer
WHILE INKEY$ <> "": WEND
END SUB

SUB HideCursor (Hide%)
    m1 = 2
    CALL MouseFunction(m1, 0, 0, 0)
    Hide% = Hide% + 1             'have to show cursor one more than
END SUB                           'this number to see the cursor again

'tests for Mouse Software installed then Mouse Hardware.
SUB IsMouse (Yes%)
    Yes% = True
    DEF SEG = 0
   
    MouseSegment& = 256& * PEEK(207) + PEEK(206)
    MouseOffset& = 256& * PEEK(205) + PEEK(204)

    DEF SEG = MouseSegment&

    IF (MouseSegment& = 0 AND MouseOffset& = 0) OR PEEK(MouseOffset&) = 207 THEN
        Yes% = False
        MouseChecked = True
        DEF SEG
        text$ = "Can't Find Mouse-Driver -> SOFTWARE!"
        LOCATE 2, FnCenter(text$)
        PRINT text$
        EXIT SUB
    END IF
   
    m1 = 0                          'mouse reset and status
    CALL MouseFunction(m1, m2, 0, 0)
    IF m1 THEN
        text$ = "A -" + LTRIM$(STR$(m2)) + "- BUTTON mouse is present"
        LOCATE 2, FnCenter(text$)
        PRINT text$
        CALL ShowCursor(Hide%)      'show cursor
    ELSE
        text$ = "Can't find Mouse-Driver - HARDWARE or Software!"
        LOCATE 2, FnCenter(text$)
        PRINT text$
        Yes% = False
    END IF
END SUB

SUB MouseFunction (m1%, m2%, m3%, m4%)
   
    DIM Regs AS RegType
 
    Regs.ax = m1
    Regs.bx = m2
    Regs.cx = m3
    Regs.dx = m4

    CALL INTERRUPT(&H33, Regs, Regs)

    m1 = Regs.ax
    m2 = Regs.bx
    m3 = Regs.cx
    m4 = Regs.dx

END SUB

SUB SetCursor (row%, col%)
    m1 = 4
    m3 = (col% * 8) - 1
    m4 = (row% * 8) - 1
    CALL MouseFunction(m1, 0, m3, m4)

END SUB

SUB ShowCursor (Hide%)
   
    FOR i = Hide% TO Hide% + 1           'have to show once more than hide
        m1 = 1                           'ie, hide cursor twice, show thrice
        CALL MouseFunction(m1, 0, 0, 0)
    NEXT

END SUB

