/* C_LIKE VERSION OF ARRAY.PRG                                          */
#define C_LIKE

// Notice the use of {, and } for the control structure
// Notice the requirement for swbreak to resume execution
// at the end of the current switch control structure
//
// Swbreak is valid in both c_like and non c_like syntaxes

// Swbreak is REQUIRED at the end of each case section in C_LIKE mode
// to prevent the execution of the next block


/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */

#include "Common.ch"
#include "Inkey.ch"


// Maintains the current row of ABrowse()
STATIC nRow


/***
*
*  ABrowse( <aArray> [,<nTop>][,<nLeft>][,<nBottom>][,<nRight>] ) --> xValue
*
*  Browse a 2-dimensional array using a TBrowse object
*
*  Parameters:
*     aArray  - The 2D array to browse
*     nTop    - Optional line on which to display the top margin of the browse
*     nLeft   - Optional column of the left margin of the browse
*     nRight  - Optional column of the right margin of the browse
*     nBottom - Optional line of the bottom margin of the browse
*
*  Returns: The value of the highlighted array element
*
*/
FUNCTION ABrowse( aArray, nT, nL, nB, nR )
   
    LOCAL nOldCursor     // Saves current cursor shape
    LOCAL nOldNRow       // Saves current row
    LOCAL xRet           // Return value (user's selection or NIL)
    LOCAL nKey := 0      // Keystroke holder
    LOCAL n              // FOR..NEXT counter variable
    LOCAL o              // TBrowse object

    // Preserve cursor setting, turn off cursor
    nOldCursor := SETCURSOR( 0 )

    // Preserve static var (just in case), set it to 1
    nOldNRow := nRow
    nRow     := 1


    // Assign defaults for omitted parameters
    DEFAULT nT TO 0
    DEFAULT nL TO 0
    DEFAULT nB TO MAXROW()
    DEFAULT nR TO MAXCOL()

    // Create the TBrowse object
    o := TBrowseNew( nT, nL, nB, nR )

    // This skip block just adds to (or subtracts from) nRow
    // (see aSkipTest for explanation of that function)
    o:skipBlock := { |nSkip| nSkip := ASkipTest( aArray, nRow, nSkip ), ;
                             nRow += nSkip,                             ;
                             nSkip                                      ;
                   }

    // The go top block sets nRow to 1
    o:goTopBlock := { || nRow := 1 }

    // The go bottom block sets nRow to the length of the array
    o:goBottomBlock := { || nRow := LEN( aArray ) }

    // Create column blocks and add TBColumn objects to the TBrowse
    // (see ABrowseBlock() below)
    FOR n := 1 TO LEN( aArray[1] )
      o:addColumn( TBColumnNew( "", ABrowseBlock( aArray, n )))
    NEXT

    // Main key handler loop
    DO WHILE .T.

        // Stabilize the browse and wait for a keystroke
        o:forceStable()

        // Browse is already stable -- no need to check
        switch(nKey := INKEY( 0 ))
        {{

            CASE K_DOWN : o:down();swbreak
            CASE K_UP   : o:up();swbreak

            /* The c-like fall through */
            CASE K_PGUP :
            CASE K_PGDN :
            CASE K_RIGHT: o:right()

                /* Nested switch */
                /* Special keys  */
                switch(nkey)
                {
                     case K_PGUP: o:PgUp();swbreak

                     // Swbreak not needed here
                    case K_PGDN: o:PgDn()

                }

                // Resume at end of switch
                swbreak;

            /* The c-like fall through */
            CASE K_HOME :
            CASE K_END  :
            CASE K_LEFT : o:left()

                /* Nested switch */
                /* Special keys  */
                switch(nkey)
                {
                    case K_HOME: o:PgUp();swbreak
                    case K_END : o:PgDn()

                }

                // Resume at end of switch
                swbreak;

                // break not needed, resumption at end of switch
                // swbreak;


        }}

    ENDDO


    // Set the return value
    xRet := IF( nKey == K_RETURN, aArray[nRow, o:colPos], NIL )

    // Restore the original cursor setting
    SETCURSOR( nOldCursor )

    // Restore the static var
    nRow := nOldNRow


RETURN (xRet)

/* Remainder of sample file omitted for brevity -- can be located in your */
/* samples directory                                                      */
