{ ========================================================================== }
{ QwikDemo.pas - Demo program for QWIK screen utilities.  ver 7.1a, 09-23-93 }
{                                                                            }
{ Demo has been programmed best for color cards in 25-line mode.  It can     }
{ also be tested in 40-column mode.                                          }
{   Copyright (c) 1986,1993 James H. LeMay, Eagle Performance Software       }
{ ========================================================================== }

program QwikDemo;

{$A-,B-,D-,E-,F-,G-,I-,L-,N-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{ $A+,B-,D+,E-,F-,G-,I-,L+,N-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 12000, 0, 0}

uses
  Crt,Qwik,Strs;

type
  BrdrRec =
    record                 { For Qbox procedure }
      TL,TH,TR,LV,RV,BL,BH,BR: char;
    end;

var
  Strng,Strng2:          string[75];
  Data: array [1.. 9] of string[41];
  Vert: array [1..24] of string[41];
  PC:   array [1..14] of string[41];
  Init: array [1..11] of string[41];
  Other:array [1..12] of string[41];
  Crsr: array [1..13] of string[41];
  Eoss: array [1.. 5] of string[41];
  SavedBlock, PopUpBlock: array [1..4000] of byte;
  ColL,ColR:              array [1..3] of byte;
  Row,Rows,Col,Cols,Step,ColMax: byte;
  i,Count,Fgrnd,Bgrnd:           word;
  BrdrAttr, WndwAttr:            integer;
  BlkRow,BlkCol,V:               byte;
  Rnum:                          Real;
  Ch:                            char;
  LastVideoMode:                 byte;

const
  Wait: word = 400;      { One unit of wait in milliseconds for demo. }
  { These are lines for Qbox }
  Border1: BrdrRec = (TL:'';TH:'';TR:'';
                      LV:'';       RV:'';
                      BL:'';BH:'';BR:'');
  Border2: BrdrRec = (TL:'';TH:'';TR:'';
                      LV:'';       RV:'';
                      BL:'';BH:'';BR:'');
  BWcolors: array[0..3] of byte = (
              Black,        { Black     on Black }
              LightGray,    { LightGray on Black }
              White,        { White     on Black }
              LightGrayBG); { Black     on LightGray }

{ Since Zenith doesn't have snow on any CGAs, turn off snow checking }
procedure CheckZenith;
type CharArray8 = array[1..8] of char;
var  ZdsRom: ^CharArray8;
begin
  ZdsRom := Ptr(SegF000,$800C);
  if Qsnow and (ZdsRom^='ZDS CORP') then
    begin
      Qsnow    := false;
      CardSnow := false;
    end;
end;

{ Qbox is an application of QWIK screen utilities.  It can make fast
  pop-up menus.  See WNDWxx.ZIP for more applications. }
procedure Qbox (Row,Col,Rows,Cols: byte; WndwAttr,BrdrAttr: integer;
                                                      Brdr: BrdrRec);
begin
  if (Rows>=2) and (Cols>=2) then
  begin
    with Brdr do
    begin
      Qwrite    (Row       ,Col                     ,BrdrAttr,TL);
      QfillEos  (                           1,Cols-2,BrdrAttr,TH);
      QwriteEos (                                    BrdrAttr,TR);
      Qfill     (Row+1     ,Col       ,Rows-2,1     ,BrdrAttr,LV);
      Qfill     (Row+1     ,Col+Cols-1,Rows-2,1     ,BrdrAttr,RV);
      Qwrite    (Row+Rows-1,Col                     ,BrdrAttr,BL);
      QfillEos  (                           1,Cols-2,BrdrAttr,BH);
      QwriteEos (                                    BrdrAttr,BR);
      Qfill     (Row+1     ,Col+1     ,Rows-2,Cols-2,WndwAttr,' ')
    end
  end
end;

procedure CloseDemo;
begin
  if QVideoMode<=CO40 then
    begin
      if LastVideoMode>CO40 then
        delay (Wait*4);
      TextMode (LastVideoMode+hi(LastMode));
    end;
  GotoRC (23, 1);
  SetCursor (CursorInitial);
end;

procedure PromptKey;
begin
  Qwrite (25,CRTcols-19,SameAttr,'press any key ...');
  Ch := ReadKey;
  if Ch=#27 then
    begin
      CloseDemo;
      Halt;
    end;
end;

procedure ClearScreen (Attr: integer);
begin
  Qbox ( 1, 1,CRTrows,CRTcols,Attr,Attr,Border1);
end;

procedure ExplodeBoxes;
var
  TopRow,BottomRow,MaxRows,MaxCols,DeltaCols,LeftCol,RightCol: byte;
  CenterCol:    byte;
  ClockReading: word absolute $0040:$006C; { low memory clock }
  StartTime:    word;

{}procedure ScatterBoxes;
{}begin
{}  Rows:= succ(random(MaxRows));
{}  if QVideoMode<=CO40 then              { Keep aspect 1:1 }
{}       Cols:= Rows + Rows shr 2         { 1.2 cols/row }
{}  else Cols:= Rows shl 1 + Rows shr 1;  { 2.4 cols/row }
{}  Col := LeftCol + random (RightCol-LeftCol-Cols+2);
{}  Row := TopRow  + random (BottomRow-TopRow-Rows+2);
{}  if QVideoMode=Mono then
{}  TextAttr:=BWcolors[(random(4))]
{}  else
{}    begin
{}      Fgrnd:= random (16);
{}      Bgrnd:= random (8);
{}      if Bgrnd=Fgrnd then inc(Fgrnd);
{}      TextAttr:=Fgrnd + Bgrnd shl 4;
{}    end;
{}  Qfill (Row,Col,Rows,Cols,TextAttr,#178);
{}end;

begin
  CenterCol:=CRTcols shr 1;
  randomize;
  StartTime:=ClockReading;
  for Step:=1 to 12 do
    begin
      { Set boundaries }
      TopRow:=13-Step;
      BottomRow:=13+Step;
      MaxRows:=Step;
      if QVideoMode<=CO40 then                      { Keep aspect 1:1 }
        begin
          MaxCols:= MaxRows + MaxRows shr 2;        { 1.2 cols/row }
          DeltaCols:=(Step*5 div 3);
        end
      else
        begin
          MaxCols:= MaxRows shl 1 + MaxRows shr 1;  { 2.4 cols/row }
          DeltaCols:=(Step*10 div 3);
        end;
      LeftCol  :=succ(CenterCol)-DeltaCols;
      RightCol :=CenterCol+DeltaCols;
      if Step<12 then
        begin
          for Count:=1 to 40 do ScatterBoxes;
        end
      else
        repeat
          ScatterBoxes;
        until ClockReading-StartTime>=60;  { about 60/18.2 seconds }
    end;
end;

procedure InitDemo;
begin
{ --- Set up data --- }
{ If you set a mode, do it first before Qinit! }
{ Please!  Test a mode first to see if it is different than what you want; }
{ then change if necessary.  Otherwise, the screen jumps. }

  CheckBreak := false;
  CheckZenith;
  SetMultiTask;
  LastVideoMode := QVideoMode;
  if (QVideoMode<>Mono) and not Have3270 then
    begin
      ClearScreen (LightGray+BlackBG);
      QwriteC (11,1,CRTcols,SameAttr,'(1) 80 column mode');
      QwriteC (12,1,CRTcols,SameAttr,'(2) 40 column mode');
      QwriteC (14,1,CRTcols,SameAttr,'Which mode [1,2]? ');
      GotoEos;
      repeat
        Ch:=ReadKey;
      until ch in ['1','2'];
      V := QVideoMode;
      case ch of
        '1': case V of
               BW40: V:=BW80;
               CO40: V:=CO80;
             end;
        '2': case V of
               BW80: V:=BW40;
               CO80: V:=CO40;
             end;
      end;
      if V<>LastMode then
        begin
          TextMode (V);
          Qinit;           { << Do Qinit again after change of mode!! }
          CheckZenith;
          SetMultiTask;
        end;
    end;
  ModCursor (CursorOff);
  Strng:=   'Q Screen Utilities';
  Strng2:=  ' QWIK Screen Utilities  ';
  Data[1]:= '1';
  Data[2]:= '22';
  Data[3]:= '333';
  Data[4]:= Strng;
  Data[5]:= 'Odd  Length';
  Data[6]:= 'Even  Length';
  Data[7]:= '18 characters wide';
  Data[8]:= '19 characters width';
  Data[9]:= 'Margin to Margin width';
  Vert[1]:= 'TABLE 1';
  Vert[2]:= '1234567890123';
  Vert[3]:= '';
  Vert[4]:= ' xxx x xx x';
  Vert[5]:= '--------';
  Vert[6]:= '';
  Vert[7]:= '';
  Vert[8]:= 'unknown';
  Vert[9]:= '';
  Vert[10]:= '';
  Vert[11]:= '';
  Vert[12]:= 'IN';
  Vert[13]:= '';
  Vert[14]:= 'OUT';
  Vert[15]:= '';
  Vert[16]:= 'CHKD';
  Vert[17]:= '';
  Vert[18]:= '';
  Vert[19]:= '';
  Vert[20]:= 'TBA';
  Vert[21]:= '';
  Vert[22]:= '';
  Vert[23]:= 'CHKD';
  Vert[24]:= '';
  PC[1]:=  'COMPUTERS:           ADAPTERS:';
  PC[2]:=  '------------------   ----------';
  PC[3]:=  'IBM PC               MDA';
  PC[4]:=  'IBM XT               CGA';
  PC[5]:=  'IBM AT               EGA';
  PC[6]:=  'IBM PCjr             MCGA';
  PC[7]:=  'IBM PC Convertible   VGA';
  PC[8]:=  'IBM PS/2 Model 25    8514/A';
  PC[9]:=  'IBM PS/2 Model 30    Hercules:';
  PC[10]:= 'IBM PS/2 Model 50      HGC';
  PC[11]:= 'IBM PS/2 Model 60      HGC Plus';
  PC[12]:= 'IBM PS/2 Model 70      InColor';
  PC[13]:= 'IBM PS/2 Model 80';
  PC[14]:= 'IBM 3270 PC';
  Other[ 1]:='QscrollUp  - Qwik scroll up';
  Other[ 2]:='QscrollDown- Qwik scroll down';
  Other[ 3]:='QscrToVscr - block to virtual screen';
  Other[ 4]:='QVscrToScr - virtual screen to block';
  Other[ 5]:='QreadStr   - reads string from screen';
  Other[ 6]:='QreadChar  - reads char   from screen';
  Other[ 7]:='QreadAttr  - reads attr   from screen';
  Other[ 8]:='QviewPage  - view any video page';
  Other[ 9]:='QwritePage - write to any video page';
  Other[10]:='QwriteSub  - for sub-strings';
  Other[11]:='QfillC     - a self-centering Qfill';
  Other[12]:='QattrC     - a self-centering Qattr';
  Crsr[ 1]:='GotoRC      - absolute cursor position';
  Crsr[ 2]:='WhereR      - absolute cursor row';
  Crsr[ 3]:='WhereC      - absolute cursor column';
  Crsr[ 4]:='SetCursor   - sets cursor mode';
  Crsr[ 5]:='GetCursor   - gets cursor mode';
  Crsr[ 6]:='ModCursor   - modifies cursor mode';
  Crsr[ 7]:='CursorInitial   - cursor at startup';
  Crsr[ 8]:='CursorUnderline - normal cursor';
  Crsr[ 9]:='CursorHalfBlock - for insert editing';
  Crsr[10]:='CursorBlock     - for the nearsighted';
  Crsr[11]:='A total of 43 utilities';
  Crsr[12]:='optimizing in just 2.9k bytes or less!';
  Init[1]:=' Works in DOS and DPMI platforms';
  Init[2]:=' Detects dual monitor/adapters for';
  Init[3]:='   all systems previously listed';
  Init[4]:=' Identifies each system by name';
  Init[5]:=' Gets System ID and Submodel ID';
  Init[6]:=' Gets CPU ID';
  Init[7]:=' Sets FAR pointer for virtual screens';
  Init[8]:=' Determines need for wait-for-retrace';
  Init[9]:=' Gets screen dimensions: Rows by Cols';
  Init[10]:=' Determines the number of video pages';
  Init[11]:=' Sets 4 standard cursor shapes';
  Eoss[1]:='  QwriteEos    - just like Qwrite    ';
  Eoss[2]:='  QwriteEosV   - just like QwriteV   ';
  Eoss[3]:='  QwriteEosSub - just like QwriteSub ';
  Eoss[4]:='  QfillEos     - just like Qfill     ';
  Eoss[5]:='  QattrEos     - just like Qattr     ';
end;

procedure ExplodeScreen;
begin
  { --- Initial screen --- }
  ClearScreen (White+BlueBG);
  QwriteC (11, 1,CRTcols,Yellow+BlueBG,Strng2);
  QwriteC (13, 1,CRTcols,SameAttr,'Your screen is about to explode.');
  QwriteC (14, 1,CRTcols,SameAttr,'Hold on to your seat ...');
  Delay   (Wait*5);

  { --- Explosion of Boxes --- }
  ClearScreen (Black+LightGrayBG);
  ExplodeBoxes;

  QfillC  (10, 1,CRTcols, 6,34,RedBG  ,' ');
  QfillC  (11, 1,CRTcols, 4,30,BrownBG,' ');
  TextAttr:= Yellow+RedBG;
  QwriteC (12, 1,CRTcols,TextAttr,Strng2);
  QwriteC (13, 1,CRTcols,TextAttr,'     Version  7.1a      ');
end;

procedure SaveScreen;
begin
  { --- Save Screen for Page Demo --- }
  if MaxPage>0 then
    begin
      QstoreToMem ( 1, 1,25,CRTcols,SavedBlock);
      QwritePage  (1);
      QstoreToScr ( 1, 1,25,CRTcols,SavedBlock);
      QwritePage  (0);
    end;
  { --- End of Save Screen --- }
  Delay   (Wait*4);
  TextAttr:= White+BlueBG;
  QwriteC ( 6, 1,CRTcols,TextAttr,' Qwrite will write with new attributes  ');
  QwriteC ( 7, 1,CRTcols,TextAttr,' that you specify direct to the screen. ');
  Delay   (Wait*6);
  QwriteC (18, 1,CRTcols,SameAttr,'Qwrite will also use existing attributes');
  QwriteC (19, 1,CRTcols,SameAttr,'   when you do not even know or care.   ');
                        { highlight the word 'existing' }
  QattrC  (18, 6,CRTcols+5,1,10,White+RedBG+Blink);
  Delay   (wait*10);
  QwriteC (21, 1,CRTcols,TextAttr,' Say Goodbye to this screen. ');

  Delay   (wait*3);
  { --- Disintigrate Screen --- }
  for i:=1 to 5000 do
    begin
      Row:=random(25)+1;
      Col:=random(CRTcols)+1;
      Qfill (row,col, 1, 1,Black,' ');
    end;
end;

procedure ListCompatibles;
begin
  { --- Compatible computer and adapter list --- }
  ClearScreen (LightGrayBG);
  QwriteC ( 4, 1,CRTcols,SameAttr,'QWIK Screen Utilities detects these');
  QwriteC ( 5, 1,CRTcols,SameAttr,'compatible computers and adapters:');
  delay   (wait*5);
  Col:=(CRTcols-30) shr 1;
  for Row:=7 to 20 do
    Qwrite (Row,Col,SameAttr,PC[Row-6]);
  QwriteC (23, 1,CRTcols,SameAttr,'Working text modes 0,1,2,3, or 7!');
  PromptKey;
end;

procedure ListDetection;
begin
  { --- Qinit detection --- }
  ClearScreen (LightGrayBG);
  QwriteC ( 4, 1,CRTcols,SameAttr,'To configure QWIK, Qinit not only');
  QwriteC ( 5, 1,CRTcols,SameAttr,'detects computers/adapters, it:');
  delay   (wait*5);
  Col:=(CRTcols-36) shr 1;
  for Row:=09 to 19 do
    Qwrite (Row,Col,SameAttr,Init[Row-8]);
  QwriteC (22,1,CrtCols,Blue+LightGrayBG+Blink,
           'Ideal for small, tight projects!');
  PromptKey;
end;

procedure UsingStr;
begin
  { --- Qwrite with Str on Reals Demo --- }
  ClearScreen (Yellow+BlackBG);
  QwriteC ( 2, 1,CRTcols,SameAttr,'Qwrite with the Strs unit will write');
  QwriteC ( 3, 1,CRTcols,SameAttr,'reals and integers faster:');
  Delay   (wait*7);
  Rnum:=1.23E+05;
  for col:=0 to CRTcols div 20 -1 do
  for row:=5 to 24 do
  begin
    Rnum:=Rnum+1;
    Qwrite (row,col*20+4,SameAttr,StrRF(Rnum,12));
  end;
  PromptKey;
end;

procedure Centering;
begin
  { --- Centering Demo --- }
  ClearScreen (LightGrayBG);
  QwriteC ( 2, 1,CRTcols,SameAttr,'QwriteC will automatically');
  QwriteC ( 3, 1,CRTcols,SameAttr,'center your data ...');
  QwriteC ( 4, 1,CRTcols,SameAttr,'(Odd breaks are shifted to the left.)');
  Delay   (wait*6);

  { - Set up columns for varying column modes - }
  ColL[2]:=1; ColR[2]:=CRTcols;
  if CRTcols<80 then
    begin
      ColL[1]:=ColL[2]; ColL[3]:=CRTcols div 2;
      ColR[1]:=ColR[2]; ColR[3]:=CRTcols div 2;
    end
  else
    begin
      ColL[1]:=3; ColR[1]:=26; ColL[3]:=CRTcols-14; ColR[3]:=CRTcols-14;
    end;

  QwriteC ( 7,ColL[1],ColR[1],SameAttr,'between margins ...');
  Qbox    ( 8,(ColL[1]+ColR[1]) shr 1 -12,15,26,white,LightGray,Border1);
  Delay   (wait*3);
  for row:=11 to 19 do
    QwriteC (row,ColL[1],ColR[1],SameAttr, Data[row-10]);
  Delay   (wait*5);

  QwriteC ( 7,ColL[2],ColR[2],SameAttr,'between two columns ...');
  QfillC  ( 9,ColL[2],ColR[2],13,24,Yellow,' ');     {  Clear window }
  for row:= 9 to 21 do
    QwriteC  (row,ColL[2],ColR[2],SameAttr,'><');     {  Show two columns  }
  Delay   (wait*3);
  for row:=11 to 19 do
    QwriteC (row,ColL[2],ColR[2],LightRed, Data[row-10]);
  Delay   (wait*5);

  QwriteC ( 7,ColL[3],ColR[3],SameAttr,'or on a center line ...');
  QfillC  ( 8,ColL[3],ColR[3],15,27,Black+LightGrayBG,' ');  {Clear window}
  for row:=09 to 21 do                 {  Show center line  }
    QwriteC  (row,ColL[3],ColR[3],Black+LightGrayBG,'|');
  Delay   (wait*3);
  for row:=11 to 19 do
    QwriteC (row,ColL[3],ColR[3],SameAttr, Data[row-10]);
  PromptKey;
end;

procedure Vertical;
begin
  { --- Vertical Writing Demo --- }
  ClearScreen (White+BlueBG);
  QwriteC ( 3, 1,CRTcols,SameAttr,'QwriteV and QwriteVC will');
  QwriteC ( 4, 1,CRTcols,SameAttr,'write vertically ...');
  Delay   (wait*6);

  { - Set up columns for varying column modes - }
  if CRTcols<80 then
    begin
      ColL[1]:=8;    ColR[1]:=33;
      ColL[2]:=9;    ColR[2]:=32;
      ColL[3]:=8;    ColR[3]:=33;
    end
  else
    begin
      ColL[1]:=2;    ColR[1]:=27;
      ColL[2]:=29;   ColR[2]:=52;
      ColL[3]:=54;   ColR[3]:=79;
    end;

  QwriteC ( 7,ColL[1],ColR[1],SameAttr,'Top justified ...');
  Qbox    ( 8,ColL[1],15,26,DarkGray+GreenBG,White+GreenBG,Border1);
  Delay   (wait*3);
  for col:=1 to 24 do
    QwriteV (9,col-1+ColL[1],SameAttr,Vert[col]);
  QwriteEosV (SameAttr,#254);
  Delay   (wait*5);

  QwriteC ( 7,ColL[2],ColR[2],SameAttr,'   centered ...   ');
  QfillC  ( 8,ColL[2],ColR[2],15,26,White+BlueBG,' ');
  QfillC  ( 9,ColL[2],ColR[2],13,24,LightGrayBG,' ');
  Delay   (wait*3);
  for col:=1 to 24 do
    QwriteVC ( 9,21,col-2+ColL[2],SameAttr,Vert[col]);
  QwriteEosV (SameAttr,#254);
  Delay   (wait*5);

  QwriteC ( 7,ColL[3],ColR[3],SameAttr,'or bottom justified ...');
  Qbox    ( 8,ColL[3],15,26,CyanBG,White+CyanBG,Border1);
  Delay   (wait*3);
  for col:=1 to 24 do
    QwriteV ( 22-length(Vert[col]),col-1+ColL[3],SameAttr,Vert[col]);
  PromptKey;
end;

procedure QwikFilling;
begin
  { --- Qfill Demo --- }
  ClearScreen (White+BlackBG);
  QwriteC ( 3, 1,CRTcols,SameAttr,'Qfill as well as Qattr can fill');
  QwriteC ( 4, 1,CRTcols,SameAttr,'your screen in several ways.');
  Delay   (wait*7);

  QwriteC ( 7, 1,CRTcols,SameAttr,'by rows ...');
  Delay   (wait*3);
  for row:= 9 to 24 do
    Qfill (row, 2, 1,CRTcols-2,9+row,Chr(row+56));
  Delay   (wait*5);

  Qfill   ( 7, 2,18,CRTcols-2,white,' ');       {  Clear Lines }
  QwriteC ( 7, 1,CRTcols,SameAttr,'by columns ...');
  Delay   (wait*3);
  for col:=2 to CRTcols-1 do
    Qfill ( 9,col,16,1,16+col,chr(col+63));
  Delay   (wait*5);

  Qfill   ( 7, 2,18,CRTcols-2,white,' ');       {  Clear Lines }
  QwriteC ( 7, 1,CRTcols,SameAttr,'or by row-by-column blocks ...');
  Delay   (wait*3);
    Qfill ( 9,2,16,CRTcols-2,Yellow+BlueBG,'!');
  Delay   (wait*5);
end;

procedure QboxDemo;
begin
  { --- Qbox demo --- }
  ClearScreen (LightGrayBG);
  QwriteC ( 2, 1,CRTcols,SameAttr,'Qbox is an application procedure made');
  QwriteC ( 3, 1,CRTcols,SameAttr,'from Qwrite and Qfill.  Together they');
  QwriteC ( 4, 1,CRTcols,SameAttr,'can make windows with borders easy.');
  Delay   (wait*9);
  QwriteC (14, 1,CRTcols,SameAttr,'How about 100 of them? ... ');
  Delay   (wait*4);
  ColMax:=CRTcols-21;
  for i:=1 to 100 do
    begin
      row:=random (10)+6;
      col:=random (ColMax)+2;
      if QVideoMode=Mono then
        begin
          BrdrAttr:=BWcolors[random(4)];
          WndwAttr:=BWcolors[random(4)];
        end
      else
        begin
          BrdrAttr:=random (128);
          WndwAttr:=random (128);
        end;
      Qbox (row,col,10,20,BrdrAttr,WndwAttr,Border2);
    end;
  Delay (wait*10);
end;

procedure PopUpDemo;
begin
  { --- Block Transfer and PopUp Demo --- }
  Qfill   ( 1, 1,25,CRTcols,yellow,'?');       {  Clear Screen }
  QfillC  (10, 1,CRTcols, 6,40,BrownBG,' ');   {  Clear Block }
  QwriteC (11, 1,CRTcols,SameAttr,'Qstore will save and restore');
  QwriteC (12, 1,CRTcols,SameAttr,'Row-by-Column blocks on your display.');
  QwriteC (13, 1,CRTcols,SameAttr,'It is so fast, I have to slow it down');
  QwriteC (14, 1,CRTcols,SameAttr,'so you can see it.');
    Delay (wait*11);
    BlkRow:=8;
    BlkCol:=CRTcols div 2 - 9;
  QstoreToMem(BlkRow,BlkCol,10,20,SavedBlock);
  { --- Make a Pop Up Menu --- }
  Qbox (BlkRow,BlkCol,10,20,Yellow+BlueBG,Brown+BlueBG,Border2);
  QwriteC (BlkRow+4,BlkCol,BlkCol+20,SameAttr,'Pop Up');
  QwriteC (BlkRow+5,BlkCol,BlkCol+20,SameAttr,'Menu');
  { --- End of Pop Up Menu --- }
  QstoreToMem (BlkRow,BlkCol,10,20,PopUpBlock);
    Delay (wait*4);
  ColMax:=CRTcols-20;
  for i:=1 to 30 do
    begin
      Delay (Wait div 2);
      QstoreToScr (BlkRow,BlkCol,10,20,SavedBlock);
      BlkRow:=random(15)+1;
      BlkCol:=random(ColMax)+1;
      QstoreToMem (BlkRow,BlkCol,10,20,SavedBlock);
      QstoreToScr (BlkRow,BlkCol,10,20,PopUpBlock);
    end;
end;

procedure PageDemo;
begin
  { --- Page Demo --- }
  if (MaxPage>0) and not InMultiTask then
    begin
      QviewPage  (1);
      QwritePage (1);
      TextAttr:= Yellow+BlueBG;
      QfillC  (20, 1,CRTcols, 3,35,TextAttr,' ');
      QwriteC (20, 1,CRTcols,SameAttr,' Remember this page?  ');
      QwriteC (21, 1,CRTcols,SameAttr,' It wasn''t lost, but saved using ');
      QwriteC (22, 1,CRTcols,SameAttr,' Qstores and placed on a new page. ');
      Delay (wait*14);
      QwritePage (0);
      QviewPage  (0);
    end;
end;

procedure EosMarker;
var Row: byte;
begin
  { -- EOS marker -- }
  ClearScreen (LightGreen+BlackBG);
  QwriteC ( 3, 1,CRTcols,White,'EOS Marker:');
  Col := EosC;
  QwriteEos (Blink+Yellow,#07);
  Qwrite  ( 4,Col,Yellow,#24' right here');
  QwriteC ( 7, 1,CRTcols,SameAttr,'The TP Write procedure locates your');
  QwriteC ( 8, 1,CRTcols,SameAttr,'next string by moving the cursor to');
  QwriteC ( 9, 1,CRTcols,SameAttr,'the End-Of-String (EOS).  Qwik does');
  QwriteC (10, 1,CRTcols,SameAttr,'the same thing, but without moving ');
  QwriteC (11, 1,CRTcols,SameAttr,'cursor!  It''s done with an offset  ');
  QwriteC (12, 1,CRTcols,SameAttr,'called QEosOfs.  It''s updated after');
  QwriteC (13, 1,CRTcols,SameAttr,'every Qwik procedure.              ');
  QwriteC (16, 1,CRTcols,SameAttr,'Now you can have the convenience of');
  QwriteC (17, 1,CRTcols,SameAttr,'a TP write but the speed of Qwik!  ');
  QwriteC (18, 1,CRTcols,SameAttr,'Check out these Q*Eos routines.    ');
  PromptKey;
end;

procedure QEosDemo;
begin
  { --- Q*Eos Utilities Demo --- }
  ClearScreen (Black+LightGrayBG);
  QwriteC ( 3, 1,CRTcols,SameAttr,'The Q*Eos procedures:');
  for Row:=5 to 9 do
    QwriteC (Row, 1,CRTcols,Yellow+BlackBG,Eoss[Row-4]);
  QwriteC (11, 1,CRTcols,SameAttr,'Take advantage of the EOS marker to');
  QwriteC (12, 1,CRTcols,SameAttr,'chain the next string - with an    ');
  QwriteC (13, 1,CRTcols,SameAttr,'optional change of attribute!      ');
  delay   (wait*5);
  Col := (CRTcols-34) shr 1;
  Qwrite (15,Col,Black+BrownBG,' Yellow ');
    for Count:=1 to 2 do
      begin
        delay     (wait);
        QwriteEos (White+BlueBG ,' Blue ');
        delay     (wait);
        QwriteEos (Black+BrownBG,' Yellow ');
      end;
  delay   (wait);
  QwriteC (17, 1,CRTcols,SameAttr,'Starts where the last Qwik');
  QwriteC (18, 1,CRTcols,SameAttr,'procedure left off!');
  QwriteC (19, 1,CRTcols,SameAttr,'Like TP Write ... but at Qwik speed!');
  delay   (wait*2);
  Qwrite (22,Col,Black+BrownBG,' Yellow ');
    for Count:=1 to 2 do
      begin
        QwriteEos (White+BlueBG ,' Blue ');
        QwriteEos (Black+BrownBG,' Yellow ');
      end;
  PromptKey;
end;

procedure UsingEos;
const
  Bright = Blue+LightGrayBG;
begin
  { -- Using Eos marker -- }
  ClearScreen (Black+LightGrayBG);
  Col:=succ((CRTcols-38) shr 1);
  QwriteC ( 2, 1,CRTcols,White,' Using the EOS marker: ');
  Qwrite ( 4,Col,Bright  ,'Now you have two marker utilities -');
  Qwrite ( 5,Col,Bright  ,'(1) EOS, and (2) the cursor.  Both can');
  Qwrite ( 6,Col,Bright  ,'be used interchangeably:');
  Qwrite ( 8,Col,SameAttr,'GotoEos   - cursor to End-Of-String');
  Qwrite ( 9,Col,SameAttr,'EosR      - End-Of-String row');
  Qwrite (10,Col,SameAttr,'EosC      - End-Of-String column');
  Qwrite (12,Col,Bright  ,'You can also manually alter EOS with');
  Qwrite (13,Col,Bright  ,'the following procedures:');
  Qwrite (15,Col,SameAttr,'EosToRC     - Sets EOS to a given row');
  Qwrite (16,Col,SameAttr,'              and column.');
  Qwrite (17,Col,SameAttr,'EosToRCrel  - Relatively shifts EOS by');
  Qwrite (18,Col,SameAttr,'              row and column.');
  Qwrite (19,Col,SameAttr,'EosToCursor - Matches Eos to the');
  Qwrite (20,Col,SameAttr,'              cursor position.');
  Qwrite (21,Col,SameAttr,'EosLn       - Sets EOS to next row');
  Qwrite (22,Col,SameAttr,'QEosLn      - Like EosLn, but scrolls');
  Qwrite (23,Col,SameAttr,'              up if on last row.');
  PromptKey;
end;

procedure MoreUtilities;
const
  Bright = Blue+LightGrayBG;
begin
  { --- Other Screen Utilities Demo --- }
  ClearScreen (Black+LightGrayBG);
  QwriteC ( 3, 1,CRTcols,Bright,'Here are more powerful');
  QwriteC ( 4, 1,CRTcols,Bright,'QWIK Screen Utilities');
  QwriteC ( 5, 1,CRTcols,Bright,'(for standard and virtual):');
  delay   (wait*5);
  Col:=(CRTcols-36) shr 1;
  for Row:=8 to 19 do
    Qwrite (Row,Col,SameAttr,Other[Row-7]);
  PromptKey;
end;

procedure CursorUtilities;
const
  Bright = White+BrownBG;
begin
  { --- Cursor Utilities Demo --- }
  ClearScreen (Black+BrownBG);
  QwriteC ( 2, 1,CRTcols,Bright,'And of course there are complete set');
  QwriteC ( 3, 1,CRTcols,Bright,'of CURSOR location and mode routines');
  QwriteC ( 4, 1,CRTcols,Bright,'for all video pages and video cards.');
  delay   (wait*5);
  Col:=(CRTcols-36) shr 1;
  for Row:= 6 to 11 do
    Qwrite (Row,Col,SameAttr,Crsr[Row-5]);
  QwriteC (13, 1,CRTcols,Bright,'For universal cursor sizes, four');
  QwriteC (14, 1,CRTcols,Bright,'standard shapes are initialized ');
  QwriteC (15, 1,CRTcols,Bright,'by detecting each video card:   ');
  for Row:=17 to 20 do
    Qwrite (Row,Col,SameAttr,Crsr[Row-10]);
  for Row:=22 to 23 do
    QwriteC (Row,1,CRTcols,Bright,Crsr[Row-11]);
  PromptKey;
end;

procedure AttrDemo;
begin
  { --- Attribute Demo --- }
  ClearScreen (Black+GreenBG);
  TextAttr:= White+GreenBG;
  QwriteC ( 2, 1,CRTcols,TextAttr,'QWIK Screen Utilities are hiding data');
  QwriteC ( 3, 1,CRTcols,TextAttr,'on your screen ...');
  Cols:=CRTcols div 20;
  if QVideoMode=Mono then
       TextAttr:=Black+BlackBG
  else TextAttr:=Green+GreenBG;
  for col:=0 to Cols-1 do
    for row:=5 to 20 do
      Qwrite (row,(20*col)+2,TextAttr,Strng);
  Delay (wait*8);

  Qfill   ( 2, 2, 2,CRTcols-2,SameAttr,' ');        {  Clear Lines }
  TextAttr:= White+GreenBG;
  QwriteC ( 2, 1,CRTcols,TextAttr,'Qattr can show them -');
  QwriteC ( 3, 1,CRTcols,TextAttr,'by merely changing the attribute!');
  Delay   (wait*6);

  { --- Try using Turbo's color procedures this time --- }
  TextColor (Black); TextBackground (Green);
  Qattr   ( 5, 2,16,CRTcols-2,TextAttr);         {  Reveal Data }
  Delay   (wait*5);

  Qfill   ( 2, 2, 2,CRTcols-2,SameAttr,' ');        {  Clear Lines }
  TextColor (yellow); TextBackground (Green);
  QwriteC ( 3, 1,CRTcols,TextAttr,'Or even just emphasize what''s seen ...');
  for i:=1 to 500 do
    begin
      Row:= random(16) + 5;
      Col:= random(Cols)*20+2;
      Qattr (Row,Col, 1,18,Yellow+GreenBG);
      Delay (3);
      Qattr (Row,Col, 1,18,GreenBG);
    end;
  for i:=1 to Cols do     {  Emphasize Data }
    Qattr ( 5*i,(i-1)*20+2, 1,18,Yellow+GreenBG+Blink);
  Qattr   (21, 2, 4,CRTcols-2,TextAttr);
  QwriteC (22, 1,CRTcols,TextAttr,'Copyright (c) 1986,1993 James H. LeMay');
end;

begin
  InitDemo;
  ExplodeScreen;
  SaveScreen;
  ListCompatibles;
  ListDetection;
  UsingStr;
  Centering;
  Vertical;
  QwikFilling;
  QboxDemo;
  PopUpDemo;
  PageDemo;
  EosMarker;
  QEosDemo;
  UsingEos;
  MoreUtilities;
  CursorUtilities;
  AttrDemo;
  CloseDemo;
end.
