{ ========================================================================== }
{ P70-var.inc - Variables for multi-level pull-down menus Ver 7.0b, 09-24-93 }
{                                                                            }
{ This file contains all the variables needed for PULL70B.TPU.  You cannot   }
{ change this file unless you have the complete PULL70B.PAS source code.     }
{   Copyright (c) 1988,1993 James H. LeMay, All rights reserved.             }
{ ========================================================================== }

{ ================== Data Structure Configuration Constants ================ }
const
  NumOfMainMenus   =   8;    { 1 - 255 }
  NumOfSubMenus    =   5;    { 1 - 255 }
  MaxMenuLines     =  15;    { For Main and Sub menus }
  MaxCharsPerLine  =  21;    { For Main and Sub menus, and Data Window titles}
                             { Be sure to allow for the '~' character. }

  NumOfDataWndws   =  16;    { 1 - 255 }
  NumOfDataEntries =  10;    { 1 - 255 }
  DataStrSize      = 100;    { Max chars in data entry string }

  NumOfHelpWndws   =  14;    { 1 - 255 }
  TotalHelpLines   =  89;    { 1 - 65535 }
  HelpCharsPerLine =  50;    { 1 - Screen limit }

  NumOfMsgLines    =  11;    { 1 - 255 }
  CrtStrSize       =  80;    { Screen limit for sizing strings }
  NumOfErrMsgLines =   7;    { 1 - 65535 }
  ErrStrSize       =  60;    { Error messages are usually short }
  MsgStrSize       =  CrtStrSize+16; { Screen width plus '~' characters }

{ ========================= Declarations for Menus ========================= }
type
  MenuModeType   = (ExecChoice, SingleChoice, MultipleChoice);
  LineModeType   = (Choice, ExecOnly, NoChoice, Comment, Partition,
                    ToDataWndw, ToSubMenu, ToUserWndw);
  Toggle         = (Off, On, No, Yes);
  CrtStrType     = string[CrtStrSize];
  MsgStrType     = string[MsgStrSize];
  SeqStrType     = string[MaxWndw];
  MenuRec =
    record
      Title:       string[MaxCharsPerLine];
      CmdLtrs:     string[MaxMenuLines];
      Line:        array[1..MaxMenuLines] of string[MaxCharsPerLine];
      LineMode:    array[1..MaxMenuLines] of LineModeType;
      Flagged:     array[1..MaxMenuLines] of boolean;
      LinkNum:     array[1..MaxMenuLines] of byte;
      ProcPtr:     array[1..MaxMenuLines] of procedure;
      ParentDir,
      LinkDir:     DirType;
      MenuMode:    MenuModeType;
      MenuLines:   byte;
      NameCol:     byte;
      NameLen:     byte;
      CmdCol:      byte;
      Row, Col, Rows, Cols:                    byte;
      DefaultLine, HiLiteLine, SingleFlagLine: byte;
      Battr, Wattr, Hattr, Lattr, Cattr:       byte;
      Border:                                  Borders;
      BackToDefault, Changed:                  boolean;
      MsgLineNum, HelpWndwNum:                 byte;
    end;
  MenuRecs = array[1..NumOfMainMenus] of MenuRec;

var
  MainMenu:        ^MenuRecs;
  TopMenu:         MenuRec;
  MRI:             word;        { Top menu record index }
  LastMainMenu:    byte;        { <= NumOfMainMenus }
  TopLineStr:      CrtStrType;
  TopLineRow,
  MainMenuRow,

  InitAttr,
  TopLineAttr,
  TopLineHattr,
  TopLineLattr,
  MainMenuWattr,
  MainMenuBattr,
  MainMenuHattr,
  MainMenuLattr,
  MainMenuCattr:   byte;
  MainMenuBrdr:    Borders;

  Key:             char;
  ExtKey:          boolean;

  { -- Control Flags to Pull/Pop the menus. -- }
  PullDown,
  Pop,
  PopToWorkWndw,
  PopToTop,
  PopAndProcess:   boolean;
  PopLevels:       byte;

  { -- Variables to indicate location of menus and windows. -- }
  DefaultLinkDir:  DirType;     { Submenus are linked as slide-up
                                  or slide-under by default }
  TopCmdLtrs:      string[NumOfMainMenus];
  CmdSeq,
  MoreCmdSeq:      SeqStrType;  { Sequence of keys pressed. }
  MPulled,
  SPulled,
  HiLited:         byte;
  AccessedWorkWndw,
  AccessedMenus:   boolean;
  WorkWndwStep:    word;
  TopWorkWndwName: WindowNames;

  { -- These are addresses for indirect procedure calls out of PULL.TPU -- }
  CallGetUserPullStats,
  CallGetOverrideStats,
  CallCheckGlobalKeys,
  CallWorkWndw,
  CallKbdIdle:     procedure;

const
  InWorkWndw:      boolean = true;
  Quit:            boolean = false;
  WaitForKbd:      boolean = true;

  { -- Function keys -- }
  HelpKey = #59;    { F1 }
  PopKey  = #60;    { F2 }
  TopKey1 = #68;    { F10 }  { Extended function key }

  { -- Data Entry keys -- }
  NullKey  = #00;
  RetKey   = #13;   { ^M }
  BSKey    = #08;
  EscKey   = #27;   { ^[ }
  HomeKey  = #71;
  UpArrKey = #72;
  PgUpKey  = #73;
  LArrKey  = #75;
  RArrKey  = #77;
  EndKey   = #79;
  DnArrKey = #80;
  PgDnKey  = #81;
  InsKey   = #82;
  DelKey   = #83;
  CtrlLArrKey = #115;
  CtrlRArrKey = #116;
  CtrlEndKey  = #117;
  CtrlPgDnKey = #118;
  CtrlHomeKey = #119;
  CtrlPgUpKey = #132;
  TabKey      = #9;
  ShiftTabKey = #15;

{ ========================= SubMenu Declarations =========================== }
{$ifdef UseSubMenuCode }
type
  SubMenus = array[1..NumOfSubMenus]  of MenuRec;

var
  SubMenu:         ^SubMenus;
  LastSubMenu:     byte;        { <= NumOfSubMenus }
  SubMenuWattr,
  SubMenuBattr,
  SubMenuHattr,
  SubMenuLattr,
  SubMenuCattr:    byte;
  SubMenuBrdr:     Borders;
  LocationWarning: boolean;
{$endif }

{ ====================== Message Line Declarations ========================= }
{$ifdef UseMsgLineCode }
type
  ErrMsgStrType = string[ErrStrSize];

const
  CurrentMsgLineNum: word    = 0;   { Index of the message currently shown. }
  EnableKeyStatus:   boolean = true;

var
  MsgLine:         array[1..NumOfMsgLines]    of MsgStrType;
  ErrMsgLine:      array[1..NumOfErrMsgLines] of ErrMsgStrType;
  MsgLineRow,
  CapsLockCol,
  ErrMsgAttr,
  KeyStatusAttr,
  MsgLineHattr,
  MsgLineAttr:     byte;
{$endif }

{ ======================== Help Window Declarations ======================== }
{$ifdef UseHelpWndwCode }
type
  HelpWndwRec =
    record
      FirstLine, LastLine:      byte;
      LinesToShow:              byte;
      Row, Col, Rows, Cols:     byte;
      Battr, Wattr:             byte;
      Border:                   Borders;
      HWmodes:                  byte;
      MsgLineNum:               byte
    end;

var
  HelpWndw:        array[1..NumOfHelpWndws] of HelpWndwRec;
  HelpLine:        array[1..TotalHelpLines] of string[HelpCharsPerLine];
  HelpBottomRow,
  HelpWndwModes,
  HelpMsgLineNum,
  HelpWndwWattr,
  HelpWndwBattr:   byte;
  HelpWndwBrdr:    Borders;
{$endif }


{ ======================== Data Windows and Data Entry ===================== }
{$ifdef UseDataEntryCode }
type
  TypeOfDataType = (
    Bytes,Words,ShortInts,Integers,LongInts,Reals,UserNums,Chars,Strings);
  SetNames = (
    NoSet,UnsignedSet,SignedSet,RealSet,CharSet,HexSet,FileNameSet,PathSet,
    MaskSet);
  EntrySetArray  = array[UnsignedSet..MaskSet] of set of char;
  DataEntryRec =
    record
      VarAddr:                  pointer;
      TypeOfData:               TypeOfDataType;
      Row,Col,Field,MaxField:   byte;
      Decimals:                 shortint;
      SetName:                  SetNames;
      TranslateProc,
      CheckRangeProc:           procedure;
      JustifyOutput:            DirType;
      Oattr, Iattr,
      MsgLineNum, HelpWndwNum:  byte;
    end;
  DataWndwRec =
    record
      Title:  string[MaxCharsPerLine];
      DWrow,DWcol: byte;
      Battr:  byte;
      Border: Borders;
      Entry:  DataEntryRec;
    end;
  DataWndws   = array[1..NumOfDataWndws]   of DataWndwRec;
  DataEntries = array[1..NumOfDataEntries] of DataEntryRec;
  DataStrType = string[DataStrSize];
  DataPadRec =
    record
      StoreMode,Valid,DataStored,NewData,PullDW: boolean;
      FieldIndex,CursorOfs,Hattr: integer;
      ErrMsg:  word;
      Flex:    byte;
      Justify: DirType;
      case TypeOfDataType of
        Bytes:        (Bdata:  byte);
        Words:        (Wdata:  word);
        ShortInts:    (SIdata: shortint);
        Integers:     (Idata:  integer);
        LongInts:     (Ldata:  longint);
        Reals:        (Rdata:  real);
        UserNums:     (UNdata: DataStrType);
        Chars:        (Cdata:  char);
        Strings:      (Sdata:  DataStrType);
    end;

const
  { -- Filter sets for valid data entry characters -- }
  EntrySet:  EntrySetArray = (
   { -- Reserved sets -- }
   { UnsignedSet: } ['0'..'9'],
   { SignedSet:   } ['0'..'9','-','+'],
   { RealSet:     } ['0'..'9','-','+','.','E','e'],
   { CharSet:     } [' '..'~'],
   { -- User customized sets -- }
   { HexSet:      } ['0'..'9','A'..'F','a'..'f'],
   { FileNameSet: }
     ['!','#'..')','-'..'.','0'..'9','@'..'Z','^'..'{','}'..'~'],
   { PathSet:     }
     ['!','#'..')','-'..'.','0'..':','@'..'Z','^'..'{','}'..'~','\'],
   { MaskSet:     }
     ['!','#'..'*','-'..'.','0'..':','?'..'Z','^'..'{','}'..'~','\']);

var
  DWI:             word;        { Top data window record index }
  DEI:             word;        { Top data entry record index }
  TopDataWndw:     DataWndwRec;
  TopEntry:        DataEntryRec;
  DataWndw:        ^DataWndws;
  DataEntry:       ^DataEntries;
  DataStr:         DataStrType;
  DataStrL:        byte absolute DataStr;  { length of DataStr }
  DataPad:         DataPadRec;
  AutoTab,
  AutoNumLock:     boolean;

{$endif UseDataEntryCode }
