UNIT NW311;

{ A unit to capture a printer with NW311, without using port's.

  Autor : Michael Fiel

  Use it if you like it, but usage at your own risk.
  please read nw311.txt.

}

INTERFACE
  USES
    WinDos,Objects;

  TYPE

    PNWPrintQueue = ^TNWPrintQueue;
    TNWPrintQueue = object(TObject)

      Name        : String; { The name of the Queue }
      ObjType     : Word;   { The objecttype of the Queue }

      constructor Init(aName:String);
      { initialize this object with the name of the queue }

      function    Capture(ServiceName,AddInfo:String;Copys:Integer):Boolean; virtual;
      { <ServiceName> and <AddInfo> can be any strings, wich can be seen
        in the RCONSOLE-Current Queue Job List. <Copys> are the amount
        of copies you want to print;Opens the DOS file "NETQ" }

      function    EndCap : Boolean; virtual;
      { Close the Queue, and the File "NETQ"}

      procedure   Flush(Buffer : String); virtual;
      { Print to the Queue }
      procedure   FlushLn(Buffer : String); virtual;
      { Print with chr(13) }

      PRIVATE

      Regs        : TRegisters;
      JobNr       : Array[0..1] of word;
      { the number of the current job }
      ID          : Array[0..3]  of char;
      { Job ID returned by netware }
      theQueue    : TEXT;
      { The textfile 'NETQ' }

      ReqBuf      : Array [0..262] of char;
      { The Request Buffer to Netware }
      RepBuf      : Array[0..262] of char;
      { The Return Buffer for Netware }

      function    GetBinderyObjectID : Boolean;
      { Get ID of the Queue }
      function    GetError(W:Word)   : String;
      { Filter any ErrorCode returned by Netware }
      function    ProceedAPICall     : Boolean; virtual;
      { The Interrupt call To Netware -> Directrives for DPMI and REAL mode }

    end;

IMPLEMENTATION

  USES
    {$IFDEF DPMI}
    EzDpmi,        { EZDPMI is Copyright (c) 1993 by  Julian M. Bucknall }
    {$ENDIF}
    NWTools;

  constructor TNWPrintQueue.Init(aName:String);
    { Initialize the object and get ID of the Queue.
      If you have more than 1 Server add a "SetPreferredConnectionID" call }
    begin
      if aName<>'' then begin
        if not inherited Init then FAIL;
        Name:=Trim(aName);                              { unit nwtools.pas }
        if not(GetBinderyObjectID) then FAIL;
      end else
        FAIL;
    end;

  function TNWPrintQueue.ProceedAPICall : Boolean;
    { performs the call to netware. Directrives for REAL and PROTECTED Mode.

      RAELMODE      : Perform MSDOS Call
      PROTECTEDMODE : Request and Reply Buffers are copied to Memory
                      allocated in memory below 1MB.
                      Perform Interrupt call.
                      Copy Requestbuffer from realmode to protectetmode
                      memory. Free realmode buffers.
    }

    {$IFDEF DPMI}
    var
      RReqBuf               : Pointer;
      RReqBufSeg,RReqBufOfs,
      ReqLen                : Word;
      { pointer to Request Buffer in realmode memory,
        Segment and Offset of RReqBuf,
        Length of the RReqBuf}

      RRepBuf               : Pointer;
      RRepBufSeg,RRepBufOfs,
      RepLen                : Word;
      { pointer to Reply Buffer in realmode memory,
        Segment and Offset of RRepBuf,
        Length of the RRepBuf}

    {$ENDIF}
    begin

      {$IFDEF DPMI}

      move16(ReqBuf,ReqLen,SizeOf(ReqLen));   { unit nwtools.pas }
      inc(ReqLen,2);
      move16(RepBuf,RepLen,SizeOf(RepLen));
      inc(RepLen,2);

      RReqBuf:=SIToReal(Regs.DS,Regs.SI,ReqBuf,ReqLen); { unit nwtools }
      RRepBuf:=SIToReal(Regs.ES,Regs.DI,RepBuf,RepLen); { unit nwtools }
      Regs.AH:=$E3;

      RealIntr($21,Regs); { unit EZDPMI }

      SIToProt(RepBuf,RRepBuf,RepLen);  { unit nwtools }
      SIFree(RReqBuf);                  { unit nwtools }

      {$ELSE}

      with regs do begin
        AH:=$E3;
        DS:=Seg(ReqBuf);
        SI:=Ofs(ReqBuf);
        ES:=Seg(RepBuf);
        DI:=Ofs(RepBuf);
      end;

      MsDos(Regs);

      {$ENDIF}

      if (Regs.AL>0) then OwnError(GetError(Regs.Al)); {OwnError:unit nwtools}
      ProceedAPICall:=(Regs.Al=0);

    end;


  function TNWPrintQueue.Capture(ServiceName,AddInfo:String;Copys:Integer) : Boolean;
    { <ServiceName> and <AddInfo> can be any strings, wich can be seen
      in the RCONSOLE-Current Queue Job List. <Copys> are the amount
      of copies you want to print }
    var
      S       : String;
      len     : Word;
      i       : Integer;
    begin

      Capture:=False;

      FillChar(ReqBuf,SizeOf(ReqBuf),0);
      FillChar(RepBuf,SizeOf(RepBuf),0);

      len:=261;
      ReqBuf[0]:=char(Lo(Len));
      ReqBuf[1]:=char(Hi(Len));
      ReqBuf[2]:=char($68); { Sytem Call $E3 $68 "Create Queue Job and File" }

      Move(ID,ReqBuf[3],SizeOf(ID));

      S:=mkstr(6,0);
      move(S[1],ReqBuf[7],6);
      S:=mkStr(10,$FF);
      move(s[1],ReqBuf[13],10);
      S:=mkStr(11,0);
      move(s[1],ReqBuf[23],11);
      ReqBuf[34]:=char($08+$10);
      S:=mkStr(26,0);
      move(s[1],ReqBuf[35],26);

      ServiceName:=LenStr(ServiceName,49);
      Servicename:=Servicename+#0;
      move(ServiceName[1],ReqBuf[61],50);

      { The following part is called the Client record Area. I just
        watched the buffer which was sent to the Printserver. This part
        of the buffer can be of any structure, but it must be understood
        by the QueueServer (in my case the PSERVER.NLM). I don't know
        the exact meaning of all char's in this part, I just tried,
        until it works. This part may be differnet in future versions of
        PSERVER.NLM. It's not documented in the Netware System Calls manual,
        at may not work with other Printservers than the PSERVER.NLM }

      S:=mkstr(3,0);
      move(s[1],ReqBuf[111],3);
      ReqBuf[114]:=char(Copys);  { nuber of copies }

      ReqBuf[115]:=char(0);

      ReqBuf[116]:=char(8);
      { bits : 4.. FormFeed no
               8.. FormFeed yes
              16.. Notify when down
      }

      ReqBuf[117]:=char(0);
      ReqBuf[118]:=char(66);
      ReqBuf[119]:=char(0);
      ReqBuf[120]:=char(132);

      S:='UNKNOWN'+mkstr(15,0)+LenStr(AddInfo,11)+mkstr(120,0);
      move(S[1],ReqBuf[121],(length(S)-1));

      { End of Client record Area }

      len:=56;
      move(len,RepBuf,2);

      if (ProceedAPICall) then begin

        move(RepBuf[24],JobNr,SizeOf(JobNr));  { Get nunber of this job }

        { A dos file called NETQ is generated after the API call (I think
        by netx) . Just open this File and write to it. Rewrite and Reset
        didn't work properly. Just append works correct. Anyone guess why ?
        }

        assign(theQueue,'NETQ');
        append(theQueue);
        i:=IOResult;

        if (i<>0) then
          Ownerror('Error initialisizing NETQ')
        else
          Capture := True;

      end;

    end;

  function TNWPrintQueue.EndCap : Boolean;
    { Close the Queue and the DOS file "NETQ" }
    var
      w : word;
    begin

      Close(theQueue);

      FillChar(ReqBuf,SizeOf(ReqBuf),0);
      FillChar(RepBuf,SizeOf(RepBuf),0);

      w:=7;
      move(w,ReqBuf,2);
      ReqBuf[2]:=char($69);{System call $E3 $69 "Close File and Start Queue Job"}

      Move(ID,ReqBuf[3],SizeOf(ID));
      move(JobNr,ReqBuf[7],SizeOf(JobNr));

      EndCap:=ProceedAPICall;

    end;

  function TNWPrintQueue.GetBinderyObjectID : Boolean;
    { Get ID of the Queue }
    var
      S      : String;
      len    : word;
      l      : longint;

    begin

      GetBinderyObjectID:=False;

      FillChar16(ReqBuf,SizeOf(ReqBuf),0);
      FillChar16(RepBuf,SizeOf(RepBuf),0);
      len:=4+length(Name);

      ReqBuf[0]:=char(Lo(len));
      ReqBuf[1]:=char(Hi(len));
      ReqBuf[2]:=char($35);

      ReqBuf[3]:=char($0);
      ReqBuf[4]:=char($3);

      len:=length(Name);
      move(Name,ReqBuf[5],len+1);

      RepBuf[0]:=char(59);

      if (ProceedAPICall) then begin

        Move(RepBuf[2],ID,SizeOf(ID));

        move(RepBuf[6],ObjType,2);
        ObjType:=Swap(ObjType);

        move(RepBuf[8],Name[1],48);
        Name[0]:=#48;
        Name[0]:=char(Pos(#0,Name)-1);

        GetBinderyObjectID := True;

      end;

    end;

  procedure TNWPrintQueue.Flush(Buffer:String);
    { write to the queue }
    begin
      Write(theQueue,Buffer);
    end;

  procedure TNWPrintQueue.FlushLn(Buffer:String);
    { writeln to the queue }
    begin
      WriteLn(theQueue,Buffer);
    end;

  function TNWPrintQueue.GetError(w:Word) : String;
    { get the errormessage returned by netware }
    var
      S:String;
    begin
      case w of
        $96:S:='Server out of memory ('+Name+')';
        $99:S:='Directory full ('+Name+')';
        $9C:S:='Invalid Path ('+Name+')';
        $D0:S:='Q Error ('+Name+')';
        $D1:S:='No Queue ('+Name+')';
        $D2:S:='No Queue Server ('+Name+')';
        $D3:S:='No Queue Rights ('+Name+')';
        $D4:S:='Queue Full ('+Name+')';
        $D5:S:='No Q Job ('+Name+')';
        $D6:S:='No Job Rights ('+Name+')';
        $DA:S:='Queue Halted ('+Name+')';
        $ED:S:='Property already exists ('+Name+')';
        $EF:S:='Invalid name ('+Name+')';
        $F0:S:='Wildcard not allowed ('+Name+')';
        $F1:S:='Invalid Bindery Security ('+Name+')';
        $F7:S:='No Property Create Privilege ('+Name+')';
        $FC:S:='No such object ('+Name+')';
        $FE:S:='Server Bindery Locked ('+Name+')';
        $FF:S:='Bindery Failure ('+Name+')';
        else S:='Bindery error ('+Name+')';
      end;
      GetError:=S;
    end;

END.

