{$X+,V-}
uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  Btv, BtvType, BtvConst, BtvX;

type
  ErrorType = Object(BTV.ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;

  RecBuf = record
    LastName  : String[15];   {0}
    FirstName : String[15];   {16}
    Date      : BDateRec;     {32}
  end;

  ReadBuffType = record
    Len       : Word;
    Pos       : LongInt;
    LastName  : String[15];
    FirstName : String[15];
    Date      : BDateRec;
  end;

  WriteBuffType = record
    Len       : Word;
    LastName  : String[15];
    FirstName : String[15];
    Date      : BDateRec;
  end;


Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erDone;  { just let the program continue }
    ClrScr;
  end;


Procedure Trim(var S : String);

  var
    i : Byte;

  begin
    while (Byte(S[0]) > 0) and (S[Byte(S[0])] = ' ') do
      Dec(Byte(S[0]));

    i := 1;

    while (i <= Byte(S[0])) and (S[i] = ' ') do
      Inc(i);

    if (i > 1) then
    begin
      Byte(S[0]) := Byte(S[0]) - i + 1;
      Move(S[i], S[1], Byte(S[0]));
    end;
  end;


var
  F         : Text;
  ErrHandler: ErrorHandler;
  ErrDisplay: ErrorType;
  B         : XBtrieveFile;

  Buff      : ReadBuffType;
  ReadBuff  : record
    Count : Word;
    Data  : Array[1..10] of ReadBuffType;
  end;

  WriteBuff : record
    Count : Word;
    Data  : Array[1..60] of WriteBuffType;
  end;

  S         : String;
  dTemp     : BDateRec;
  Offset    : Word;

  i         : Byte;
  x         : Word;
  Err       : Integer;
  Name      : String[30];

begin
  ErrDisplay.Init;
  ErrHandler.Init(@ErrDisplay);

  { set up the demo file }
  B.Init('EXTEND.DAT', @ErrHandler, nil, SizeOf(RecBuf));
  B.AddKeySegment( 1, 16, bExtended + bDuplicates, bLString, 0, 0);
  B.AddKeySegment(17, 16, bExtended + bDuplicates, bLString, 0, 0);
  B.AddKeySegment(33,  4, bExtended + bDuplicates, bDate, 0, 0);
  B.Create(bNormal, SizeOf(RecBuf), 1024, 0, bNormal);
  B.Open(bNormal, '');


  (* INSERT MULTIPLE RECORDS USING INSERT EXTENDED *)
  Assign(F, 'XDEMO.TXT');
  Reset(F);
  x := 0;
  FillChar(WriteBuff, SizeOf(WriteBuff), 0);

  While (not EOF(F)) do
  begin
    Inc(x);
    Readln(F, S);
    i := 1;
    Name := '';

    While (S[i] <> ',') do
    begin
      Name[i] := S[i];
      Inc(i);
    end;

    Name[0] := Char(i-1);
    Trim(Name);
    Writeln(Name);

    WriteBuff.Data[x].Len := SizeOf(WriteBuff.Data[1]) - 2;
    WriteBuff.Data[x].FirstName := Copy(Name, 1, Pos(' ', Name) - 1);
    WriteBuff.Data[x].LastName  := Copy(Name, Pos(' ', Name) + 1, Length(Name));
    Inc(i, 2);
    Val(Copy(S, i, 4),   WriteBuff.Data[x].Date.Year, Err);
    Val(Copy(S, i+4, 2), WriteBuff.Data[x].Date.Month, Err);
    Val(Copy(S, i+6, 2), WriteBuff.Data[x].Date.Day, Err);
  end;

  Close(F);

  writeln('USING EXTENDED INSERT TO ADD ', x, ' RECORDS ... PLEASE WAIT');

  WriteBuff.Count := x;
  B.XInit(@WriteBuff, SizeOf(WriteBuff));
  x := B.XInsert;

  writeln(x, ' RECORDS WERE ADDED!');
  writeln;
  writeln('Press any key ....');
  writeln;
  ReadKey;


  (* READ A SINGLE RECORD *)
  B.XInit(@ReadBuff, SizeOf(ReadBuff));
  { number of records to reject }
  B.SetRejectCount(100);
  { number of records to read }
  B.SetExtractCount(1);
  { field size and offset (this reads the whole record) }
  B.AddFieldToExtract(SizeOf(Buff), 0);
  { add a single filtering condition }
  S := 'C';
  B.AddFilterCondition(bLstring,
                       16, 0,
                       bXGetGreat OR bXNoCaseCompare,
                       bXDone,
                       S);

  { need to read a record first, to establish positioning }
  B.Get(bGetFirst, bNoLock);
  B.XGet(bXGetNext);

  { get all the fields returned by Btrieve for the record }
  if B.ExtractNextRec(Buff, False) then
    writeln(Buff.FirstName, ' ', Buff.LastName, '  ',
            Buff.Date.Month, '/', Buff.Date.Day, '/', Buff.Date.Year);

  writeln;


  (* READ MULTIPLE RECORDS *)
  B.SetExtractCount(4);
  B.Get(bGetFirst, bNoLock);
  B.XGet(bXGetNext);

  While B.ExtractNextRec(Buff, False) do
    writeln(Buff.FirstName, ' ', Buff.LastName, '  ',
            Buff.Date.Month, '/', Buff.Date.Day, '/', Buff.Date.Year);

  writeln;
  writeln('Press any key ....');
  writeln;
  ReadKey;


  (* READ MULTIPLE RECORDS USING FIELD COMPARE *)
  B.XReset;
  B.SetRejectCount(100);
  B.SetExtractCount(10);
  B.AddFieldToExtract(SizeOf(Buff), 0);
  { compare last name to first name }
  Offset := 16;
  B.AddFilterCondition(bLstring,
                       16, 0,
                       bXGetEqual OR bXFieldCompare,
                       bXDone,
                       Offset);

  B.Get(bGetFirst, bNoLock);
  B.XGet(bXGetNext);

  While B.ExtractNextRec(Buff, False) do
    writeln(Buff.FirstName, ' ', Buff.LastName, '  ',
            Buff.Date.Month, '/', Buff.Date.Day, '/', Buff.Date.Year);

  writeln;
  writeln('Press any key ....');
  writeln;
  ReadKey;


  (* READ MULTIPLE RECORDS EXTRACTING ONE FIELD ONLY *)
  B.XReset;
  B.SetRejectCount(100);
  B.SetExtractCount(15);
  { extract the date field only }
  B.AddFieldToExtract(SizeOf(BDateRec), 32);

  dTemp.Day   := 13;
  dTemp.Month := 5;
  dTemp.Year  := 1952;
  B.AddFilterCondition(bDate,
                       SizeOf(BDateRec), 32,
                       bXGetGreatEqual,
                       bXLogicAND,
                       dTemp);

  dTemp.Day   := 1;
  dTemp.Month := 1;
  dTemp.Year  := 1960;
  B.AddFilterCondition(bDate,
                       SizeOf(BDateRec), 32,
                       bXGetLessEqual,
                       bXLogicOR,
                       dTemp);

  dTemp.Day   := 1;
  dTemp.Month := 1;
  dTemp.Year  := 1980;
  B.AddFilterCondition(bDate,
                       SizeOf(BDateRec), 32,
                       bXGetGreat,
                       bXDone,
                       dTemp);

  B.Get(bGetLast, bNoLock);
  B.XGet(bXGetPrev);

  { get the data fields only }
  While B.ExtractNextRec(dTemp, True) do
    writeln(dTemp.Month, '/', dTemp.Day, '/', dTemp.Year);

  writeln;


  { Change the key path (to filter path) and records are returned in a
   different order. This also returns one less record. The last record in
   the path meets the criteria, but is skipped over now.
  }
  B.SetKeyPath(2);
  B.Get(bGetLast, bNoLock);
  B.XGet(bXGetPrev);

  While B.ExtractNextRec(dTemp, True) do
    writeln(dTemp.Month, '/', dTemp.Day, '/', dTemp.Year);

  writeln;
  writeln('Press any key ....');
  writeln;
  ReadKey;


  (* READ MULTIPLE RECORDS USE STEP NEXT EXTENDED *)
  { This returns one less record. The physical first record inserted into
    the file meets the criteria, but is skipped over.
  }
  B.Get(bStepFirst, bNoLock);
  B.XGet(bXStepNext);

  While B.ExtractNextRec(dTemp, True) do
    writeln(dTemp.Month, '/', dTemp.Day, '/', dTemp.Year);

  writeln;

  { cleanup and free memory }
  B.XDone;


  B.Close;
end.

