{$X+}
{$V-}
{ EXAMPLE7.PAS - demonstrates file clone, copy, recover, save, load

                 YOU MUST COMPILE AND RUN EXTEND.PAS FIRST!!!

  Requires Turbo Pascal version 6.0, 7.0
}

Uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvType,
  BtvConst,
  Btv;


type
  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;

  ProgressType = Object(TProgress)
    Constructor Init(Title : String);
    Procedure   Display(Count : LongInt);         Virtual;
  end;


var
  Progress    : ProgressType;
  ErrHandler  : DiskErrorHandler;
  ErrDisplay  : ErrorType;
  Fin         : BtrieveFile;
  Fout        : BtrieveFile;
  InBuff      : record
                  LastName  : String[15];   {0}
                  FirstName : String[15];   {16}
                  Date      : BDateRec;     {32}
                end;
  OutBuff     : record
                  LastName  : String[15];   {0}
                  FirstName : String[15];   {16}
                  Date      : BDateRec;     {32}
                end;


  Constructor ProgressType.Init(Title : String);
    begin
      TProgress.Init;
      GotoXY((80 - Length(Title)) DIV 2, 1);
      Write(Title);
      GotoXY(34, 2);
      Write('                ');
    end;

  Procedure ProgressType.Display(Count : LongInt);
    begin
      GotoXY(34, 2);
      Write('                ');
      GotoXY(34, 2);
      Write('Record #', Count:5);
    end;


  Function ErrorType.Display(Error     : Integer;
                             ErrorMsg  : String;
                             OpCode    : Integer;
                             OpCodeMsg : String;
                             FileName  : PathStr
                             ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln('ERROR CODE #', Error, ' - ', ErrorMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erDone;  { just let the program continue }
    ClrScr;
  end;

begin
  {*** YOU MUST COMPILE AND RUN EXTEND.PAS FIRST ***}
  ClrScr;
  {$IFDEF DPMI}
  Writeln('COMPILED FOR PROTECTED MODE');
  {$ENDIF}
  ErrDisplay.Init;
  ErrHandler.Init(@ErrDisplay, 'BTRIEVE.ERR');

  Fin.Init('EXTEND.DAT', @ErrHandler, @InBuff, SizeOf(InBuff));
  Fin.Open(bNormal, '');

  {CLONE & COPY}
  Fin.Clone('TEST7A.DAT', bNormal);
  Fout.Init('TEST7A.DAT', @ErrHandler, @OutBuff, SizeOf(OutBuff));
  Fout.Open(bNormal, '');
  Progress.Init('CLONE A FILE');
  Fin.Copy(@Fout, @Progress);
  Progress.Done;
  Fout.Close;

  {SAVE}
  Fout.Open(bNormal, '');
  Fout.SetKeyPath(1); {FIRST NAME}
  Progress.Init('SAVE A FILE');
  Fout.Save('TEST7A.ASC', @Progress);
  Progress.Done;
  Fout.Close;
  Fout.Done;

  {LOAD}
  Fin.Clone('TEST7B.DAT', bNormal);
  Fout.Init('TEST7B.DAT', @ErrHandler, @OutBuff, SizeOf(OutBuff));
  Fout.Open(bNormal, '');
  Progress.Init('LOAD A SAVED FILE');
  Fout.Load('TEST7A.ASC', @Progress);
  Progress.Done;
  Fout.Close;

  {RECOVER}
  Fout.Open(bNormal, '');
  Progress.Init('RECOVER A FILE');
  Fout.Recover('TEST7B.ASC', @Progress);
  Progress.Done;
  Fout.Close;
  Fout.Done;

  {LOAD}
  Fin.Clone('TEST7C.DAT', bNormal);
  Fout.Init('TEST7C.DAT', @ErrHandler, @OutBuff, SizeOf(OutBuff));
  Fout.Open(bNormal, '');
  Progress.Init('LOAD A RECOVERED FILE');
  Fout.Load('TEST7B.ASC', @Progress);
  Progress.Done;
  Fout.Close;

  Fin.Close;
end.
