{$X+}
{$V-}
{ EXAMPLE3.PAS - demonstrate file creation with variable length records,
                 alternate collating sequences,
                 reading and writing variable length records

  Requires Turbo Pascal version 6.0, 7.0

  ***** REQUIRES THE FILE UPPER.ALT *****

}
Uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv;


type
  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


var
  F           : BtrieveFile;
  Buff        : record
                  Name    : String[30];
                  Comment : String[80];
                end;
  Name        : String[30];
  Comment     : String[80];
  ErrHandler  : ErrorHandler;
  ErrDisplay  : ErrorType;


{ Heres our error display object  }
Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erAbort; { halt program on any errors }
    ClrScr;
  end;

begin
  { first make a error display }
  ErrDisplay.Init;
  { now make an error handler, it needs a display object  }
  ErrHandler.Init(@ErrDisplay);

  ClrScr;
  Writeln('Creating a file called TEST3.DAT');

  { init the file passing it the error handler and }
  { address of our data buffer                     }
  F.Init('TEST3.DAT', @ErrHandler, @Buff, SizeOf(Buff));

  { the first thing to do is define the key }
  { key is name, it is an lString and uses an Alt. collating  }
  { sequence and is left justified and padded                 }
  F.AddKeySegment(1, 31, bExtended + bAltSequence, bLstring, 0, bLJustify);

  { define an alternate collating sequence }
  F.AddAltSequence('UPPER.ALT');
  { now that the key is defined lets create and open it }
  { this one has variable length records                }
  { the record size is only the size of fixed portion   }
  F.Create(bVariableLen, 31, 1024, 0, bNormal);
  F.Open(bNormal, '');

  if (F.bResult <> bOkay) then Halt;

  { lets add a couple records  }
  Buff.Name   := 'AAAAAAAAAA';
  Buff.Comment:= 'XXXXX';
  { need to set the size of the output buffer, this must include the }
  { fixed plus the variable portions                                 }
  F.SetOutputSize(SizeOf(Buff.Name) + Length(Buff.Comment) + 1);
  F.Insert;
  Write('Adding some records .');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'BBBBBBBBBB';
  Buff.Comment:= 'XXXXXXXXXX';
  F.SetOutputSize(SizeOf(Buff.Name) + Length(Buff.Comment) + 1);
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'CCCCCCCCCC';
  Buff.Comment:= 'XXXXXXXXXXXXXXX';
  F.SetOutputSize(SizeOf(Buff.Name) + Length(Buff.Comment) + 1);
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'DDDDDDDDDD';
  Buff.Comment:= 'XXXXXXXXXXXXXXXXXXXX';
  F.SetOutputSize(SizeOf(Buff.Name) + Length(Buff.Comment) + 1);
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'EEEEEEEEEE';
  Buff.Comment:= 'XXXXXXXXXXXXXXXXXXXXXXXXX';
  F.SetOutputSize(SizeOf(Buff.Name) + Length(Buff.Comment) + 1);
  F.Insert;
  Writeln('.');

  { now we'll just spin through the file, look at the data and }
  { see how big each record is                                 }
  F.Get(bGetFirst, bNoLock);

  While (F.bResult = bOkay) do
  begin
    Writeln(Buff.Name);
    Writeln(Buff.Comment);
    Writeln(F.BytesRead, ' Bytes in this record');
    Writeln;
    F.Get(bGetNext, bNoLock);
  end;

  F.Close;
end.
