{$X+}
{$V-}
{ EXAMPLE2.PAS - demonstrate file creation with segmented keys,
                 supplemental indexes, alternate collating sequences

  Requires Turbo Pascal version 6.0, 7.0


  ***** REQUIRES THE FILE UPPER.ALT *****

}
Uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv;


type
  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


var
  F           : BtrieveFile;
  Buff        : record
                  Name    : String[30];
                  Number  : Integer;
                  Comment : String[80];
                end;
  Name        : String[30];
  Number      : Integer;
  Comment     : String[80];
  ErrHandler  : DefErrorHandler;
  ErrDisplay  : ErrorType;


{ Heres our error display object  }
Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erDone;  { just let the program continue }
    ClrScr;
  end;

begin
  ClrScr;
  {$IFDEF WINDOWS}
  Writeln('COMPILED FOR WINDOWS');
  {$ENDIF}
  {$IFDEF DPMI}
  Writeln('COMPILED FOR PROTECTED MODE');
  {$ENDIF}
  {$IFDEF MSDOS}
  Writeln('COMPILED FOR REAL MODE');
  {$ENDIF}
  { first make a error display }
  ErrDisplay.Init;
  { now make an error handler, it needs a display object  }
  ErrHandler.Init(@ErrDisplay);

  Writeln('Creating a file called TEST2.DAT');

  { init the file passing it the error handler and }
  { address of our data buffer                     }
  F.Init('TEST2.DAT', @ErrHandler, @Buff, SizeOf(Buff));

  { the first thing to do is define the key }
  { this one will be a segmented key        }
  { Segment #1 is a string that is left justified and padded }
  F.AddKeySegment(1, 31, bExtended + bSegmented, bLstring, 0, bLJustify);
  { Segment #2  is an integer and cannot be justified at all }
  F.AddKeySegment(32, 2, bExtended, bInteger, 0, bNormal);

  { now that the key is defined lets create and open it }
  { we will preallocate 15 pages just for fun           }
  F.Create(bPreallocate, SizeOf(Buff), 1024, 15, bNormal);
  F.Open(bNormal, '');

  { lets add a couple records  }
  Buff.Name   := 'AAAAAAAAAA';
  Buff.Number := 1;
  Buff.Comment:= 'Record #1';
  F.Insert;
  Write('Adding some records .');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'BBBBBBBBBB';
  Buff.Number := 2;
  Buff.Comment:= 'Record #2';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'CCCCCCCCCC';
  Buff.Number := 3;
  Buff.Comment:= 'Record #3';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'DDDDDDDDDD';
  Buff.Number := 4;
  Buff.Comment:= 'Record #4';
  F.Insert;
  Write('.');
  {$IFNDEF WINDOWS}
  Delay(500);
  {$ENDIF}

  Buff.Name   := 'EEEEEEEEEE';
  Buff.Number := 5;
  Buff.Comment:= 'Record #5';
  F.Insert;
  Writeln('.');

  { let's see how big the file is }
  Writeln('There are ', F.NumberOfRecords, ' records in the file.');
  Writeln('Press a key...');
  ReadKey;

  { how about reading a record by key }
  Writeln('Reading by key');
  { build the key }
  { this will be justified and padded automatically as needed }
  Name    := 'EEEEEEEEEE';
  Number  := 5;
  { make sure these are in the right order  }
  F.MakeKey(@Name, @Number, nil, nil, nil, nil);
  { read it without locks }
  F.Get(bGetEqual, bNoLock);
  Writeln(Buff.Name);
  Writeln(Buff.Number);
  Writeln(Buff.Comment);
  Writeln('Press a key...');
  ReadKey;

  Writeln('Adding a supplemental index...');
  Writeln('Press a key...');
  ReadKey;
  { add a supplemental key this is just like adding a normal key  }
  { the new index will have an alternate collating sequence       }
  { this key should not be justified since existing data won't be }
  F.AddSupplKeySegment(34, 81, bExtended + bAltSequence, bLstring, 0, bNormal);
  { if the file already had an alternate collating sequence }
  { we would skip this next call                            }
  F.AddAltSequence('UPPER.ALT');
  F.CreateIndex;

  { read with the new index }
  F.SetKeyPath(1);
  { see if UPPER.ALT works }
  Comment := 'ReCoRd #1';
  F.MakeKey(@Comment, nil, nil, nil, nil, nil);
  F.Get(bGetEqual, bNoLock);
  Writeln(Buff.Name);
  Writeln(Buff.Number);
  Writeln(Buff.Comment);
  Writeln('Press a key...');
  ReadKey;

  { now get rid of the index  }
  F.DropIndex(1);
  F.Close;
end.
