#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <graphics.h>
#include <stdlib.h>
#include "titillat.h"
#include "plot3d.h"
#include "vga3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

vga3d::vga3d()
  {
    registerbgidriver(EGAVGA_driver);
      // See the Borland documentation on the utilities "BINOBJ" and "TLIB"
      // for information on how to link "EGAVGA.BGI" into a program from
      // "GRAPHICS.LIB".
    AspectRatio=(HEIGHT_OF_SCREEN/WIDTH_OF_SCREEN)
     /(((double) NUM_Y_PIXELS)/((double) NUM_X_PIXELS));
    graph_open=FALSE;
  }

vga3d::~vga3d()
  {
    if (graph_open)
      closegraph();
  }

int vga3d::display_initialized()
// Set display to 640x480x16 VGA mode.  Define shades of gray and color for 
// highlighting.
    {
      int                errorcode;
      int                graphdriver;
      int                graphmode;
      struct palettetype palette;
      int                tint;

      if (graph_open)
        {
          closegraph();
          graph_open=FALSE;
        }
      graphdriver=VGA;
      graphmode=VGAHI;
      initgraph((int far *) &graphdriver,(int far *) &graphmode,"");
      if ((errorcode=graphresult()) == grOk)
        {
          graph_open=TRUE;
          getpalette(&palette);
          // Only 16 "colors" are allowed in this graphics mode.
          for (int color_num=0; color_num < 15; color_num++)
          // Get 15 evenly spaced shades of gray.
            {
              tint=(63*color_num)/14;
              tint&=0xfc;
              setrgbpalette(palette.colors[color_num],tint,tint,tint);
            }
          // Set the highlighting color to red.
          setrgbpalette(palette.colors[15],0xfc,0,0);
        }
      else
        {
          closegraph();
          cerr << "Fatal error: " << grapherrormsg(errorcode) << '\n';
        }
      return graph_open;
    }

void vga3d::pset(
  int x,
  int y,
  int color_num)
    {
      if (color_num <= NUM_COLORS)
        {
          if (color_num == NUM_COLORS) // highlighted
            putpixel(x,y,15);
          else                         // gray
            putpixel(x,y,(14*color_num)/(NUM_COLORS-1));
        }
      return;
    }
