/*  Project tooltest

	Copyright  1994. All Rights Reserved.

	SUBSYSTEM:    tooltest.exe Application
	FILE:         test.cpp
	AUTHOR:       Steve Saxon


	OVERVIEW
	========
	Source file for implementation of TooltipApp (TApplication).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\textgadg.h>

#include "test.h"
#include "about.h"              // Definition of about dialog.

//{{TooltipApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TooltipApp, TApplication)
//{{TooltipAppRSP_TBL_BEGIN}}
	EV_COMMAND(CM_FILENEW, CmFileNew),
	EV_COMMAND(CM_FILEOPEN, CmFileOpen),
	EV_COMMAND(CM_FILECLOSE, CmFileClose),
	EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{TooltipAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
	SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
			TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
	  {  }
	~SDIDecFrame ()
	  {  }
};


//////////////////////////////////////////////////////////
// TooltipApp
// =====
//
TooltipApp::TooltipApp ()
	: 	TApplication("Tooltip Application"),
		tooltip (Tip::SquareBorder | Tip::Shadow)
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


TooltipApp::~TooltipApp ()
{
    // INSERT>> Your destructor code here.

}

//////////////////////////////////////////////////////////
// TooltipApp
// =====
// Application intialization.
//
void TooltipApp::InitMainWindow ()
{
	Client = new TEditFile(0, 0, 0);
    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, TRUE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

	//
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
	frame->Attr.AccelTable = SDI_MENU;

	//
	// Create default toolbar New and associate toolbar buttons with commands.
	//
	TTipControlBar* cb = new TTipControlBar(tooltip, frame);
	cb->Insert(*new TButtonGadget(CM_FILENEW, CM_FILENEW));
	cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN));
	cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
	cb->Insert(*new TSeparatorGadget(6));
	cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
	cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
	cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
	cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
	cb->Insert(*new TSeparatorGadget(6));
	cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
	cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));

	frame->Insert(*cb, TDecoratedFrame::Top);

	//
	// Create default status bar.
	//
	TStatusBar *sb = new TTipStatusBar(tooltip, frame, TGadget::Recessed,
									TStatusBar::CapsLock        |
									TStatusBar::NumLock         |
									TStatusBar::ScrollLock      |
									TStatusBar::Overtype);
	frame->Insert(*sb, TDecoratedFrame::Bottom);

	MainWindow = frame;

//	cb->SetDocking (FALSE);
}


//////////////////////////////////////////////////////////
// TooltipApp
// ===========
// Menu File New command
void TooltipApp::CmFileNew ()
{
    Client->NewFile();
}


//////////////////////////////////////////////////////////
// TooltipApp
// ===========
// Menu File Open command
void TooltipApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
            OpenFile();
}


void TooltipApp::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

    Client->ReplaceWith(FileData.FileName);
}


//////////////////////////////////////////////////////////
// TooltipApp
// =====
// Menu File Close command
void TooltipApp::CmFileClose ()
{
	 if (Client->CanClose())
	         Client->DeleteSubText(0, UINT(-1));
}


//////////////////////////////////////////////////////////
// TooltipApp
// ===========
// Menu Help About tooltest.exe command
void TooltipApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    TooltipAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
    TooltipApp     App;
    int             result;

    result = App.Run();

    return result;
}
