/*
    Copyright (C) 1989-1994 The GAP Development Company

    All Rights Reserved


    CDOOR.C

    Demonstration program for GAPCDR


    Microsoft

    To compile : cl /c /FPa /Os /Og /Ob0 cdoor.c
    To link    : link cdoor,,NUL.MAP,+gapcdrs

    ----------------------------------------------------------

    Borland

    With Borland, YOU have to tell it which of its OWN
    OBJ and LIB files to link in. It isn't smart enough to
    KNOW which ones are required.

    Be sure that C0S.OBJ is linked first and that you NAME
    the EXE file (otherwise it will be named C0S.EXE.

    To compile : bcc -ms -O -Z -d -c cdoor.c
    To link    : tlink c0s+cdoor,cdoor.exe,NUL.MAP,+gapcdbs+cs


    Program will need access to CDOOR.CNF and DOOR.SYS

*/

#if (_MSC_VER)                            // Microsoft
   #pragma check_stack(off)
   #pragma optimize("b0celt",on)
#else                                     // Borland
   #pragma option -Ot -Oc -Ol -Oe -N-
#endif

#include <stdio.h>                        // C standard header file
#include <dos.h>
#include <stdlib.h>
#include <string.h>

   /***********************************************************************/
   /*  Before doing ANYTHING else, include the following files.           */
   /***********************************************************************/

#include "compiler.h"                     // defines compiler being used
#include "gapcdr.h"                       // header file for GAPCDR


   /***********************************************************************/
   /*  Declare any global variables                                       */
   /***********************************************************************/

   char anystring1 [250];                 // global garbage collector

   // We are placing our Menu inside the program.
   // It can just as easily be a file that we would display.
   // Notice that the Menu contains embedded ANSI codes.
   // Also notice that we don't have a non-color version of the Menu.
   // This is because if the caller is in mono mode, GAPCDR will filter
   // the ANSI codes. It is important to realize that if you have ONLY
   // a color version of a Menu or Display file, that the Menu contain
   // ONLY ANSI color sequences. It cannot contain any other ANSI 
   // sequences such as cursor movement commands. Notice that our
   // Menu uses actual 'spaces' and no cursor sequences. If the Menu
   // contained cursor movement commands and the caller is in non-color
   // mode, the ANSI driver will remove the ANSI sequences (which includes
   // the cursor movement commands) and the screen will not display
   // correctly.

   char *menug [] =
      {
      "          [0m",
      "          [1;33;41mĿ[0m",
      "          [1;33;41m              Main Menu               [30;40m[0m",
      "          [1;33;41m[30;40m[0m",
      "          [1;30m[0m",
      "          ",
      "          [1;33;44mĿ[0m",
      "          [1;33;44m  [[31mC[33m][37molor               [33m[[31mT[33m][37mop Scores  [33m[30;40m[0m",
      "          [1;33;44m  [[31mD[33m][37mos Window          [33m[[31mS[33m][37mhow File   [33m[30;40m[0m",
      "          [1;33;44m  [[31mX[33m][37mcode Example       [33m[[31mA[33m][37mNSICMD's   [33m[30;40m[0m",
      "          [1;33;44m  [[31mP[33m][37mage Sysop          [33m[[31mQ[33m][37muit        [33m[30;40m[0m",
      "          [1;33;44m[30;40m[0m",
      "          [1;30m[0m",
      "          [0m",
      "\0"
      };


   // declare functions

   static void __pascal __near dos_window(short how);


   /***********************************************************************/
   /*  Begin main line code here                                          */
   /***********************************************************************/

void main(void)
{
   short oldbell;                         // status of page bell flag
   char **menu;                           // pointer to menu arrays
   char response [80];                    // for getting responses
   char prompt   [80];                    // for the prompt line

   FILE *doorcnf;                         // file pointer for cnf file

   // remember screen attributes for the DOS Window

   get_attr();                            // remember screen attribs


   /***********************************************************************/
   /*  Before doing ANYTHING else, initialize the door with the following */
   /*  two function calls.                                                */
   /*  Then, if you have any configuration options, read them in and then */
   /*  close the file.                                                    */
   /*  Note that we are hardcoding the name of the configuration file.    */
   /*  Normally, this is passed as a command line parameter so you would  */
   /*  call read_cnf like this :  doorcnf = read_cnf(argv[1]);            */
   /***********************************************************************/

   doorcnf = read_cnf("CDOOR.CNF");       // read door configuration file
   init_door();                           // initialize the door

   fclose(doorcnf);                       // we dont have any configuration
                                          // options so we will just close


   /***********************************************************************/
   /*  Lets now build some menus all at once.                             */
   /*  These menus were created with an ANSI editor.  This is perhaps the */
   /*  fastest and easiest way to create menus.                           */
   /***********************************************************************/

   do
      {
      // Format the prompt

      time_left();                        // get # of mins left

      sprintf(prompt,"\r\n%s[%s%d mins%s] Main Command : ",A_YELLOW,
              A_BRED,timeleft,A_YELLOW);

      clear_scrn();                       // first clear the screen

      nl(2);                              // do a couple of blank lines

      menu = menug;                       // set pointer to our menu

      while (**menu)                      // now show the menu
         show_mess(*menu++,NO,YES);

      show_mess(prompt,NO,NO);            // show the prompt

      empty(response,1);                  // initialize response
      get_string(response);               // get user input

      switch (response[0])
         {
         case 'C' :                       // toggle color
            if (color)                    // if in color already
               color = 0;                 // turn color flag off
            else                          // otherwise
               color = 1;                 // turn it on

            fix_color();                  // tell ANSI driver what we did
            break;

         case 'D' :                       // DOS Window
            // show message on local screen so they know how to get
            // back to program

            nl(1);
            lputs(A_BWHITE);
            lputs("                      Type 'Exit' to return to program");

            dos_window(0);                // make a DOS window
            system("COMMAND");            // shell to DOS
            dos_window(1);                // remove the DOS window
            break;

         case 'P' :                       // page the sysop
            oldbell = bell;               // remember original setting
            bell = 1;                     // turn page bell on
            pagesysop();                  // go page the sysop
            bell = oldbell;               // restore setting
            break;

         case 'T' :                       // show the scoreboard
            read_score("CDOOR.DAT","Top 10 Players Of Our Example Door");
            
            // add name to score board file

            strcpy(response,username);    // remember user name

            ansi(A_YELLOW);               // set a color

            show_mess("Please Enter Your Name : ", NO,NO);

            empty(username,30);           // initialize string
            get_string(username);         // go get a name

            if (username[0] != 0)         // if name was entered
               {
               write_score("CDOOR.DAT",20220L);   // write the score

               ansi(A_BWHITE);            // set a color
               nl(1);
               show_mess("You are now a Top 10 Player!",NO,YES);
               nl(1);
               pause();
               read_score("CDOOR.DAT","Top 10 Players Of Our Example Door");
               }

            strcpy(username,response);    // restore name

            break;

         case 'A' :
            clear_scrn();                 // clear local and remote screens
            show_file("ANSICMD");         // pass base part of filename
            pause();                      // make sure they've seen it
            break;

         case 'X' :
            clear_scrn();                 // clear local and remote screens
            show_file("XCODES");          // pass base part of filename
            pause();                      // make sure they've seen it
            break;

         case 'S' :                       // show file
            show_file("WELCOME");         // pass base part of filename
            pause();                      // make sure they've seen it
            break;

         case 'Q' :                       // quit
            break;
         }
      }
   while (response[0] != 'Q');

   leave(0);                              // must exit properly!
}

   // makes or removes a DOS Window
   // 0 = make window
   // 1 = remove window

   // Our DOS window is 14 rows by 64 columns (including border) - 1792 bytes

   // NOTE: The program can NOT, under any circumstance, exit or abort 
   // while the DOS window is being displayed. If it does, the computer
   // will crash. This means that while the window is up, there can be
   // NO input or output using GAPCDR since if carrier is dropped, GAPCDR
   // will shut down, and the BIOS trap will still be operating. The end
   // result is a locked up computer the next time a program is run


   static unsigned __near dseg = 0; // DOS stores segment address here

   static char __near border [] =
      {
      ""
      };


static void __pascal __near dos_window(short how)
{
   short r;

   if (!how)                              // set up the screen
      {
      // # of bytes to allocate is 
      // (((cols * 2) * rows) / 16) + 2 (for good measure)

#if (__BORLANDC__)
      if ((allocmem(114,&dseg)) != -1)     // get memory to hold screen
#else
      if ((_dos_allocmem(114,&dseg)) != 0) // get memory to hold screen
#endif
         {                                // can't
         dseg = 0;                        // NULL out pointer
         return;                          // return now
         }

      lputs("[s");                       // remember cursor position for ANSI
      save_screen(3,8,16,71,dseg);        // save underlying window
      normal = 15;                        // Bright White border

      crscur = 0x0308;                    // cursor to row 3, column 8
      sprintf(anystring1,"%s",border);
      lputs(anystring1);                  // show top border

      for (r = 4; r < 17; r++)            // display sides of window
         {
         crscur = 0x0008 + (256 * r);     // next line
         lputc('');                      // left side
         crscur += 62;                    // position cursor
         lputc('');                      // right side
         }

      crscur = 0x1008;                    // cursor to row 16, column 8
      sprintf(anystring1,"%s",border);
      lputs(anystring1);                  // show top border

      // set up the BIOS trap so that the cursor stays inside of the
      // window

      set_int10();                        // set up BIOS handler
      set_cord(4,9,15,70);                // set window co-ordinates (inside dimensions)
      set_attr(14,1);                     // set window attributes (yellow on blue)
      cls_all();                          // clear the window
      }
   else if (how && dseg != 0)             // remove the screen
      {
      rest_int10();                       // reset BIOS handler

      restore_screen(3,8,16,71,dseg);     // restore underlying window
#if (__BORLANDC__)
      freemem(dseg);                      // free memory
#else
      _dos_freemem(dseg);                 // free memory
#endif
      dseg = 0;                           // NULL out pointer
      lputs("[u");                       // restore cursor
      }
}
