/* color_time function */
/* Prints time stamp to screen in color */

#include <stdio.h>
#include <time.h>

/*   Prints current time to the screen in the form hh:mm:ss
     
     Arguments:
     
     char *format: Pointer to format for strftime function
     int r1: Row in which time is to be printed (0-24)
     int c1: Column in which time is to be printed (0-79)
     int color: Attribute in which time is to be printed (0-255) 
     
     Requires colortext function from this library                  
     
     Returns:  0 if no error
               1 if passed incorrect parameters                      */

int color_time(char *format,int r1,c1,color,max_rows)

{
	/* Function declaration */
	int colortext(char text[], int r1, int c1, int color, int max_rows);
	
     /* Variable declaration */
     char out_tim[80];
     struct tm *time_ptr;
     time_t clock;
     
     /* Check for bad arguments */
     if (r1<0 || r1>max_rows || c1<0 || c1>79 || color<0 || color>255)
          return 1;

     /* Main function code */
     time(&clock);
     time_ptr = localtime(&clock);
     strftime(out_tim,25,format,time_ptr);
     colortext(out_tim,r1,c1,color,max_rows);
     
     return 0;
}

