/***********************************************************************
THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
NO EVENT SHALL MICROSOFT CORPORATION OR ITS SUPPLIERS BE LIABLE FOR
ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL,
CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF
MICROSOFT CORPORATION OR ITS SUPPLIERS HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR
LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR INCIDENTAL DAMAGES SO THE
FOREGOING LIMITATION MAY NOT APPLY.

This Software may be copied and distributed royalty-free subject to
the following conditions:

1. You must copy all Software without modification and must include
   all pages, if the Software is distributed without inclusion in your
   software product. If you are incorporating the Software in
   conjunction with and as a part of your software product which adds
   substantial value, you may modify and include portions of the
   Software.

2. You must place all copyright notices and other protective
   disclaimers and notices contained on the Software on all copies of
   the Software and your software product.

3. Unless the Software is incorporated in your software product which
   adds substantial value, you may not distribute this Software for
   profit.

4. You may not use Microsoft's name, logo, or trademarks to market
   your software product.

5. You agree to indemnify, hold harmless, and defend Microsoft and its
   suppliers from and against any claims or lawsuits, including
   attorneys' fees, that arise or result from the use or distribution
   of your software product and any modifications to the Software.

*************************************************************************/
/*--------------------------------------------------------
   DIAL.C - Modem dialing example
  --------------------------------------------------------*/

//****************************************************************************
// File:  dial.c
//
//    Source file for sample Windows modem dialing program
//
// Functions:
//    DialProc()  - dials modem
//    HangUp()    - hangs up
//
// Author:
//
//    Michelle Quinton
//
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************

#include "dial.h"            

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR szCmdLine, int nCmdShow)
   {
   HWND     hwnd;
   MSG      msg;
   WNDCLASS wndclass; 

   ghInstance = hInstance;		// global instance   

   if (!hPrevInstance) 
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WndProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground = GetStockObject (WHITE_BRUSH);
      wndclass.lpszMenuName  = MAKEINTRESOURCE(MENU_MAIN);
      wndclass.lpszClassName = "MainWndClass";

      RegisterClass (&wndclass);
   }

   hwnd = CreateWindow ("MainWndClass", "Modem Dialing Program",
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        250, 150,
                        NULL, NULL, hInstance, NULL);

   ShowWindow (hwnd, nCmdShow);
   UpdateWindow (hwnd);

   while (GetMessage (&msg, NULL, 0, 0))
   {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
   }
   return msg.wParam;
}

//***********************************************************************
// Function:    WndProc()
//
// Purpose:     Main Window procedure
//
//***********************************************************************

LRESULT CALLBACK WndProc (HWND hWnd, UINT uMsg, WPARAM wParam,
							  LPARAM lParam)
{
     
   switch (uMsg)
   {
      case WM_COMMAND:
         switch (wParam)
         {
            case ID_FILE_EXIT:

               DestroyWindow(hWnd);
               return 0;
	    	
            case ID_COMMUNICATIONS_MODEMSETTINGS:
	    	
               DialogBox(ghInstance, MAKEINTRESOURCE(DLG_SETTINGS), hWnd, DlgSettingsProc);
               return 0;

            case ID_COMMUNICATIONS_DIAL:

               DialogBox(ghInstance, MAKEINTRESOURCE(DLG_DIAL), hWnd, DlgDialProc);
               return 0;

            case ID_COMMUNICATIONS_HANGUP:

               DialogBox(ghInstance, MAKEINTRESOURCE(DLG_HANGUP), hWnd, DlgHangupProc);
               return 0;
          }
          break;
          
      case WM_DESTROY:
         PostQuitMessage (0) ;
         return 0 ;
   }

   return DefWindowProc (hWnd, uMsg, wParam, lParam) ;
}

//***********************************************************************
// Function:  DlgSettingsProc()
//
// Purpose:   Dialog box procedure for the settings dialog box
//
//****************************************************************************

BOOL CALLBACK DlgSettingsProc( HWND hDlg, UINT wMsg, WPARAM wParam, LPARAM lParam )
{
   BOOL        bRetVal  = TRUE;
   static UINT uBauds[] = {1200, 2400, 9600, 14400, 19200};
   static int  NUMBAUDS = 5;
   int         i;
										
   switch (wMsg)
   {
      case WM_INITDIALOG:

         // put current values of DialInfo structure in dialog box fields...
         
         SetDlgItemText(hDlg, IDC_INIT, gDialInfo.szInit); 
         SetDlgItemText(hDlg, IDC_PREFIX, gDialInfo.szPrefix);
         SetDlgItemText(hDlg, IDC_SUFFIX, gDialInfo.szSuffix);
         SetDlgItemText(hDlg, IDC_ESCAPE, gDialInfo.szEscape);
         SetDlgItemText(hDlg, IDC_HANGUP, gDialInfo.szHangup);
         SetDlgItemText(hDlg, IDC_PHONENO, gDialInfo.szPhoneNo);
         for (i=0; i<NUMBAUDS; i++)
            if (gDialInfo.uBaudRate == uBauds[i])
               CheckDlgButton(hDlg, IDC_1200+i, 1);
         CheckDlgButton(hDlg, IDC_COM1 + gDialInfo.szComPort[3] - '0' - 1, 1);
         
         break;

      case WM_COMMAND:

         switch (wParam)
         {
            case IDOK:
            
            // ok selected - copy dialog box info into global dial
            // structure

               GetDlgItemText(hDlg, IDC_INIT, gDialInfo.szInit, DIALSTRLEN);
               GetDlgItemText(hDlg, IDC_PREFIX, gDialInfo.szPrefix, DIALSTRLEN);
               GetDlgItemText(hDlg, IDC_SUFFIX, gDialInfo.szSuffix, DIALSTRLEN);
               GetDlgItemText(hDlg, IDC_ESCAPE, gDialInfo.szEscape, DIALSTRLEN);
               GetDlgItemText(hDlg, IDC_HANGUP, gDialInfo.szHangup, DIALSTRLEN);
               GetDlgItemText(hDlg, IDC_PHONENO, gDialInfo.szPhoneNo, DIALSTRLEN);

               EndDialog(hDlg, TRUE);

               break;

            case IDCANCEL:
            
            // cancel selected - just quit

               EndDialog(hDlg, TRUE);
               break;

            //  Baud rate or Com port selected - copy the selection
            //  into the global dial info structure
            
            case IDC_1200:
            case IDC_2400:
            case IDC_9600:
            case IDC_14400:
            case IDC_19200:
               gDialInfo.uBaudRate = uBauds[ (wParam - IDC_1200) ];
               break;
                
            case IDC_COM1:
            case IDC_COM2:
            case IDC_COM3:
            case IDC_COM4:
               gDialInfo.szComPort[3] = wParam - IDC_COM1 + 1 + '0';
               break;
               
            default:
               break;
         }
      break;

      default:
         bRetVal = FALSE;
         break;
   }
   return bRetVal;
}

//***********************************************************************
// Function:  DlgDialProc()
//
// Purpose:   Dialog box procedure for the dialing dialog box
//****************************************************************************

BOOL CALLBACK DlgDialProc( HWND hDlg, UINT wMsg, WPARAM wParam, LPARAM lParam )
{
   BOOL        bRetVal  = TRUE;

   switch (wMsg)
   {
      case WM_INITDIALOG:
         SetFocus(hDlg);       
         PostMessage(hDlg, WM_MYMSG, NULL, NULL);
         bRetVal = FALSE;
         break;

      case WM_MYMSG:

         if (OpenCommPort()) // open the selected com port
         {  
            // Show dialing string, 
            // and call the dialing procedure
            SetDlgItemText(hDlg, IDC_STATIC, "Now Dialing...");
            
            if (!(DialProc()))
            {
               SetDlgItemText(hDlg, IDC_STATIC, "Dialing Failed");
               CloseComm(idComDev);
            }
            else    // dialing was successful
               SetDlgItemText(hDlg, IDC_STATIC, "Connection Made");
               
            EnableWindow(GetDlgItem(hDlg, IDCANCEL), TRUE);
         }
         else
            MessageBox(NULL, "OpenComm Failed", NULL, MB_OK);
    
         break;
         
      case WM_COMMAND:

         if (wParam == IDCANCEL)
            EndDialog(hDlg, TRUE);
         else
            bRetVal = FALSE;
            
         break;

      default:
         bRetVal = FALSE;
         break;
   }
   return bRetVal;

}

//***********************************************************************
// Function:  DialProc()
//
// Purpose:   Dial modem according to setting in the global
//            dial info structure
//
// Parameters: None, since dial info is global.  In a "real" implementation,
//             it would be desireable to pass a pointer to this structure. 
//
// Returns:   TRUE if dialing was successful, and an connection was made.
//            FALSE otherwise
//****************************************************************************

BOOL PASCAL DialProc()
{
   // send initialization string and return
   WriteComm(idComDev, gDialInfo.szInit, strlen(gDialInfo.szInit));
   WriteComm(idComDev, "\r", 1);
   
   // wait for OK
   if (WaitString("OK", 2000));
   {
      // send prefix, number, suffix and return
      WriteComm(idComDev, gDialInfo.szPrefix, strlen(gDialInfo.szPrefix));
      WriteComm(idComDev, gDialInfo.szPhoneNo, strlen(gDialInfo.szPhoneNo));
      WriteComm(idComDev, gDialInfo.szSuffix, strlen(gDialInfo.szSuffix));
      WriteComm(idComDev, "\r", 1);

      // wait for connect
      if (WaitString("CONNECT", 30000))
      	return TRUE;  // if connect return TRUE
   }
   
   return FALSE;  // otherwise, return false
}

//***********************************************************************
// Function:    DlgHangupProc()
//
// Purpose:     Dialog Box procedure for HangUp dialog Box
//
//****************************************************************************

BOOL CALLBACK DlgHangupProc(HWND hDlg, UINT wMsg, WPARAM wParam, LPARAM lParam )
{
   BOOL        bRetVal  = FALSE;

   switch (wMsg)
   {
      // post message to begin hangup
      // procedure
      case WM_INITDIALOG:
         PostMessage(hDlg, WM_MYMSG, NULL, NULL);
         break;

      // hangup and end dialog box
      case WM_MYMSG:
         HangUp();
         EndDialog(hDlg, TRUE);
         break;

      default:
         break;
   }
   return bRetVal;

}



//***********************************************************************
// Function:    HangUp()
//
// Purpose:     Drop modem connection and close comm port
//
//
// Parameters:  None, since the dial info structure is global.  In a "real"
//              implementation, would probably want to pass a pointer to this
//              structure.
//
// Returns:     TRUE if connection is dropped and the comm port is closed 
//              successfully.
//              FALSE otherwise
//
//****************************************************************************

BOOL PASCAL HangUp(void)
{
   DWORD   dwTime;
   BOOL    bSuccess = FALSE;

   // flush receive queue
   FlushComm(idComDev, 1);

   // need to wait 1 second before sending escape string
   dwTime = timeGetTime();
   dwTime += 1000;
   while (dwTime > timeGetTime())
          ;

   // send escape sequence and return
   WriteComm(idComDev, gDialInfo.szEscape, strlen(gDialInfo.szEscape));
	
   // wait for OK, but even if we fail on this, try the hangup string anyway
   WaitString("OK", 3000);

   // send hangup string and return
   WriteComm(idComDev, gDialInfo.szHangup, strlen(gDialInfo.szHangup));
   WriteComm(idComDev, "\r", 1);

   // wait for OK, but if we fail, close port anyway
   if (WaitString("OK", 2000))
      bSuccess = TRUE;
      
   FlushComm(idComDev, 0);
   FlushComm(idComDev, 1);
   CloseComm(idComDev);
            	
   return bSuccess;
}

//***********************************************************************
// Function:    WaitString()
//
// Purpose:     Wait a number of milliseconds for the given response string
//
// Parameters:  szString - string to wait for
//              dwTime   - number of milliseconds to wait
//
// Returns:     TRUE if string is returned within dwTime milliseconds.
//              FALSE otherwise
//
//****************************************************************************

BOOL PASCAL WaitString(LPSTR szString, DWORD dwTime)
{
   int     nResult,             // number of character read in ReadComm()
           nStrLen,             // length of string waiting for
           nString=0;           // where we currently are in string
   UINT    nCount;              // where we currently are in read characters
   COMSTAT comstat;
   BOOL    bSuccess = FALSE;
   char    szReadComm[64];      // character read in ReadComm()
   MSG     msg;

   nStrLen=_fstrlen(szString);
   dwTime += timeGetTime();

   // we're just going to wait for however long to see if we
   // got a response

   // while (time hasn't elapsed and we haven't gotten the string yet...)
   while ( (timeGetTime()<dwTime) && (!bSuccess))
   {  
      //  peekmessage loop - allow modem to run in background while 
      //  waiting for string
      
      while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
      {
         if (msg.message == WM_QUIT)
            return TRUE;

         TranslateMessage(&msg);
         DispatchMessage(&msg);
      }

      if (GetCommEventMask(idComDev, EV_RXCHAR)) // anything received yet...
      {  // yeah, see how much (cbInQue) and look through that
         GetCommError(idComDev, &comstat);
         nResult = ReadComm(idComDev, szReadComm, comstat.cbInQue);

         if (!(nResult<0))			// if read didn't fail
         {                          // look through everyhing in in queue
            for (nCount=0; nCount<comstat.cbInQue; nCount++)
               if (szString[nString]==szReadComm[nCount])
               {                    // if it equals the character in the
                                    // string we are waiting for
                  nString++;        // increment where we are
                  if (nString==nStrLen)  // if we are at the end, success
                     bSuccess=TRUE;
               }
         }

      } // end outer if
   }  // end while

   // if there was a timeout before matching string - default of FALSE
   // will be returned
	  
return bSuccess;
}

//***********************************************************************
// Function:    OpenCommPort()
//
// Purpose:     Open the comm port selected in the dial info structure
//
//
// Parameters:  None, since the dial info structure is global.
//
// Returns:     TRUE if comm port opened, FALSE otherwise
//
//****************************************************************************

BOOL PASCAL OpenCommPort(void)
{
   DCB  dcb;

   idComDev = OpenComm(gDialInfo.szComPort, 1024, 128);
   // if valid comm port
   if (idComDev>=0)
   {  // Copy selected baud rate to DCB
      // in a "real" communications program, all other fields
      // in the DCB should be set here, too, such as
      // parity, stop bits, data bits, and flow control
      GetCommState(idComDev, &dcb);
      dcb.BaudRate = gDialInfo.uBaudRate;
      
      if (SetCommState(&dcb)==0)  //successful
      {  
         // set event mask for receive characters
         SetCommEventMask(idComDev, EV_RXCHAR);
         // clear queues.
         FlushComm(idComDev, 0);
         FlushComm(idComDev, 1);
         
         return TRUE;
      }
   }
   
   return FALSE;
}
     