const unsigned char AHERO = 200;

const int SMALLESTTILE = 1; // don't break down the grid yet

//* used by sprite objects

void appendsprite(int newx, int newy, int SpriteType);




class Icon_Obj {
public:
    unsigned char numframes;          // total number of frames in sprite animation
    unsigned char currentframe;       // pointer to current frame (frame count)
    char hitpoints;                   // number of points it takes to die
    Boolean destroyed;                // set to true of sprite was killed
    unsigned char pointvalue;         // number of points you get when the sprite is destoryed
    unsigned char Tile2Draw;          // unique sprite value for indexing
    int X;                            // cordinates of sprite
    int Y;
    // working temp variables
    unsigned char indexoffset,spritewidth,spriteheigth;
    int tempx,tempy;

     Icon_Obj(int startx, int starty);
     virtual void Draw();
     virtual void Move();
     virtual void MoveTo(int newx, int newy);
     virtual void FillMap();
     virtual Boolean Collision();
     virtual void DestroySprite();
     virtual Boolean IsDestroyed();
     virtual void DrawWreckage();
     virtual Boolean badicon(unsigned char avalue);
				 // returns true if the values in the
				 // global map will cause this sprite
				 // to blow up
     virtual void calcoffsets();
};

 Icon_Obj::Icon_Obj(int startx, int starty){
    numframes     = 0;
    currentframe  = 0;
    hitpoints     = 0;
    destroyed     = false;
    pointvalue    = 0;
    Tile2Draw     = 0;
    X             = startx;
    Y             = starty;
 };

 void Icon_Obj::calcoffsets(){

  indexoffset = Tile2Draw + currentframe;
  tempx = TILES[indexoffset].x; // first tile value, plus frame advance value
  tempy = TILES[indexoffset].y;
  spritewidth = TILES[indexoffset].spritewidth /SMALLESTTILE;
  spriteheigth = TILES[indexoffset].spriteheigth /SMALLESTTILE;
   if(spritewidth == 0) spritewidth++; if(spriteheigth == 0) spriteheigth++; // keep an index of at least 1
  currentframe++;
  if(currentframe > numframes) currentframe = 0;
 // fills the global play map with the sprites value

   };
  void Icon_Obj::FillMap(){
  // fills the global play map with the sprites value


   int ty = Y/SMALLESTTILE;
   int tx = X/SMALLESTTILE;

   unsigned char temph,tempw;
   for(temph=0;temph<spriteheigth;temph++){
    for(tempw=0;tempw<spritewidth;tempw++){
	 spritemap[temph+ty][tempw+tx] = Tile2Draw;
       }
     }

 };


 // will the values in the table cause this icon to blow up??
 Boolean Icon_Obj::badicon(unsigned char avalue){
      if(avalue < 3) return true;
      return false;
 };

 Boolean Icon_Obj::Collision(){

   unsigned char temph,tempw,avalue;
   Boolean retval = false;
   int ty = Y/SMALLESTTILE;
   int tx = X/SMALLESTTILE;
   for(temph=0;temph<spriteheigth;temph++){
    for(tempw=0;tempw<spritewidth;tempw++){
	avalue = spritemap[temph+ty][tempw+tx];
	if(badicon(avalue)) retval = true; // if something there besides the tile then explode
       }
     }
  return retval;
 };


 void Icon_Obj::Draw(){
 // trasfer icon from tile page to backdrop
 int sw,sh;
 sw = TILES[indexoffset].spritewidth;
 sh = TILES[indexoffset].spriteheigth;
 fg_tcxfer(tempx,tempx+sw,tempy,tempy+sh,X,Y+21,TILEPAGE,WORKPAGE);

};

 void Icon_Obj::DrawWreckage(){
 // trasfer icon from tile page to backdrop
 fg_tcxfer(170,170+8,0,0+8,X,Y,TILEPAGE,WORKPAGE);
};

void Icon_Obj::Move(){
  calcoffsets();
  FillMap();
//  currentframe++;       // cycle to the next sprite frame
//  if(currentframe > numframes) currentframe = 0;
};

void Icon_Obj::DestroySprite(){
  destroyed = true;
 };

Boolean Icon_Obj::IsDestroyed(){

 if(Collision()){
    DestroySprite();
    FillMap();
    DrawWreckage();
  }

  return destroyed;
}

void Icon_Obj::MoveTo(int newx, int newy){
 X=newx; Y=newy;
};


// fills in the map array with the tile number
// used for collision detection
// derive a class off of icon_obj
class AHero : public Icon_Obj {
public:
 AHero(int startx, int starty);
 virtual Boolean badicon(unsigned char avalue);
 virtual void DestroySprite();
 virtual void Move();
};

void AHero::Move(){
  currentframe = HerosDirection;
  calcoffsets();
  FillMap();
};
AHero::AHero(int startx, int starty) : Icon_Obj(startx,starty)
{
    numframes     = 0;
    currentframe  = 0;
    hitpoints     = 0;
    destroyed     = false;
    pointvalue    = 0;
    Tile2Draw     = AHERO;         // TILES index value of this sprite
    X             = startx;
    Y             = starty;
};
 void AHero::DestroySprite(){
 if(!GODMODEACTIVE){ // don't die if in god mode
  destroyed = true;
  DEAD = true;   // set global crash variable
 }
 };

 Boolean AHero::badicon(unsigned char avalue){
      if(avalue > 2) return true;
      return false;
 };



//----- use this down here because Icon_Obj appends sprites to the
//    list, but the atomstruct  references an Icon_Obj object
// keep sprites in a list, cycle through only drawing visible sprites
// once the level is complete, then delete all sprites from the list.
//const unsigned char MAXSPRITES = 35;

void updateallsprites();
void moveallsprites();
void showallsprites();
void freelist();
Icon_Obj *geticon(int newx, int newy, unsigned char SpriteType);



struct atomstruct{
   int avalue;
   Icon_Obj *asprite;
    struct atomstruct *prev;
    struct atomstruct *next;
   };

struct atomstruct *alist;  // the spritelist
struct atomstruct *ptrlast;


void appendsprite(int newx, int newy, int SpriteType){
struct atomstruct *NEWATOM;
 //  NEWATOM = (atomstruct *) malloc(sizeof(atomstruct));
   NEWATOM = new atomstruct;
   NEWATOM->asprite = geticon(newx,newy,SpriteType);
   NEWATOM->avalue=SpriteType;
   NEWATOM->next = NULL;
   NEWATOM->prev = ptrlast;
   ptrlast->next = NEWATOM;
   ptrlast = NEWATOM;
}

// destroys the whole list
void freelist(){
struct atomstruct *TEMP;
   TEMP = ptrlast;
  do{
     delete TEMP->next->asprite;
     delete TEMP->next;
     TEMP=TEMP->prev;

   }while(TEMP != NULL);
   alist->next = NULL;
   ptrlast=alist;
}


// calls the Draw() member function for each object in the list
void showallsprites(){
struct atomstruct *TEMP;
   TEMP=alist;
 do{
   TEMP->asprite->Draw();
   TEMP=TEMP->next;
   }while(TEMP != NULL);
}

void moveallsprites(){
struct atomstruct *TEMP;
   TEMP=alist;
 do{
   TEMP->asprite->Move();
   TEMP=TEMP->next;
   }while(TEMP != NULL);
}


// calls the Move() member function for each object in the list
void updateallsprites(){
struct atomstruct *TEMP,*NOW,*NEXT,*PREV,*LAST;
   NOW=alist;
//   if(NOW->asprite->Move() == 99) {
     // ship was blown up
//    }
//    else{
      if(NOW->asprite->IsDestroyed());  // don't do anything just check if the ship is hit since the list
					// below starts with the second sprite in the list
      while(NOW->next != NULL){

	 if(NOW->next->asprite->IsDestroyed() == true){
	 NEXT = NOW->next;
	 NOW->next = NOW->next->next;
	 delete NEXT->asprite;
	 delete NEXT;
	 }
	 else
	 NOW = NOW->next;
       }
      ptrlast = NOW;
//     } end else
}

Icon_Obj *geticon(int newx, int newy, unsigned char SpriteType){

switch(SpriteType)
   {
    case AHERO : return new AHero(newx,newy);
   }
//   return new Icon_Obj(newx,newy,SpriteType);
 return NULL;
}