;============================================================================;
; The writer here has been modified to handle monocolor fonts, by dealing    ;
; with them in binary format as opposed to the color font format, which is   ;
; one byte per pixel. My font cutter program was originally designed to do   ;
; scroller fonts, so it deals with them sideways <wierd..> Anyway, I had to  ;
; design this writer to do the same. It's fairly quick.                      ;
;============================================================================;
        ;-------------------------------;
        ; Throw me some data points.    ;
LXMOVE  equ     7                       ;
LYMOVE  equ     14                      ;
LXSTART equ     -1                      ;
LYSTART equ     50                      ;
wr_font_seg     dw      0               ;
wr_font_off     dw      0               ;
wr_xsize        dw      0               ;
wr_ysize        dw      0               ;
wr_savesi       dw      0               ;
wr_savedi       dw      0               ;
lx      dw      LXSTART                 ;
ly      dw      LYSTART                 ;
ltrptr  dw      0                       ;
tx_offs dw      0                       ;
letdat  dw      4 dup(2070h)            ;
letdat_end dw   2070h                   ;
letadr  dw      4 dup(0)                ;
letadr_end dw   0                       ;
        ; ------------------------------;
        ; Internal Pause/Clear counters ;
PS_WAIT         =       64              ;
PAUSE_SCROFFS   equ     12802           ;
pausecount      dw      0               ;
pauseflag       db      0               ;
        ;-------------------------------;
        ; One-shot init macro           ;
@writer_init macro                      ;
        push ds                         ;
        mov ax,seg wr_font_seg          ;
        mov ds,ax                       ;
        mov ax,seg scrfont              ;
        mov [wr_font_seg],ax            ;
        mov ax,offset scrfont           ;
        mov [wr_font_off],ax            ;
        pop ds                          ;
endm @writer_init                       ;
        ;-------------------------------;
        ; Do a char                     ;
do_char proc                            ;
        push ds                         ;
        mov dl,bh                       ;
        push dx                         ;
        cmp dl,'a'                      ;
        jl dc_00                        ;
        cmp dl,'z'                      ;
        jg dc_00                        ;
        sub dl,20h                      ;
dc_00:  cmp dl,32                       ;
        jl dc_gotta_go                  ;
        cmp dl,'Z'                      ;
        jle dc_cont                     ;
dc_gotta_go:                            ;
        pop ax                          ;
        xor dx,dx                       ;
        jmp short dc_exit               ;
dc_cont:                                ;
        xor ax,ax                       ;
        mov al,dl                       ;
        sub al,20h                      ;
        mov cx,FONTCHARSIZE             ;
        imul cx                         ;
        add ax,cs:[wr_font_off]         ;
        mov si,ax                       ;
        pop dx                          ;
        push ds                         ;
        mov ax,cs:[datseg]              ;
        mov ds,ax                       ;
        mov ah,bl                       ;
        mov cx,8                        ;
dc00:   push di                         ;
        push cx                         ;
        mov bx,word ptr cs:[si]         ;
        mov dx,word ptr cs:[si+2]       ;
        add si,2                        ;
        mov bp,8000h                    ;
        mov cx,FONT_HEIGHT              ;
dc01:   test bx,bp                      ;
        jz dc02                         ;
        mov al,ah                       ;
        test dx,bp                      ;
        jz dc03                         ;
        inc al                          ;
dc03:   mov ds:[di],al                  ;
        mov es:[di],al                  ;
dc02:   add di,320                      ;
        shr bp,1                        ;
        loop dc01                       ;
        pop cx                          ;
        pop di                          ;
        inc di                          ;
        loop dc00                       ;
        ;-------------------------------;
        pop ds                          ;
dc_exit:                                ;
        pop ds                          ;
        ret                             ;
do_char endp                            ;
        ;-------------------------------;
        ; Screen pausing                ;
        ; Begin pause cycle.            ;
start_pause:                            ;
        mov cs:[pauseflag],1            ;
        mov cs:[pausecount],0           ;
        ret                             ;
        ;-------------------------------;
        ; Do the pause.                 ;
pause_wrds:                             ;
        pusha                           ;
        push ds                         ;
        mov ax,[datseg]                 ;
        mov ds,ax                       ;
        inc cs:[pausecount]             ;
        mov ax,cs:[pausecount]          ;
        cmp ax,PS_WAIT                  ;
        jl pause_exit                   ;
        cmp ax,94+PS_WAIT               ;
        jge end_pause                   ;
        sub ax,56                       ;
        mov bx,ax                       ;
        mov cx,ax                       ;
        sal cx,8                        ;
        sal bx,6                        ;
        add bx,cx                       ;
        add ax,3                        ;
        and ax,7                        ;
        sal ax,3                        ;
        mov dx,ax                       ;
        mov di,bx                       ;
        add di,PAUSE_SCROFFS            ;
        mov cx,6                        ;
pl_a1:  push cx                         ;
        push di                         ;
        mov cx,316                      ;
        mov si,01                       ;
pauseloop:                              ;
        inc si                          ;
        and si,07                       ;
        mov al,byte ptr ds:[di]         ;
        cmp al,66                       ;
        jl pl_03                        ;
        cmp al,70                       ;
        je pl_01                        ;
        inc al                          ;
        jmp short pl_02                 ;
pl_01:  mov ax,si                       ;
        add ax,dx                       ;
        add ax,1                        ;
pl_02:  mov byte ptr es:[di],al         ;
        mov byte ptr ds:[di],al         ;
pl_03:  inc di                          ;
        loop pauseloop                  ;
        pop di                          ;
        add di,320                      ;
        add dx,8                        ;
        and dx,56                       ;
        pop cx                          ;
        loop pl_a1                      ;
        jmp short pause_exit            ;
end_pause:                              ;
        mov cs:[pauseflag],0            ;
pause_exit:                             ;
        pop ds                          ;
        popa                            ;
        ret                             ;
        ;-------------------------------;
        ; Parse the next character.     ;
do_next_char proc                       ;
        push ds                         ;
        push es                         ;
        mov ax,cs                       ;
        mov ds,ax                       ;
        mov es,ax                       ;
dnc_s:  inc cs:[tx_offs]                ;
        mov bx,cs:[tx_offs]             ;
        mov al,byte ptr cs:wrds[bx]     ;
        cmp al,0                        ;
        je dnc_04                       ;
        cmp al,13                       ;
        je dnc_03                       ;
        cmp al,'~'                      ;
        je dnc_02                       ;
        cmp al,'|'      ; clear screen  ;
        je dnc_01                       ;
        ;-------------------------------;
        ; Regular letter.               ;
        push ax                         ;
        mov si,offset letdat            ;
        mov di,si                       ;
        add si,2                        ;
        mov cx,4                        ;
dnc_00: mov ax,word ptr cs:[si]         ;
        dec al                          ;
        mov word ptr cs:[di],ax         ;
        add si,2                        ;
        add di,2                        ;
        loop dnc_00                     ;
        mov si,offset letadr            ;
        mov di,si                       ;
        add si,2                        ;
        mov cx,4                        ;
        rep movsw                       ;
        pop ax                          ;
        mov bx,cs:[ly]                  ;
        mov dx,bx                       ;
        sal bx,6                        ;
        sal dx,8                        ;
        add dx,bx                       ;
        add dx,cs:[lx]                  ;
        mov cs:[letadr_end],dx          ;
        mov ah,al                       ;
        mov al,70                       ;
        mov cs:[letdat_end],ax          ;
        add cs:[lx],LXMOVE              ;
        jmp short dnc_09                ;
        ;-------------------------------;
        ; Clear screen.                 ;
dnc_01: xor ax,ax                       ;
        mov cx,10                       ;
        mov di,offset letdat            ;
        rep stosw                       ;
        call start_pause                ;
        mov cs:[lx],LXSTART             ;
        mov cs:[ly],LYSTART             ;
        jmp short dnc_09                ;
        ;-------------------------------;
        ; Skip letter, but put a space. ;
dnc_02: add cs:[lx],LXMOVE              ;
        jmp dnc_s                       ;
        ;-------------------------------;
        ; New line, and new offset.     ;
dnc_03: add cs:[ly],LYMOVE              ;
        inc cs:[tx_offs]                ;
        mov bx,word ptr cs:[tx_offs]    ;
        mov al,byte ptr cs:wrds[bx]     ;
        movsx ax,al                     ;
        mov cs:[lx],ax                  ;
        jmp dnc_s                       ;
dnc_04: mov cs:[tx_offs],0              ;
        mov cs:[lx],LXSTART             ;
        mov cs:[ly],LYSTART             ;
dnc_09: pop es                          ;
        pop ds                          ;
        ret                             ;
do_next_char endp                       ;
        ;-------------------------------;
        ; Update the writer. Does the   ;
        ; actual legwork.               ;
do_words proc                           ;
        add cs:[ltrptr],2               ;
        cmp cs:[ltrptr],10              ;
        jne dw01                        ;
        mov cs:[ltrptr],0               ;
        call do_next_char               ;
dw01:   mov bx,cs:[ltrptr]              ;
        mov ax,word ptr cs:letdat[bx]   ;
        mov di,word ptr cs:letadr[bx]   ;
        mov bx,ax                       ;
        call do_char                    ;
        ret                             ;
do_words endp                           ;
        ;-------------------------------;
        ; Da Words.                     ;
        ;                               ;
        ; Text by Syntax Error.         ;
        ;---------------------------------------;
        ;                                       ;
        ; '~' means move cursor, but dont       ;
        ;       plot. Aligns text correctly.    ;
        ;                                       ;
        ; 13,?? means next line, offset next    ;
        ;       line by ?? bytes. -1 is standard;
        ;       3 is to center.                 ;
        ;                                       ;
        ; '|' means to clear the screen.        ;
        ;                                       ;
        ; Zero restarts the text.               ;
        ;---------------------------------------;
wrds    db      13,-1,13,-1
        db      '~~~~~~~~~~~~~~~~THE POWERGRID'                 ,13,-1
        db      '         PHONE NUMBER: 1-813-278-3680'         ,13,3
        db      ' STAFF: GRIDRUNNER, SYNTAX ERROR, AND COWBOY'  ,13,-1
        db      '~~~VISION/2 0.85B REGISTERED SITE.. NO NUP'    ,13,3
        db      '~~~~~~~USR 16.8 DUAL AND A GIG STORAGE       |',13,-1
        db      '      THE ULTIMATE DEMO/ART EXPERIENCE!'       ,13,-1
        db      '    WE SUPPORT THE FOLLOWING DEMO GROUPS:'     ,13,-1
        db      13,-1
        db      ' AVALANCHE WORLD HQ AND DIST APPLICATION HOME' ,13,-1
        db      '~LEINAD FAN CLUB HOME AND WORSHIPPING GROUNDS     |',13,-1
        db      '   US HEADQUARTERS FOR THE FOLLOWING GROUPS '  ,13,-1
        db      '~~FUTURE CREW,DUST,SHADOW FACTION,TEI,IGUANA'  ,13,-1
        db      '~~PSYCHIC MONKS,PENTAGON,DARKZONE,GOLLUM AND'  ,13,3
        db      '~~~~~~~~~~~~~~~~PHANTOMDESIGN'                 ,13,3
        db      '~~~~~~~~~~~~~~      ~~~~~~~~~~~~~~~~~~~~~~~~|' ,13,3
        db      '   WE ALSO SERVE AS DISTRIBTION SITES FOR:'    ,13,3
        db      'THE SILENTS PC * SURPRISE! PRODUCTIONS * VLA'  ,13,3
        db      'ELECTROMOTIVE FORCE * TWILIGHT ZONE * ADMIRE'  ,13,3
        db      '~~~IGUANA * EXTREME * AARDVARK * XOGRAPHY'     ,13,-1
        db      '~~~~~~~~~RENAISSANCE * MENTAL DESIGN     |'    ,13,-1
        db      '    WE SUPPORT THE FOLLOWING ANSI GROUPS:'     ,13,-1
        db      13,3
        db      '  ~~~~~~~~~~ICE, UNION, SHIVER                 ',13,3
        db      '     |',13,-1
        db      '           MAGAZINE DISTRIBUTIONS:'            ,13,-1
        db      13,-1
        db      '~~~~~!INTENSITY MAGAZINE US HEADQUARTERS '     ,13,-1
        db      '~~PULSE DEMO MAGAZINE DISTRIBUTION / POLLING     |',13,3
        db      '     INFINITY MAGAZINE DISTRIBUTION SITE'      ,13,-1
        db      '~~~~~ADRENALIN MAGAZINE DISTRIBUTION SITE'     ,13,-1
        db      '~~~~~~IRIDIUM MAGAZINE DISTRIBUTION SITE     |',13,-1
        db      '     SPECIAL THANKS TO FRIAR TUCK, PIXEL,'     ,13,3
        db      '~~~~~~~~~~PSI, AND EIGHT BALL FOR'             ,13,-1
        db      '~~~CONTRIBUTING TO THIS NICE LITTLE PACKAGE'   ,13,3
        db      'HI SOUL REBEL, EGGHEAD, AND DEEPLY DISTURBED!' ,13,-1
        db      ' HEY TEMPUS, THIS WHAT YOU WERE LOOKING FOR?     |',0


