/*
 * File......: WORKING.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_WORKING()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Output "Working" in white on red on the bottom line
 *  $SYNTAX$
 *      GT_Working()
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Output "Working" in white on red on the bottom line of the screen
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_Working

/****************************************************************************
 Purpose - Output a flashing White on red message on bottom line
 Returns - None
 Author  - Martin Colloby
 Created - 27/6/91
******************************************************************************
 Parameters - None
 Privates   - cString - String to output
              nCol    - Column of start of text
 Externals  - None
****************************************************************************/

LOCAL cString := " Working ... "
LOCAL nCol    := ( MAXCOL() + 1 - LEN( cString ) ) / 2

* Output the message
@ MAXROW() , nCol - 1 SAY ""
GT_ColorSet( C_WARNING )
@ MAXROW() , COL()    SAY cString
GT_ColorSet( C_NORMAL )
@ MAXROW() , COL()    SAY ""

RETURN NIL
*
