/*
 * File......: VIDEOMOD.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_VIDEOMODE()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Set the video mode
 *  $SYNTAX$
 *      GT_VideoMode( nRows , nCols )
 *  $ARGUMENTS$
 *      nRows - Number of screen rows
 *      nCols - Number of screen cols
 *  $RETURNS$
 *      .T. if successful
 *      .F. if failed
 *  $DESCRIPTION$
 *      The video mode is set to nRows * nCols.  If this fails, the mode should
 *      not change.
 *
 *      The following constants are currently available :
 *
 *      Rows                Columns
 *      V_EGA       43      V_SINGLE    80
 *      V_VGA       50      V_DOUBLE    40
 *      V_NORMAL    25      V_NOCHANGE  0
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_VideoMode( nRows , nCols )

/*****************************************************************************
 Purpose - Set the video mode
 Returns - .T. if completed succesfully
 Author  - Log
 Created - 11/12/92
******************************************************************************
 Parameters - nRows - Number of rows
              nCols - Number of cols
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

IF !SETMODE( nRows , nCols )
    GT_Warning( { "Could not change screen mode to " + STR( nRows , 2 ) + ;
                                              " by " + STR( nCols , 2 ) } )
    RETURN( .F. )
ELSE
    RETURN( .T. )
ENDIF

RETURN NIL
*
