;  File......: SYSREQ.ASM
;  Author....: Andy M Leighton
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Andy Leighton
;  Date......: $Date$
;  Revision..: $Rev$
;
;  This is an original work by Andy Leighton and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_ISSYSRQ()
;   $CATEGORY$
;       Keyboard
;   $ONELINER$
;       Checks SYSRQ key
;   $SYNTAX$
;       GT_isSysRq() --> lRet
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       lRet    -       TRUE if SysRq is being pressed, otherwise FALSE
;   $DESCRIPTION$
;       Checks status of the SysRq Key (ALT-PRTSCR)
;       Can anyone tell me what this key is supposed to do?
;   $EXAMPLES$
;       if GT_isSysRq()
;           ? "Get your grubby fingers off the sysrq key."
;       endif
;   $END$
;

; This has been written using TASM
; If you are using MASM you might have to change things
; around a little
; look for comments telling you what to do
;

;MASM   remove next line

                IDEAL


Public          GT_ISSYSRQ

Extrn           __RetL:Far

;MASM change next line to
;               GtLibrary       SEGMENT WORD  "CODE"
Segment         GtLibrary       Word    "CODE"
                Assume          CS:GtLibrary

;MASM change next line to
;               GT_ISSYSRQ      PROC FAR
Proc            GT_ISSYSRQ      Far

                PUSH    ES                         ; save for later

; set up ES:[BX] to point to the address 0x00000418
                MOV     AX,40H
                MOV     ES,AX
                MOV     BX,18H

                XOR     AH,AH                      ; Clear high byte of AX
                MOV     AL,BYTE PTR ES:[BX]        ; Get keyboard flags 2
                AND     AL,04H                     ; isolate bit 3
                PUSH    AX
                CALL    __RETL                     ; set up CLIPPER return
                ADD     SP, 2                      ; reset stack ptr
                POP     ES                         ; restore ES
                RET

;MASM change next line to
;               GT_ISSYSRQ      ENDP
EndP            GT_ISSYSRQ

;MASM change next line to
;               GtLibrary       ENDS
EndS            GtLibrary

                End
