/*
 * File......: SHADOW.C
 * Author....: Ian 'UnNamedDude' Day (L&W Computer Services Ltd.)
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Ian Day
 * Date......: 02-25-92
 * Revision..: 1.0
 * Log file..: N/A
 *
 * This is an original work by [Ian Day] and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * 04-30-93
 * Initial Release
 */

/*  $DOC$
 *  $FUNCNAME$
 *     GT_CSHADOW()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     'C' Shadow routine that works with DISPBEGIN()/DISPEND()
 *  $SYNTAX$
 *     GT_CShadow(<nTop>, <nBottom>, <nLeft>, <nRight>) --> NIL
 *  $ARGUMENTS$
 *     <nTop> Top of box
 *
 *     <nLeft> Left of box
 *
 *     <nBottom> Bottom of box
 *
 *     <nRight> Right of box
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     Draws a shadow around a box area (1 character on bottom and 2 on the
 *     right.
 *
 *     Note: The module also includes a C/ASM callable function equivelant
 *           in the form of:
 *
 *              void gt_Shadow (int t, int l, int b, int r);
 *  $EXAMPLES$
 *     @ 10, 20 TO 16, 60 DOUBLE
 *     GT_CShadow(10, 20, 16, 60)
 *  $SEEALSO$
 *     GT_COLORWIN()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "extend.h"

void gt_Shadow (int t, int l, int b, int r);
static void ShadowConv (char * string);

/*͸
  Function gt_cShadow(<nTop>, <nLeft>, <nBottom>, <nRight>)                
  Purpose  Draw shadow (1 on bottom, 2 on right) [Uses internals]          
  Author   Ian Day                                                         
  Date&Time04-30-93 05:15pm                                                
  ;*/
CLIPPER gt_cshadow()
{
   gt_Shadow (_parni (1), _parni (2), _parni (3), _parni (4));
   _ret ();
}

void gt_Shadow (int t, int l, int b, int r)
{
   char * string;

   string = _xgrab (320);   /* Maximum we're ever likely to need */

   _gtSave (b + 1, l + 2, b + 1, r, string);
   ShadowConv (string);
   _gtRest (b + 1, l + 2, b + 1, r, string);

   _gtSave (t + 1, r + 1, b + 1, r + 2, string);
   ShadowConv (string);
   _gtRest (t + 1, r + 1, b + 1, r + 2, string);

   _xfree (string);
}

static void ShadowConv (char * string)
{
   register int loop;

   for (loop = 1; loop < 320; loop += 2) {
      if (string[loop] < 0x80)
         string[loop] &= (char)0x07;
      else
         string[loop] &= (char)0x77;
   }
}
