/*
 * File......: PEEKSTRZ.C
 * Author....: David Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 25/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "GT_Mem.H"
#include <Extend.H>

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_PEEKSTZ()
 *  $CATEGORY$
 *      Memory
 *  $ONELINER$
 *      Get a NULL terminated string from memory.
 *  $SYNTAX$
 *      GT_PeekStZ(<nSegment>,<nOffset>) --> cString
 *  $ARGUMENTS$
 *      <nSegment> is the segment of the string in memory.
 *
 *      <nOffset>  is the offset of the string in memory.
 *  $RETURNS$
 *      The NULL terminated string found at <nSegment>:<nOffset>.
 *  $DESCRIPTION$
 *      GT_PeekStZ() can be used for getting NULL terminated strings from
 *      specific areas of memory.
 *  $EXAMPLES$
 *      // Print the first entry in the program's environment table.
 *
 *      ? GT_PeekStZ(GT_PeekW(GT_PSPSeg(),44),0)
 *  $SEEALSO$
 *      GT_PEEKSTN()
 *  $END$
 */

CLIPPER GT_PeekStZ()
{
        if (PCOUNT == 2 && ISNUM(1) && ISNUM(2))
        {
                _retc((char *)_GT_MK_FP(_parni(1),_parni(2)));
        }
        else
        {
                _retc("");
        }
}
