/*
 * File......: PEEKBYTE.C
 * Author....: David Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 30/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "GT_Mem.H"
#include <Extend.H>

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_PEEKB()
 *  $CATEGORY$
 *      Memory
 *  $ONELINER$
 *      Return the contents of a byte in memory.
 *  $SYNTAX$
 *      GT_PeekB(<nSegment>,<nOffset>) --> nByte
 *  $ARGUMENTS$
 *      <nSegment> is the segment of the byte in memory.
 *
 *      <nOffset> is the offset of the byte in memory.
 *  $RETURNS$
 *      The numeric content of the specified byte in memory.
 *  $DESCRIPTION$
 *      GT_PeekB() can be used for getting numeric byte values from
 *      specific locations in memory.
 *  $EXAMPLES$
 *      // Check if Caps Lock is active.
 *
 *      nKeyboard := GT_PeekB(0,1047)
 *      ? "Caps Lock is "+if(GT_And(nKeyboard,64) == 0,"Off","On")
 *  $SEEALSO$
 *      GT_PEEKW()
 *  $END$
 */

CLIPPER GT_PeekB()
{
        if (PCOUNT == 2 && ISNUM(1) && ISNUM(2))
        {
                _retni((unsigned char)_GT_peekb(_parnl(1),_parnl(2)));
        }
        else
        {
                _retni(0);
        }
}
