/*
 * File......: LUPDATE.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_LUPDATE()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Get the date of a DBF last change.
 *  $SYNTAX$
 *      GT_LUpDate(<cFileName>) --> dModification
 *  $ARGUMENTS$
 *      <cFileName> is the name of the DBF file. If the name has no
 *      extension it defaults to DBF.
 *  $RETURNS$
 *      The date that the DBF file was last changed.
 *  $DESCRIPTION$
 *      GT_LUpDate() is designed to be the same as the Clipper function
 *      LUpDate(). The main change is that it works on un-opened database
 *      files.
 *  $EXAMPLES$
 *      // Print the date that a DBF file was changed.
 *
 *      ? GT_LUpDate("Life")
 *  $END$
 */

function GT_LUpdate(cFileName)
local nFile   := 0    ,;
      cDate   := "   ",;
      dUpdate := ctod("")
if valtype(cFileName) == TYPE_CHAR
   if GT_IsDbf(cFileName)
      cFileName := GT_DefExt(cFileName,"Dbf")
      if (nFile := fopen(cFileName,FO_READ)) != F_ERROR
         fseek(nFile,1,FS_SET)
         if fread(nFile,@cDate,3) == 3
            dUpdate := GT_SToD(alltrim(str(1900+asc(substr(cDate,1,1))))+;
                               padl(asc(substr(cDate,2,1)),2,"0")+;
                               padl(asc(substr(cDate,3)),2,"0"))
         endif
         fclose(nFile)
      endif
   endif
endif
return(dUpdate)
