/*
 * File......: GT_Lower.ch
 * Author....: Niall Scott
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Niall Scott
 * Date......: 29/06/93
 * Revision..: 1.0
 * Log file..: $Logfile$
 *
 * This is an original work by Niall R Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Rev 1.0  29/06/93
 * Initial Revision
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_LOWERR()
 *  $CATEGORY$
 *      Wrappers/Errors
 *  $ONELINER$
 *      Handle low level file access errors
 *  $SYNTAX$
 *      GT_LOWERR()
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *	Wrapper to connect low level file functions e.g. Fopen()
 *	to standard Clipper error system.
 *  $EXAMPLES$
 *        FUNCTION DiscErr()
 *            Local oOldHandler
 *            Local nTries := 0
 *            Local nAns
 *            local aArrErr
 *    
 *           // Set up the New handler and pass old handler as a parameter
 *           bNewHandler := {|e| ErrDisc(e, bOldHandler)}
 *           bOldHandler := ErrorBlock(bNewHandler)
 *    
 *            WHILE (.t.)
 *                BEGIN SEQUENCE
 *    
 *                    // Floppy disc access here
 *                    fopen('a:\missing.zxy')
 *    
 *                    //For low Level functions that don't normally use the
 *                    // error system
 *                     GT_LOWERR()
 *    
 *                    // This is the recovery section of the Begin/End Sequence
 *                    // construct.  A BREAK statement got us to this point.
 *                RECOVER USING aErrArr
 *    
 *                    // Allow the user three attempts
 *                    if nTries++ < 3
 *                        ...
 *                        ...
 *                        ...
 *                        // Your recovery code
 *                        ...
 *                        ...
 *                        ...
 *                        Do Case
 *                        Case nAns == 2
 *                            EXIT
 *                        Case nAns == 3
 *                            QUIT
 *                        EndCase
 *                    ENDIF
 *                END SEQUENCE
 *            ENDDO
 *        RETURN NIL
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

// Wrapper to enable use of error system with low level
// file functions
#xtranslate GT_LOWERR() =>  IF Ferror() > 0 				;;
				   kError := ErrorBlock()		;;
				   oError := errornew()  		;;
                                   oError:genCode       := 21           ;;
                                   oError:osCode        := Ferror()     ;;
                                   Eval(kError, oError) 		;;
				   Endif

