/*
    File......: GT_Locking.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_LOCKING()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Function to lock a datafile/record and return the success
 *  $SYNTAX$
 *       GT_Locking(<lFile>,[<nSeconds>],[<nPause>]) -> lSuccess
 *  $ARGUMENTS$
 *      <lFile> is a logical switch, .T. = Lock the file
 *      and .F. is just the record.
 *
 *      <nSeconds> is the number of seconds to wait before
 *      giving up.
 *
 *      <nPause> is thetime interval to pause for before a
 *      retry.
 *  $RETURNS$
 *      GT_Locking() returns logical success.
 *  $DESCRIPTION$
 *      Function to lock a datafile/record and return the
 *      success. If at first it fails it will wait the
 *      specified number of seconds before aborting.
 *  $EXAMPLES$
 *      // Reset a counter
 *      IF GT_Locking(.F.,60,0.5)
 *          Field->Count := 0
 *      ELSE
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

#define HEIGHT  06
#define WIDTH   16

FUNCTION GT_Locking(lFile,nSeconds,nPause)

LOCAL cScreen := ''
LOCAL lMessage := .F.
LOCAL lSuccess := .F.
LOCAL nBottom := INT((MAXROW() + HEIGHT)/2)
LOCAL nKey := 0
LOCAL nLeft := INT((MAXCOL() - WIDTH)/2)
LOCAL nRight := nLeft - WIDTH
LOCAL nTop := nBottom - HEIGHT

Default lFile to .F.
Default nSeconds to 120
Default nPause to 0.5

DO WHILE nSeconds > 0 .AND. (.NOT. lSuccess) .AND. ;
    (nKey != K_ESC)

    // Attempt lock
    lSuccess := IF(lFile,FLOCK(),RLOCK())

    IF .NOT. lSuccess

        // Message ?
        IF .NOT. lMessage

            // Save
            cScreen := SAVESCREEN(nTop,nLeft,nBottom,nRight)

            // Display
            GT_Window(nTop,nLeft,nBottom,nRight,BOX_SS, ;
                NIL,'Locking ....',.T.)

            // Position for message
            @ nTop+02, nLeft+02 SAY 'Timeout:'
            @ nTop+04, nLeft+02 SAY PADC('EscExit',WIDTH-03)

            lMessage := .T.

        ENDIF

        @ nTop+02, nLeft+09 SAY PADR(INT(nSeconds),3)

        // Wait
        nKey := INKEY(nPause)
        nSeconds -= nPause

    ENDIF

ENDDO

IF lMessage
    RESTSCREEN(nTop,nLeft,nBottom,nRight,cScreen)
ENDIF

/*
    End of GT_Locking()
*/
RETURN(lSuccess)
