/*
    File......: GT_GoTop.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_GOTOP()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Move the filepointer to the first record
 *  $SYNTAX$
 *      GT_GoTop([<bWhile>],[<bFor>],[<bFind>]) -> NIL
 *  $ARGUMENTS$
 *      <bWhile> Code block giving a while clause.
 *
 *      <bFor> Code block giving a for clause.
 *
 *      <bFind> Code block giving a value to compare against
 *      the index. Acts as a form of while clause.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Reposition the filepointer to the first record given
 *      a for/while clause.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_GoTop(bWhile,bFor,bFind)

LOCAL lFault := .F.

Default bWhile to { | | .T. }
Default bFor to { | | .T. }
Default bFind to NIL

//  Find first item not legal
IF bFind = NIL
    DBGOTOP()
ELSE
    DBSEEK(EVAL(bFind))
ENDIF

BEGIN SEQUENCE
    DbEVAL({ || BREAK(NIL) } ;
        ,bFor ;
        ,bWhile)
    lFault := .T.

END SEQUENCE

//  OK ?
IF lFault
    DBGOTO(LASTREC()+1)
ENDIF

/*
    End of GT_GoTop()
*/
RETURN(NIL)

