/*
 File......: GT_ERNAM.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ERNAM()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Show a DOS error message
 *  $SYNTAX$
 *      GT_ErNam( <nError> ) --> <cErrorMess>
 *  $ARGUMENTS$
 *      <nError>      A valid DOS error number. Could be the value
 *                    returned by FERROR()
 *  $RETURNS$
 *      <cErrorMess>  The description of the error message.
 *                    Default "".
 *  $DESCRIPTION$
 *      Function used to return a text description of a DOS error number up
 *      to dos error number 88.
 *  $EXAMPLES$
 *      local nErr
 *      Fopen("exist.not")
 *      if ( nErr := ferror() ) > 0
 *          ? GT_ErNam(nErr) --> "File not found"
 *      endif
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"

//================
function GT_ErNam (nError)
//================
/*
returns the name of a DOS error number
*/
local cError := "",nPos := 0
static aErrors
if aErrors == NIL
    aErrors := { {0,"No error"},;
        {1,"Invalid function number"},{2,"File not found"},{3,"Path not found"},;
        {4,"Too many open files"},{5,"Access denied"},{6,"Invalid handle"},;
        {7,"MCB's destroyed"},{8,"Insufficient memory"},{9,"Invalid memory address"},;
        {10,"Invalid environment"},{11,"Invalid format"},{12,"Invalid access code"},;
        {13,"Invalid data"},{14,"Reserved Error"},{15,"Invalid drive"},;
        {16,"Removal of current directory"},{17,"Not same device"},{18,"No more files"},;
        {19,"Write protected"},{20,"Unknown unit"},{21,"Drive not ready"},;
        {22,"Unknown command"},{23,"CRC Error"},{24,"Bad request structure length"},;
        {25,"Seek error"},{26,"Unknown media type"},{27,"Sector not found"},;
        {28,"Printer out of paper"},{29,"Write Fault"},{30,"Read fault"},;
        {31,"General failure"},{32,"Sharing violation"},;
        {33,"Lock violation"},{34,"Invalid disk change"},{35,"FCB unavailable"},;
        {36,"Sharing buffer overflow"},{37,"Reserved"},{38,"Reserved"},{39,"Reserved"},;
        {40,"Reserved"},{41,"Reserved"},{42,"Reserved"}, {43,"Reserved"}, {44,"Reserved"},;
        {45,"Reserved"},{46,"Reserved"},{47,"Reserved"},{48,"Reserved"},{49,"Reserved"},;
        {50,"Network request not supported"},{51,"Remote computer not listening"},;
        {52,"Duplicate name on network"},{53,"Network name not found"},;
        {54,"Network busy"},{55,"Network device no longer exists"},;
        {56,"Network BIOS limit exceeded"},{57,"Network hardware adapter error"},;
        {58,"Incorrect response from network"},{59,"Unexpected network error"},;
        {60,"Incompatible remote adapter"},{61,"Print queue full"},;
        {62,"Not enough space for print files"},{63,"Print file deleted"},;
        {64,"Network name deleted"},{65,"Access denied"},;
        {66,"Network device type incorrect"},{67,"Network name not found"},;
        {68,"Network name limit exceeded"},{69,"Network BIOS session exceeded"},;
        {70,"Temporarily paused"},{71,"Network request not accepted"},;
        {72,"Print or disk redirection paused"},{73,"Reserved"},;
        {74,"Reserved"},;
        {75,"Reserved"},;
        {76,"Reserved"},;
        {77,"Reserved"},;
        {78,"Reserved"},;
        {79,"Reserved"},;
        {80,"File already exists"},;
        {81,"Reserved"},;
        {82,"Cannot make directory entry"},;
        {83,"Fail on INT24H"},;
        {84,"Too many redirections"},;
        {85,"Duplicate redirection"},;
        {86,"Invalid password"},;
        {87,"Invalid parameter"},;
        {88,"Network device fault"} }
    // and thats all I'm prepared to type !
endif

if (nPos := ascan(aErrors,{| aSingle | aSingle[1] == nError } ) ) > 0
    cError := aErrors[nPos][2]
else
    cError := ""
endif
return cError
