/*
 * File......: GT_BOW.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *		GT_BOW()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *		Return the data for the start of the week ( Monday )
 *  $SYNTAX$
 *		GT_BOW( <dValue> ) - dValue
 *  $ARGUMENTS$
 *		<dValue> is a valid date
 *
 *  $RETURNS$
 *		A date value for the begining of the week ( Monday )
 *
 *	$DESCRIPTION$
 *		GT_BOW() can be used to return the first working day
 *
 *  $EXAMPLES$
 *
 *
 *	   ? "Monday's date was", GT_BOW( DATE() )
 *
 *	   result :
 *				Moday's date was 03/25/93
 *
 *	$END$
 */

*/
#include "gt_lib.ch"       // used to pre-process DEFAULT

FUNCTION GT_BOW( dValue )

   DEFAULT dValue TO DATE()

RETURN ( dValue - DOW( dValue ) + 2 )
