/*
    File......: GT_AskUser.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ASKUSER()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Ask the user a question
 *  $SYNTAX$
 *      GT_AskUser(<cMessage>,<aKeys>,[<cTitle>], ;
 *                 [<cColour>],[<cBox>],[<nTop>],[<nLeft>], ;
 *                 [<nBottom>],[<nRight>],[<nSeconds>]) ;
 *      -> nResponce
 *  $ARGUMENTS$
 *      <cMessage> is the message to display.
 *
 *      <aKeys> is an array of legal INKEY() values
 *
 *      <cTitle> is an optional title.
 *
 *      <cColour> is an optional colour string.
 *
 *      <cBox> are optional box lines.
 *
 *      <nTop>,<nLeft>,<nBottom> and <nRight> fix the position
 *      of the window.
 *
 *      <nSeconds> is the time to wait for a responce.
 *  $RETURNS$
 *      nResponce
 *  $DESCRIPTION$
 *      To display a message, ask the user a question, wait
 *      for a responce and restore the screen.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_AskUser(cMessage,aKeys,cTitle,cColour,cBox,nTop, ;
    nLeft,nBottom,nRight,nSeconds)

LOCAL cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
LOCAL nKey := 0
LOCAL nCursor := GT_NoCursor()

Default cMessage to 'Yes or No ?'
Default aKeys to {ASC('N'),ASC('Y'),ASC('n'),ASC('y')}
Default cTitle to ''
Default cColour to SETCOLOR()
Default cBox to BOX_SS
Default nTop to -1
Default nLeft to -1
Default nBottom to -1
Default nRight to -1
Default nSeconds to 120

//  Message
GT_Message(cMessage,cTitle,cColour,cBox,nTop,nLeft, ;
    nBottom,nRight)

DO WHILE (ASCAN(aKeys,nKey) = 0)

    // Wait for key press
    nKey := INKEY(nSeconds)

    IF nKey = 0
        nKey := aKeys[1]
    ENDIF

ENDDO

//  Reset
RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
SETCURSOR(nCursor)

/*
    End of GT_AskUser()
*/
RETURN(nKey)

