/*
 * File......: FSAMEROW.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_SAMEFROW()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Output text to file on current row
 *  $SYNTAX$
 *      GT_SameFRow( nColPos , cWhat , nLeftMgn , nHandle )
 *  $ARGUMENTS$
 *      nColPos  - Colum to output text at
 *      cWhat    - Text to be output
 *      nLeftMgn - Left margin of text
 *      nHandle  - Handle for binary file
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Outputs the text to a binary file, padded out by spaces.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.CH"

FUNCTION GT_SameFRow( nColPos , cWhat , nLeftMgn , nHandle )

/*****************************************************************************
 Purpose - Output text to file on current row
 Returns - None
 Author  - Martin Colloby
 Created - March 1992
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - nColPos  - Colum to output text at
              cWhat    - Text to be output
              nLeftMgn - Left margin of text
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

* Move the pointer to the start of this line
LOCAL cChar   := " "
LOCAL nBackup := 0

DEFAULT nColPos TO 0
DEFAULT cWhat   TO ""
DEFAULT nHandle TO -1

DO WHILE .T.
    cChar := " "
    FREAD( nHandle , @cChar , 1 )
    IF cChar == CHR(K_LF)
        EXIT
    ENDIF
    FSEEK( nHandle , -1 , 1 )
    nBackup ++
ENDDO

* Find the end of the file
FSEEK( nHandle , 0 , 2 )

IF nBackup < nColPos
    FWRITE( nHandle , SPACE( nColPos - nBackup ) )
ENDIF

* Write the text
FWRITE( nHandle , cWhat )

RETURN NIL
*
