;  File......: CTRL.ASM
;  Author....: Andy M Leighton
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Andy Leighton
;  Date......: $Date$
;  Revision..: $Rev$
;
;  This is an original work by Andy Leighton and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_ISCTRL()
;   $CATEGORY$
;       Keyboard
;   $ONELINER$
;       Checks Control key
;   $SYNTAX$
;       GT_isCtrl() --> lRet
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       lRet    -       TRUE if Ctrl is being pressed, otherwise FALSE
;   $DESCRIPTION$
;       Checks status of the Ctrl Key
;   $EXAMPLES$
;       if GT_isCtrl()
;           ? "Get your grubby fingers off the control key."
;       endif
;   $END$
;

; This has been written using TASM
; If you are using MASM you might have to change things
; around a little
; look for comments telling you what to do
;

;MASM   remove next line

                IDEAL


Public          GT_ISCTRL

Extrn           __RetL:Far

;MASM change next line to
;               GtLibrary       SEGMENT WORD  "CODE"
Segment         GtLibrary       Word    "CODE"
                Assume          CS:GtLibrary

;MASM change next line to
;               GT_ISCTRL       PROC FAR
Proc            GT_ISCTRL       Far

                PUSH    ES                         ; save for later
; set up ES:[BX] to point to the address 0x00000417
                MOV     AX,40H
                MOV     ES,AX
                MOV     BX,17H

                XOR     AH,AH                      ; Clear high byte of AX
                MOV     AL,BYTE PTR ES:[BX]        ; Get keyboard flags
                AND     AL,04H                     ; isolate bit 3
                PUSH    AX
                CALL    __RETL                     ; set up CLIPPER return
                ADD     SP, 2                      ; reset stack ptr
                POP     ES                         ; restore ES
                RET

;MASM change next line to
;               GT_ISCTRL       ENDP
EndP            GT_ISCTRL

;MASM change next line to
;               GtLibrary       ENDS
EndS            GtLibrary

                End
