/*
 * File......: COLORWIN.C
 * Author....: Ian 'UnNamedDude' Day (L&W Computer Services Ltd.)
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Ian Day
 * Date......: 02-25-92
 * Revision..: 1.0
 * Log file..: N/A
 *
 * This is an original work by Ian Day and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * 04-30-93
 * Initial Release
 */

/*  $DOC$
 *  $FUNCNAME$
 *     GT_COLORWIN()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Colours an area of the screen.
 *  $SYNTAX$
 *     GT_ColorWin(<nTop>, <nBottom>, <nLeft>, <nRight>,;
 *              <cNewColor>|<nNewColor>, [<cOldColor>|<nOldColor>]) --> NIL
 *  $ARGUMENTS$
 *     <nTop> Top of box
 *
 *     <nLeft> Left of box
 *
 *     <nBottom> Bottom of box
 *
 *     <nRight> Right of box
 *
 *     <cNewColor>|<nNewColor> Can be a clipper colour string or an integer
 *     attribute to paint the area with.
 *
 *     <cOldColor>|<nOldColor> Can be a clipper colour string or an integer
 *     attribute to indicate which colour to paint over.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     Paints an area of the screen in a specified colour, optionally
 *     only over a specified colour.
 *
 *     Note: The module also includes a C/ASM callable function equivelant
 *           in the form of:
 *
 *              void gt_Colorwin (unsigned t, unsigned l, unsigned b,;
 *                                unsigned r, int c1, int c2);
 *  $EXAMPLES$
 *     // This example will draw a box in two colours and the paint the box
 *     // lines in white on red by replacing only the white on blue
 *     SetColor("W+/B")
 *     @ 10, 20 TO 16, 60 DOUBLE
 *     SetColor("GR+/B")
 *     @ 11, 21 CLEAR TO 15, 59
 *     GT_ColorWin(10, 20, 16, 60, "W+/R", "W+/B")
 *
 *     // This will paint the whole box in one colour
 *     GT_ColorWin(10, 20, 16, 60, "W+/G")
 *  $SEEALSO$
 *     GT_CSHADOW()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "extend.h"

void gt_Colorwin (unsigned t, unsigned l, unsigned b, unsigned r, int c1, int c2);
static void ColorwinConv (char * string, unsigned size, int c1, int c2);

/*͸
  Function gt_ColorWin(<nTop>, <nLeft>, <nBottom>, <nRight>, ;             
             <cNewColor>|<nNewColor>, <cColorToReplace>|<nColorToReplace>) 
  Purpose  Change colour of area on screen                                 
  Author   Ian Day                                                         
  Date&Time04-30-93 05:15pm                                                
  ;*/
CLIPPER gt_colorwi()
{
   int colour1, colour2;

   if (ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) && (ISNUM(5) || ISCHAR(5))) {
      if (ISNUM(5))
         colour1 = _parni (5);
      else
         colour1 = ColorToN (_parc (5));

      if (ISNUM(6))
         colour2 = _parni (6);
      else if (ISCHAR(6))
         colour2 = ColorToN (_parc (6));
      else
         colour2 = -1;

      gt_Colorwin (_parni (1), _parni (2), _parni (3), _parni (4), colour1, colour2);
   }

   _ret ();
}

void gt_Colorwin (unsigned t, unsigned l, unsigned b, unsigned r, int c1, int c2)
{
   char * string;
   unsigned size = (((r - l + 1) * (b - t + 1)) * 2);

   string = _xgrab (size);   /* Maximum we're ever likely to need */

   _gtSave (t, l, b, r, string);
   ColorwinConv (string, size, c1, c2);
   _gtRest (t, l, b, r, string);

   _xfree (string);
}

static void ColorwinConv (char * string, unsigned size, int c1, int c2)
{
   register unsigned loop;

   for (loop = 1; loop < size; loop += 2) {
      if (c2 == -1 || string[loop] == (char)c2)
         string[loop] = (char)c1;
   }
}
