/*
 * File......: COLORSET.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_COLORSET()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Change/return the colour setting
 *  $SYNTAX$
 *      GT_ColorSet( nColorNum , cNewColor )
 *  $ARGUMENTS$
 *      nColorNum - Colour number to be addressed
 *      cNewColor - Optional new colour string
 *  $RETURNS$
 *      The current colour setting
 *  $DESCRIPTION$
 *      Returns the current setting of the given colour area.
 *      If cNewColor is passed, the given colour setting is changed to
 *      cNewColor.
 *      GT_LIB.CH contains #define values for the available colour areas.
 *  $EXAMPLES$
 *      Change the first colour setting to "W+/R" :
 *
 *          nColour := GT_ColorSet( 1 , "W+/R" )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
FUNCTION GT_ColorSet( nColorNum , cNewColor )

/*****************************************************************************
 Purpose - Change the current colour setting
 Returns - The previous colour setting
 Author  - Martin Colloby
 Edited  - 29/7/92 by Log - Added C_REVERSE colour - "B/W"
           24/9/92 by Log - Changed return parameter to a numeric
******************************************************************************
 Parameters - nColorNum - Colour number to change to
              cNewColor - New colour string for array
 Privates   - None
 Locals     - cCurrent  - Current color setting as a string
 Externals  - None
*****************************************************************************/

STATIC aColors := { "W+/B", "BG+/B", "GR+/B", "R/B", "W+/BG", "W+/R", "G+/B", "B/W" }

LOCAL cCurrent := ""

/* Change applicable color setting if second parameter was passed */
IF cNewColor != NIL
   aColors[nColorNum] := cNewColor
ENDIF

* Get the current color setting
cCurrent := SET( _SET_COLOR , aColors[nColorNum] )

RETURN ASCAN( aColors , SUBSTR( cCurrent , 1 , AT( "," , cCurrent ) - 1 ) )
*
