/*
 * File......: ARRASKIP.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ARRAYSKIP()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      General purpose TBrowse skip routine for arrays
 *  $SYNTAX$
 *      GT_ArraySkip( nArrayLen , nNumber )
 *  $ARGUMENTS$
 *      aArrayLen - Length of the array
 *      nNumber   - Number of positions to skip
 *  $RETURNS$
 *      Number of positions skipped
 *  $DESCRIPTION$
 *      This function acts as a general purpose skip utility for array based
 *      TBrowses.
 *  $EXAMPLES$
 *      Skip forward one record in an array of ten elements :
 *
 *          nSkipped := GT_ArraySkip( 10 , 1 )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

MEMVAR nRecord

FUNCTION GT_ArraySkip( nArrayLen , nNumber )

/*****************************************************************************
 Purpose - General purpose array skipping function intended for
           use with TBrowse b:SkipBlocks.
 Returns - None
 Author  - Log
 Created - 15/01/93
******************************************************************************
 Parameters - None
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL nActual := 0

IF nNumber >= 0                             //Moving forward ?
    IF ( nRecord + nNumber ) > nArrayLen    //Can't go that far !
        nActual := nArrayLen - nRecord      //Actual is whatever is left
        nRecord := nArrayLen                //Put pointer at end
    ELSE                                    //Can move the whole distance
        nActual := nNumber                  //Actual is number requested
        nRecord += nNumber                  //Move pointer forward
    ENDIF
ELSE                                        //Moving backward ?
    IF ( nRecord + nNumber ) < 1            //Can't go that far !
        nActual := 1 - nRecord              //Actual is whatever was left
        nRecord := 1                        //Put pointer at top
    ELSE                                    //Can move the whole distance
        nActual := nNumber                  //Actual is number requested
        nRecord += nNumber                  //Move pointer backwards
    ENDIF
ENDIF

RETURN nActual
*
