/*
 * File......: ROMDATE.C
 * Author....: David Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 25/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include <Extend.H>

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_ROMDATE()
 *  $CATEGORY$
 *      System
 *  $ONELINER$
 *      Return the date stamp of the ROM BIOS.
 *  $SYNTAX$
 *      GT_RomDate() --> dRomDate
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      Date stamp of the ROM Bios chip.
 *  $DESCRIPTION$
 *      GT_RomDate() can be used to retrieve the date stamp of the ROM Bios
 *      chip of a machine. Most IBM compitable machines have the date of the
 *      ROM help at a certain location in memory, if you are running your
 *      application on a non-standard machine the date returned may be empty
 *      or may be incorrect.
 *
 *      GT_RomDate() can be used for debugging or could be used to tie your
 *      application to a certain machine (not forgetting that there can
 *      be more than one machine with the same date!).
 *  $EXAMPLES$
 *      // Check that the application has not been moved to another
 *      // machine.
 *
 *      if GT_RomDate() == GT_SToD("19880115")
 *         // Allow access to application.
 *      else
 *         ? "Error: This appliction has been moved to another machine!"
 *      endif
 *  $END$
 */

CLIPPER GT_RomDate(void)
{
        char sRomDate[] = "19YYMMDD";

        sRomDate[2] = *((char *) 0xf000fffb);
        sRomDate[3] = *((char *) 0xf000fffc);
        sRomDate[4] = *((char *) 0xf000fff5);
        sRomDate[5] = *((char *) 0xf000fff6);
        sRomDate[6] = *((char *) 0xf000fff8);
        sRomDate[7] = *((char *) 0xf000fff9);
        _retds(sRomDate);
}
