/*
 * File......: NTOCOLOR.C
 * Author....: Ian 'UnNamedDude' Day (L&W Computer Services Ltd.)
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Ian Day
 * Date......: 02-25-92
 * Revision..: 1.0
 * Log file..: N/A
 *
 * This is an original work by [Ian Day] and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * 04-30-93
 * Initial Release
 */

/*  $DOC$
 *  $FUNCNAME$
 *     GT_NTOCOLOR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Converts numeric attribute to Clipper colour string
 *  $SYNTAX$
 *     GT_NToColor(<nAttribute>) --> <cColourString>
 *  $ARGUMENTS$
 *     <nAttribute> The integer attribute to convert to a Clipper colour
 *     string
 *  $RETURNS$
 *     The Clipper Colour string
 *  $DESCRIPTION$
 *     Converts an attribute numeric into a Clipper colour string
 *
 *     Note: The module also includes a C/ASM callable function equivelant
 *           in the form of:
 *
 *              char * gt_NToColor (int color);
 *  $EXAMPLES$
 *     ? GT_NToColor(31)         // Result: "W+/B"
 *  $SEEALSO$
 *     GT_COLORTON()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "extend.h"

char * gt_NToColor (int color);

/*͸
  Function GT_NToColor(<nAttribute>) --> <cColorString>                    
  Purpose  Convert clipper colour string into an attribute number          
  Author   Ian Day                                                         
  Date&Time04-30-93 05:23pm                                                
  ;*/
CLIPPER gt_ntocolo()
{
   char *string;

   if (ISNUM(1))
      {
      string = gt_NToColor (_parni (1));
      _retc (string);
      }
   else
      _retc ("");
}

/******************************** C Stuff ***********************************/

char * gt_NToColor (int color)
{
   char *string = "       ";
   int pos = 6;
   int temp, loop;

   for (loop = 1 ; loop < 3 ; loop++)
      {
      if (loop == 1)
         temp = color / 16;
      else
         {
         string[pos--] = '/';
         temp = color % 16;
         }

      if (temp - 8 >= 0)
         {
         string[pos--] = (char)(loop == 1 ? '*' : '+');
         temp -= 8;
         }

      if (!temp)
         string[pos--] = 'N';

      if (temp - 7 >= 0)
         {
         string[pos--] = 'W';
         temp -= 7;
         }

      if (temp - 4 >= 0)
         {
         string[pos--] = 'R';
         temp -= 4;
         }

      if (temp - 2 >= 0)
         {
         string[pos--] = 'G';
         temp -= 2;
         }

      if (temp - 1 >= 0)
         string[pos--] = 'B';
      }

   return (string + pos + 1);
}

