/*
 * File......: NETUSE.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_NETUSE()
 *  $CATEGORY$
 *      Network
 *  $ONELINER$
 *      Attempt to USE a dbf with optional retry
 *  $SYNTAX$
 *      GT_NetUse( cDatabase, lOpenMode, nSeconds )
 *  $ARGUMENTS$
 *      cDatabase - Table to open
 *      lOpenMode - Mode to open
 *      nSeconds  - Number of retries allowed - 0 for infinite number
 *  $RETURNS$
 *      .T. if successful, .F. otherwise
 *  $DESCRIPTION$
 *      Attempts to open the table.  If it fails, waits a second and retries.
 *      After nSeconds retries it aborts.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_NetUse( cDatabase, lOpenMode, nSeconds )

/*****************************************************************************
 Purpose - Attempt to USE a dbf with optional retry
 Returns - .T. if successful, .F. otherwise
 Author  - Martin Colloby
 Created - 20/05/92
******************************************************************************
 Parameters - cDatabase - Table to open
              lOpenMode - Mode to open
              nSeconds  - Number of retries allowed
 Privates   - None
 Locals     - lForever - If .T., loop forever
 Externals  - None
*****************************************************************************/

LOCAL lForever := (nSeconds == 0)

DO WHILE (lForever .OR. nSeconds > 0)
    IF lOpenMode
        USE (cDatabase) EXCLUSIVE NEW
    ELSE
        * Shared mode
        USE (cDatabase) SHARED NEW
    ENDIF

    * USE succeeds
    IF .NOT. NETERR()
        RETURN (.T.)
    ENDIF

    * Wait 1 second
    INKEY(1)
    nSeconds := nSeconds - 1

ENDDO

* USE fails
RETURN (.F.)
*
